@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin.inputs

import com.pulumi.alicloud.oos.inputs.GetPatchBaselinesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPatchBaselines.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Patch Baseline IDs. Its element value is same as Patch Baseline Name.
 * @property nameRegex A regex string to filter results by Patch Baseline name.
 * @property operationSystem Operating system type. Valid values: `AliyunLinux`, `Anolis`, `CentOS`, `Debian`, `RedhatEnterpriseLinux`, `Ubuntu`, `Windows`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property shareType Patch baseline sharing type. Valid values: `Private`, `Public`.
 */
public data class GetPatchBaselinesPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val operationSystem: String? = null,
    public val outputFile: String? = null,
    public val shareType: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oos.inputs.GetPatchBaselinesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.oos.inputs.GetPatchBaselinesPlainArgs =
        com.pulumi.alicloud.oos.inputs.GetPatchBaselinesPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .operationSystem(operationSystem?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .shareType(shareType?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPatchBaselinesPlainArgs].
 */
@PulumiTagMarker
public class GetPatchBaselinesPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var operationSystem: String? = null

    private var outputFile: String? = null

    private var shareType: String? = null

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("mpudquocawsurfay")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Patch Baseline IDs. Its element value is same as Patch Baseline Name.
     */
    @JvmName("vjjnciregkjagjbc")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Patch Baseline IDs. Its element value is same as Patch Baseline Name.
     */
    @JvmName("hdhctstgvnorrnqj")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Patch Baseline name.
     */
    @JvmName("airnjvvmixnfafqh")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value Operating system type. Valid values: `AliyunLinux`, `Anolis`, `CentOS`, `Debian`, `RedhatEnterpriseLinux`, `Ubuntu`, `Windows`.
     */
    @JvmName("hyrthdlatwlhqeot")
    public suspend fun operationSystem(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.operationSystem = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("hgydcwtkvujhincm")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Patch baseline sharing type. Valid values: `Private`, `Public`.
     */
    @JvmName("jaoweryeybxywlwa")
    public suspend fun shareType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.shareType = mapped
    }

    internal fun build(): GetPatchBaselinesPlainArgs = GetPatchBaselinesPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        operationSystem = operationSystem,
        outputFile = outputFile,
        shareType = shareType,
    )
}
