@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin.inputs

import com.pulumi.alicloud.oos.inputs.GetSecretParametersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSecretParameters.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Secret Parameter IDs.
 * @property nameRegex A regex string to filter results by Secret Parameter name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceGroupId The ID of the Resource Group.
 * @property secretParameterName The name of the secret parameter.
 * @property sortField
 * @property sortOrder
 * @property tags A mapping of tags to assign to the resource.
 */
public data class GetSecretParametersPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val secretParameterName: String? = null,
    public val sortField: String? = null,
    public val sortOrder: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oos.inputs.GetSecretParametersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.oos.inputs.GetSecretParametersPlainArgs =
        com.pulumi.alicloud.oos.inputs.GetSecretParametersPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .secretParameterName(secretParameterName?.let({ args0 -> args0 }))
            .sortField(sortField?.let({ args0 -> args0 }))
            .sortOrder(sortOrder?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetSecretParametersPlainArgs].
 */
@PulumiTagMarker
public class GetSecretParametersPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var resourceGroupId: String? = null

    private var secretParameterName: String? = null

    private var sortField: String? = null

    private var sortOrder: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("tfgxcxrdoldhvmco")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Secret Parameter IDs.
     */
    @JvmName("hjdpcvepujrjseeu")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Secret Parameter IDs.
     */
    @JvmName("itsmvcvrrbfdbtnp")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Secret Parameter name.
     */
    @JvmName("ibfenohvegjtkluo")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("xjlujfjrbtwbjeda")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the Resource Group.
     */
    @JvmName("rfinjpblydysvndp")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The name of the secret parameter.
     */
    @JvmName("xrmwgnlnktupryuk")
    public suspend fun secretParameterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.secretParameterName = mapped
    }

    /**
     * @param value
     */
    @JvmName("bvvxuqvyseqpcdyy")
    public suspend fun sortField(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sortField = mapped
    }

    /**
     * @param value
     */
    @JvmName("yiwgqrbdschcqijj")
    public suspend fun sortOrder(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sortOrder = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("mfojrqhwmydqdjwh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("xywhywaenywfkekv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetSecretParametersPlainArgs = GetSecretParametersPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        resourceGroupId = resourceGroupId,
        secretParameterName = secretParameterName,
        sortField = sortField,
        sortOrder = sortOrder,
        tags = tags,
    )
}
