@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin.inputs

import com.pulumi.alicloud.oos.inputs.GetTemplatesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTemplates.
 * @property category The category of template.
 * @property createdBy The creator of the template.
 * @property createdDate The template whose creation time is less than or equal to the specified time. The format is: YYYY-MM-DDThh:mm::ssZ.
 * @property createdDateAfter Create a template whose time is greater than or equal to the specified time. The format is: YYYY-MM-DDThh:mm:ssZ.
 * @property hasTrigger Is it triggered successfully.
 * @property ids A list of OOS Template ids. Each element in the list is same as template_name.
 * @property nameRegex A regex string to filter the results by the template_name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property shareType The sharing type of the template. Valid values: `Private`, `Public`.
 * @property sortField Sort field. Valid values: `TotalExecutionCount`, `Popularity`, `TemplateName` and `CreatedDate`. Default to `TotalExecutionCount`.
 * @property sortOrder Sort order. Valid values: `Ascending`, `Descending`. Default to `Descending`
 * @property tags A mapping of tags to assign to the resource.
 * @property templateFormat The format of the template. Valid values: `JSON`, `YAML`.
 * @property templateType The type of OOS Template.
 */
public data class GetTemplatesPlainArgs(
    public val category: String? = null,
    public val createdBy: String? = null,
    public val createdDate: String? = null,
    public val createdDateAfter: String? = null,
    public val hasTrigger: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val shareType: String? = null,
    public val sortField: String? = null,
    public val sortOrder: String? = null,
    public val tags: Map<String, String>? = null,
    public val templateFormat: String? = null,
    public val templateType: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oos.inputs.GetTemplatesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.oos.inputs.GetTemplatesPlainArgs =
        com.pulumi.alicloud.oos.inputs.GetTemplatesPlainArgs.builder()
            .category(category?.let({ args0 -> args0 }))
            .createdBy(createdBy?.let({ args0 -> args0 }))
            .createdDate(createdDate?.let({ args0 -> args0 }))
            .createdDateAfter(createdDateAfter?.let({ args0 -> args0 }))
            .hasTrigger(hasTrigger?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .shareType(shareType?.let({ args0 -> args0 }))
            .sortField(sortField?.let({ args0 -> args0 }))
            .sortOrder(sortOrder?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .templateFormat(templateFormat?.let({ args0 -> args0 }))
            .templateType(templateType?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTemplatesPlainArgs].
 */
@PulumiTagMarker
public class GetTemplatesPlainArgsBuilder internal constructor() {
    private var category: String? = null

    private var createdBy: String? = null

    private var createdDate: String? = null

    private var createdDateAfter: String? = null

    private var hasTrigger: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var shareType: String? = null

    private var sortField: String? = null

    private var sortOrder: String? = null

    private var tags: Map<String, String>? = null

    private var templateFormat: String? = null

    private var templateType: String? = null

    /**
     * @param value The category of template.
     */
    @JvmName("udscjvcsglghhkfr")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.category = mapped
    }

    /**
     * @param value The creator of the template.
     */
    @JvmName("hqfyhbefmbjrwyyr")
    public suspend fun createdBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.createdBy = mapped
    }

    /**
     * @param value The template whose creation time is less than or equal to the specified time. The format is: YYYY-MM-DDThh:mm::ssZ.
     */
    @JvmName("khlksmpbfibryrlw")
    public suspend fun createdDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.createdDate = mapped
    }

    /**
     * @param value Create a template whose time is greater than or equal to the specified time. The format is: YYYY-MM-DDThh:mm:ssZ.
     */
    @JvmName("pccrwetdrxelbgnp")
    public suspend fun createdDateAfter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.createdDateAfter = mapped
    }

    /**
     * @param value Is it triggered successfully.
     */
    @JvmName("qafqxogcrfodktmq")
    public suspend fun hasTrigger(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.hasTrigger = mapped
    }

    /**
     * @param value A list of OOS Template ids. Each element in the list is same as template_name.
     */
    @JvmName("sluvkoryeepqosij")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of OOS Template ids. Each element in the list is same as template_name.
     */
    @JvmName("smswilohgcwhuktq")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter the results by the template_name.
     */
    @JvmName("mkoilgdcvnauynta")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("libpjusinbnjouue")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The sharing type of the template. Valid values: `Private`, `Public`.
     */
    @JvmName("wnsbjyejtibipffn")
    public suspend fun shareType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.shareType = mapped
    }

    /**
     * @param value Sort field. Valid values: `TotalExecutionCount`, `Popularity`, `TemplateName` and `CreatedDate`. Default to `TotalExecutionCount`.
     */
    @JvmName("gxpjxvmcslmpykjk")
    public suspend fun sortField(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sortField = mapped
    }

    /**
     * @param value Sort order. Valid values: `Ascending`, `Descending`. Default to `Descending`
     */
    @JvmName("oqtotuutkppeumcj")
    public suspend fun sortOrder(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sortOrder = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("cfgacuemsqgpmppv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("xlvpboatpimffurc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value The format of the template. Valid values: `JSON`, `YAML`.
     */
    @JvmName("gwgakyfdmnkpkflh")
    public suspend fun templateFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.templateFormat = mapped
    }

    /**
     * @param value The type of OOS Template.
     */
    @JvmName("wovapejpkylsimkx")
    public suspend fun templateType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.templateType = mapped
    }

    internal fun build(): GetTemplatesPlainArgs = GetTemplatesPlainArgs(
        category = category,
        createdBy = createdBy,
        createdDate = createdDate,
        createdDateAfter = createdDateAfter,
        hasTrigger = hasTrigger,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        shareType = shareType,
        sortField = sortField,
        sortOrder = sortOrder,
        tags = tags,
        templateFormat = templateFormat,
        templateType = templateType,
    )
}
