@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property applicationGroupName The name of the Application group.
 * @property applicationName The name of the Application.
 * @property cmsGroupId The ID of the cloud monitor group.
 * @property createTime The Creation time of the resource.
 * @property deployRegionId The region ID of the deployment.
 * @property description Application group description information.
 * @property id The ID of the Application Group. Its value is same as Queue Name.
 * @property importTagKey Label key.
 * @property importTagValue Label value.
 * @property updateTime The Update time of the resource.
 */
public data class GetApplicationGroupsGroup(
    public val applicationGroupName: String,
    public val applicationName: String,
    public val cmsGroupId: String,
    public val createTime: String,
    public val deployRegionId: String,
    public val description: String,
    public val id: String,
    public val importTagKey: String,
    public val importTagValue: String,
    public val updateTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oos.outputs.GetApplicationGroupsGroup): GetApplicationGroupsGroup = GetApplicationGroupsGroup(
            applicationGroupName = javaType.applicationGroupName(),
            applicationName = javaType.applicationName(),
            cmsGroupId = javaType.cmsGroupId(),
            createTime = javaType.createTime(),
            deployRegionId = javaType.deployRegionId(),
            description = javaType.description(),
            id = javaType.id(),
            importTagKey = javaType.importTagKey(),
            importTagValue = javaType.importTagValue(),
            updateTime = javaType.updateTime(),
        )
    }
}
