@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property applicationName The name of the application.
 * @property createTime The Created time of the application.
 * @property description Application group description information.
 * @property id The ID of the Application. The value is formate as <application_name>.
 * @property resourceGroupId The ID of the resource group.
 * @property tags The tag of the resource.
 * @property updateTime The Updated time of the application.
 */
public data class GetApplicationsApplication(
    public val applicationName: String,
    public val createTime: String,
    public val description: String,
    public val id: String,
    public val resourceGroupId: String,
    public val tags: Map<String, String>,
    public val updateTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oos.outputs.GetApplicationsApplication): GetApplicationsApplication = GetApplicationsApplication(
            applicationName = javaType.applicationName(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            id = javaType.id(),
            resourceGroupId = javaType.resourceGroupId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            updateTime = javaType.updateTime(),
        )
    }
}
