@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property category The category of template. Valid: `AlarmTrigger`, `EventTrigger`, `Other` and `TimerTrigger`.
 * @property counters The counters of OOS Execution.
 * @property createDate The time when the execution was created.
 * @property endDate The time when the execution was ended.
 * @property executedBy The user who execute the template.
 * @property executionId ID of the OOS Executions.
 * @property id ID of the OOS Executions.
 * @property isParent Whether to include subtasks.
 * @property mode The mode of OOS Execution. Valid: `Automatic`, `Debug`.
 * @property outputs The outputs of OOS Executions.
 * @property parameters The parameters required by the template
 * @property parentExecutionId The id of parent OOS Execution.
 * @property ramRole The role that executes the current template.
 * @property startDate The time when the template was started.
 * @property status The Status of OOS Execution. Valid: `Cancelled`, `Failed`, `Queued`, `Running`, `Started`, `Success`, `Waiting`.
 * @property statusMessage The message of status.
 * @property statusReason The reason of status.
 * @property templateId The id of execution template.
 * @property templateName The name of execution template.
 * @property templateVersion The version of execution template.
 * @property updateDate The time when the template was updated.
 */
public data class GetExecutionsExecution(
    public val category: String,
    public val counters: String,
    public val createDate: String,
    public val endDate: String,
    public val executedBy: String,
    public val executionId: String,
    public val id: String,
    public val isParent: Boolean,
    public val mode: String,
    public val outputs: String,
    public val parameters: String,
    public val parentExecutionId: String,
    public val ramRole: String,
    public val startDate: String,
    public val status: String,
    public val statusMessage: String,
    public val statusReason: String,
    public val templateId: String,
    public val templateName: String,
    public val templateVersion: String,
    public val updateDate: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oos.outputs.GetExecutionsExecution): GetExecutionsExecution = GetExecutionsExecution(
            category = javaType.category(),
            counters = javaType.counters(),
            createDate = javaType.createDate(),
            endDate = javaType.endDate(),
            executedBy = javaType.executedBy(),
            executionId = javaType.executionId(),
            id = javaType.id(),
            isParent = javaType.isParent(),
            mode = javaType.mode(),
            outputs = javaType.outputs(),
            parameters = javaType.parameters(),
            parentExecutionId = javaType.parentExecutionId(),
            ramRole = javaType.ramRole(),
            startDate = javaType.startDate(),
            status = javaType.status(),
            statusMessage = javaType.statusMessage(),
            statusReason = javaType.statusReason(),
            templateId = javaType.templateId(),
            templateName = javaType.templateName(),
            templateVersion = javaType.templateVersion(),
            updateDate = javaType.updateDate(),
        )
    }
}
