@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getExecutions.
 * @property category
 * @property endDate
 * @property endDateAfter
 * @property executedBy
 * @property executions A list of OOS Executions. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of OOS Execution ids.
 * @property includeChildExecution
 * @property mode
 * @property outputFile
 * @property parentExecutionId
 * @property ramRole
 * @property sortField
 * @property sortOrder
 * @property startDateAfter
 * @property startDateBefore
 * @property status
 * @property tags
 * @property templateName
 */
public data class GetExecutionsResult(
    public val category: String? = null,
    public val endDate: String? = null,
    public val endDateAfter: String? = null,
    public val executedBy: String? = null,
    public val executions: List<GetExecutionsExecution>,
    public val id: String,
    public val ids: List<String>,
    public val includeChildExecution: Boolean? = null,
    public val mode: String? = null,
    public val outputFile: String? = null,
    public val parentExecutionId: String? = null,
    public val ramRole: String? = null,
    public val sortField: String? = null,
    public val sortOrder: String? = null,
    public val startDateAfter: String? = null,
    public val startDateBefore: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val templateName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oos.outputs.GetExecutionsResult): GetExecutionsResult = GetExecutionsResult(
            category = javaType.category().map({ args0 -> args0 }).orElse(null),
            endDate = javaType.endDate().map({ args0 -> args0 }).orElse(null),
            endDateAfter = javaType.endDateAfter().map({ args0 -> args0 }).orElse(null),
            executedBy = javaType.executedBy().map({ args0 -> args0 }).orElse(null),
            executions = javaType.executions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.oos.kotlin.outputs.GetExecutionsExecution.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            includeChildExecution = javaType.includeChildExecution().map({ args0 -> args0 }).orElse(null),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            parentExecutionId = javaType.parentExecutionId().map({ args0 -> args0 }).orElse(null),
            ramRole = javaType.ramRole().map({ args0 -> args0 }).orElse(null),
            sortField = javaType.sortField().map({ args0 -> args0 }).orElse(null),
            sortOrder = javaType.sortOrder().map({ args0 -> args0 }).orElse(null),
            startDateAfter = javaType.startDateAfter().map({ args0 -> args0 }).orElse(null),
            startDateBefore = javaType.startDateBefore().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            templateName = javaType.templateName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
