@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property constraints The constraints of the common parameter.
 * @property createTime The time when the common parameter was created.
 * @property createdBy The user who created the common parameter.
 * @property description The description of the common parameter.
 * @property id The ID of the Parameter. Its value is same as `parameter_name`.
 * @property parameterId The ID of the common parameter.
 * @property parameterName The name of the common parameter.
 * @property parameterVersion The version number of the common parameter.
 * @property resourceGroupId The ID of the Resource Group.
 * @property shareType The share type of the common parameter.
 * @property tags The tag of the resource.
 * @property type The data type of the common parameter.
 * @property updatedBy The user who updated the common parameter.
 * @property updatedDate The time when the common parameter was updated.
 * @property value The value of the common parameter.
 */
public data class GetParametersParameter(
    public val constraints: String,
    public val createTime: String,
    public val createdBy: String,
    public val description: String,
    public val id: String,
    public val parameterId: String,
    public val parameterName: String,
    public val parameterVersion: Int,
    public val resourceGroupId: String,
    public val shareType: String,
    public val tags: Map<String, String>,
    public val type: String,
    public val updatedBy: String,
    public val updatedDate: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oos.outputs.GetParametersParameter): GetParametersParameter = GetParametersParameter(
            constraints = javaType.constraints(),
            createTime = javaType.createTime(),
            createdBy = javaType.createdBy(),
            description = javaType.description(),
            id = javaType.id(),
            parameterId = javaType.parameterId(),
            parameterName = javaType.parameterName(),
            parameterVersion = javaType.parameterVersion(),
            resourceGroupId = javaType.resourceGroupId(),
            shareType = javaType.shareType(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            updatedBy = javaType.updatedBy(),
            updatedDate = javaType.updatedDate(),
            `value` = javaType.`value`(),
        )
    }
}
