@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property approvalRules Accept the rules.
 * @property createTime The create time of patch baselines.
 * @property createdBy The user who created the patch baselines.
 * @property description Patches baseline description information.
 * @property id The ID of the Patch Baseline. Its value is same as `patch_baseline_name`.
 * @property isDefault Whether it is the default patch baseline.
 * @property operationSystem Operating system type.
 * @property patchBaselineId Patch baseline ID.
 * @property patchBaselineName The name of the patch baseline.
 * @property shareType Patch baseline sharing type.
 * @property updatedBy The user who updated the patch baselines.
 * @property updatedDate The update time of patch baselines.
 */
public data class GetPatchBaselinesBaseline(
    public val approvalRules: String,
    public val createTime: String,
    public val createdBy: String,
    public val description: String,
    public val id: String,
    public val isDefault: Boolean,
    public val operationSystem: String,
    public val patchBaselineId: String,
    public val patchBaselineName: String,
    public val shareType: String,
    public val updatedBy: String,
    public val updatedDate: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oos.outputs.GetPatchBaselinesBaseline): GetPatchBaselinesBaseline = GetPatchBaselinesBaseline(
            approvalRules = javaType.approvalRules(),
            createTime = javaType.createTime(),
            createdBy = javaType.createdBy(),
            description = javaType.description(),
            id = javaType.id(),
            isDefault = javaType.isDefault(),
            operationSystem = javaType.operationSystem(),
            patchBaselineId = javaType.patchBaselineId(),
            patchBaselineName = javaType.patchBaselineName(),
            shareType = javaType.shareType(),
            updatedBy = javaType.updatedBy(),
            updatedDate = javaType.updatedDate(),
        )
    }
}
