@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPatchBaselines.
 * @property baselines
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property operationSystem
 * @property outputFile
 * @property shareType
 */
public data class GetPatchBaselinesResult(
    public val baselines: List<GetPatchBaselinesBaseline>,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val operationSystem: String? = null,
    public val outputFile: String? = null,
    public val shareType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oos.outputs.GetPatchBaselinesResult): GetPatchBaselinesResult = GetPatchBaselinesResult(
            baselines = javaType.baselines().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.oos.kotlin.outputs.GetPatchBaselinesBaseline.Companion.toKotlin(args0)
                })
            }),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            operationSystem = javaType.operationSystem().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            shareType = javaType.shareType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
