@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property constraints The constraints of the encryption parameter.
 * @property createTime The time when the encryption parameter was created.
 * @property createdBy The user who created the encryption parameter.
 * @property description The description of the encryption parameter.
 * @property id The ID of the Secret Parameter.
 * @property keyId KeyId of KMS used for encryption.
 * @property parameterVersion The version number of the encryption parameter.
 * @property resourceGroupId The ID of the Resource Group.
 * @property secretParameterId The ID of the encryption parameter.
 * @property secretParameterName The name of the encryption parameter.
 * @property shareType The share type of the encryption parameter.
 * @property tags The tag of the resource.
 * @property type The data type of the encryption parameter.
 * @property updatedBy The user who updated the encryption parameter.
 * @property updatedDate The time when the encryption parameter was updated.
 */
public data class GetSecretParametersParameter(
    public val constraints: String,
    public val createTime: String,
    public val createdBy: String,
    public val description: String,
    public val id: String,
    public val keyId: String,
    public val parameterVersion: Int,
    public val resourceGroupId: String,
    public val secretParameterId: String,
    public val secretParameterName: String,
    public val shareType: String,
    public val tags: Map<String, String>,
    public val type: String,
    public val updatedBy: String,
    public val updatedDate: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oos.outputs.GetSecretParametersParameter): GetSecretParametersParameter = GetSecretParametersParameter(
            constraints = javaType.constraints(),
            createTime = javaType.createTime(),
            createdBy = javaType.createdBy(),
            description = javaType.description(),
            id = javaType.id(),
            keyId = javaType.keyId(),
            parameterVersion = javaType.parameterVersion(),
            resourceGroupId = javaType.resourceGroupId(),
            secretParameterId = javaType.secretParameterId(),
            secretParameterName = javaType.secretParameterName(),
            shareType = javaType.shareType(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            updatedBy = javaType.updatedBy(),
            updatedDate = javaType.updatedDate(),
        )
    }
}
