@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property configureMode The configuration mode.
 * @property createTime The creation time.
 * @property description The description.
 * @property id The ID of the State Configuration.
 * @property parameters The parameters.
 * @property resourceGroupId The ID of the resource group.
 * @property scheduleExpression The schedule expression.
 * @property scheduleType The schedule type.
 * @property stateConfigurationId The ID of the final state configuration.
 * @property tags The tag of the resource.
 * @property targets The target resource.
 * @property templateId The ID of the template.
 * @property templateName The name of the template.
 * @property templateVersion The version of the template.
 * @property updateTime The time when the configuration is updated.
 */
public data class GetStateConfigurationsConfiguration(
    public val configureMode: String,
    public val createTime: String,
    public val description: String,
    public val id: String,
    public val parameters: String,
    public val resourceGroupId: String,
    public val scheduleExpression: String,
    public val scheduleType: String,
    public val stateConfigurationId: String,
    public val tags: Map<String, String>,
    public val targets: String,
    public val templateId: String,
    public val templateName: String,
    public val templateVersion: String,
    public val updateTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oos.outputs.GetStateConfigurationsConfiguration): GetStateConfigurationsConfiguration = GetStateConfigurationsConfiguration(
            configureMode = javaType.configureMode(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            id = javaType.id(),
            parameters = javaType.parameters(),
            resourceGroupId = javaType.resourceGroupId(),
            scheduleExpression = javaType.scheduleExpression(),
            scheduleType = javaType.scheduleType(),
            stateConfigurationId = javaType.stateConfigurationId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targets = javaType.targets(),
            templateId = javaType.templateId(),
            templateName = javaType.templateName(),
            templateVersion = javaType.templateVersion(),
            updateTime = javaType.updateTime(),
        )
    }
}
