@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getTemplates.
 * @property category
 * @property createdBy
 * @property createdDate
 * @property createdDateAfter
 * @property hasTrigger
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of OOS Template ids. Each element in the list is same as template_name.
 * @property nameRegex
 * @property names (Available in v1.114.0+) A list of OOS Template names.
 * @property outputFile
 * @property shareType
 * @property sortField
 * @property sortOrder
 * @property tags
 * @property templateFormat
 * @property templateType
 * @property templates A list of OOS Templates. Each element contains the following attributes:
 */
public data class GetTemplatesResult(
    public val category: String? = null,
    public val createdBy: String? = null,
    public val createdDate: String? = null,
    public val createdDateAfter: String? = null,
    public val hasTrigger: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val shareType: String? = null,
    public val sortField: String? = null,
    public val sortOrder: String? = null,
    public val tags: Map<String, String>? = null,
    public val templateFormat: String? = null,
    public val templateType: String? = null,
    public val templates: List<GetTemplatesTemplate>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oos.outputs.GetTemplatesResult): GetTemplatesResult = GetTemplatesResult(
            category = javaType.category().map({ args0 -> args0 }).orElse(null),
            createdBy = javaType.createdBy().map({ args0 -> args0 }).orElse(null),
            createdDate = javaType.createdDate().map({ args0 -> args0 }).orElse(null),
            createdDateAfter = javaType.createdDateAfter().map({ args0 -> args0 }).orElse(null),
            hasTrigger = javaType.hasTrigger().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            shareType = javaType.shareType().map({ args0 -> args0 }).orElse(null),
            sortField = javaType.sortField().map({ args0 -> args0 }).orElse(null),
            sortOrder = javaType.sortOrder().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            templateFormat = javaType.templateFormat().map({ args0 -> args0 }).orElse(null),
            templateType = javaType.templateType().map({ args0 -> args0 }).orElse(null),
            templates = javaType.templates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.oos.kotlin.outputs.GetTemplatesTemplate.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
