@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oos.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property category The category of template.
 * @property createdBy The creator of the template.
 * @property createdDate The template whose creation time is less than or equal to the specified time. The format is: YYYY-MM-DDThh:mm::ssZ.
 * @property description Description of the OOS Template.
 * @property hasTrigger Is it triggered successfully.
 * @property id ID of the OOS Template. The value is same as template_name.
 * @property shareType The sharing type of the template. Valid values: `Private`, `Public`.
 * @property tags A mapping of tags to assign to the resource.
 * @property templateFormat The format of the template. Valid values: `JSON`, `YAML`.
 * @property templateId ID of the OOS Template resource.
 * @property templateName Name of the OOS Template.
 * @property templateType The type of OOS Template.
 * @property templateVersion Version of the OOS Template.
 * @property updatedBy The user who updated the template.
 * @property updatedDate The time when the template was updated.
 */
public data class GetTemplatesTemplate(
    public val category: String,
    public val createdBy: String,
    public val createdDate: String,
    public val description: String,
    public val hasTrigger: Boolean,
    public val id: String,
    public val shareType: String,
    public val tags: Map<String, String>,
    public val templateFormat: String,
    public val templateId: String,
    public val templateName: String,
    public val templateType: String,
    public val templateVersion: String,
    public val updatedBy: String,
    public val updatedDate: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.oos.outputs.GetTemplatesTemplate): GetTemplatesTemplate = GetTemplatesTemplate(
            category = javaType.category(),
            createdBy = javaType.createdBy(),
            createdDate = javaType.createdDate(),
            description = javaType.description(),
            hasTrigger = javaType.hasTrigger(),
            id = javaType.id(),
            shareType = javaType.shareType(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            templateFormat = javaType.templateFormat(),
            templateId = javaType.templateId(),
            templateName = javaType.templateName(),
            templateType = javaType.templateType(),
            templateVersion = javaType.templateVersion(),
            updatedBy = javaType.updatedBy(),
            updatedDate = javaType.updatedDate(),
        )
    }
}
