@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.opensearch.kotlin

import com.pulumi.alicloud.opensearch.kotlin.outputs.AppGroupOrder
import com.pulumi.alicloud.opensearch.kotlin.outputs.AppGroupQuota
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.opensearch.kotlin.outputs.AppGroupOrder.Companion.toKotlin as appGroupOrderToKotlin
import com.pulumi.alicloud.opensearch.kotlin.outputs.AppGroupQuota.Companion.toKotlin as appGroupQuotaToKotlin

/**
 * Builder for [AppGroup].
 */
@PulumiTagMarker
public class AppGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AppGroupArgs = AppGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AppGroupArgsBuilder.() -> Unit) {
        val builder = AppGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AppGroup {
        val builtJavaResource = com.pulumi.alicloud.opensearch.AppGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AppGroup(builtJavaResource)
    }
}

/**
 * Provides a Open Search App Group resource.
 * For information about Open Search App Group and how to use it, see [What is App Group](https://www.aliyun.com/product/opensearch).
 * > **NOTE:** Available in v1.136.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "name";
 * const _default = new alicloud.opensearch.AppGroup("default", {
 *     appGroupName: name,
 *     paymentType: "PayAsYouGo",
 *     type: "standard",
 *     quota: {
 *         docSize: 1,
 *         computeResource: 20,
 *         spec: "opensearch.share.common",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "name"
 * default = alicloud.opensearch.AppGroup("default",
 *     app_group_name=name,
 *     payment_type="PayAsYouGo",
 *     type="standard",
 *     quota={
 *         "doc_size": 1,
 *         "compute_resource": 20,
 *         "spec": "opensearch.share.common",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "name";
 *     var @default = new AliCloud.OpenSearch.AppGroup("default", new()
 *     {
 *         AppGroupName = name,
 *         PaymentType = "PayAsYouGo",
 *         Type = "standard",
 *         Quota = new AliCloud.OpenSearch.Inputs.AppGroupQuotaArgs
 *         {
 *             DocSize = 1,
 *             ComputeResource = 20,
 *             Spec = "opensearch.share.common",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/opensearch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "name"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := opensearch.NewAppGroup(ctx, "default", &opensearch.AppGroupArgs{
 * 			AppGroupName: pulumi.String(name),
 * 			PaymentType:  pulumi.String("PayAsYouGo"),
 * 			Type:         pulumi.String("standard"),
 * 			Quota: &opensearch.AppGroupQuotaArgs{
 * 				DocSize:         pulumi.Int(1),
 * 				ComputeResource: pulumi.Int(20),
 * 				Spec:            pulumi.String("opensearch.share.common"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.opensearch.AppGroup;
 * import com.pulumi.alicloud.opensearch.AppGroupArgs;
 * import com.pulumi.alicloud.opensearch.inputs.AppGroupQuotaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("name");
 *         var default_ = new AppGroup("default", AppGroupArgs.builder()
 *             .appGroupName(name)
 *             .paymentType("PayAsYouGo")
 *             .type("standard")
 *             .quota(AppGroupQuotaArgs.builder()
 *                 .docSize(1)
 *                 .computeResource(20)
 *                 .spec("opensearch.share.common")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: name
 * resources:
 *   default:
 *     type: alicloud:opensearch:AppGroup
 *     properties:
 *       appGroupName: ${name}
 *       paymentType: PayAsYouGo
 *       type: standard
 *       quota:
 *         docSize: 1
 *         computeResource: 20
 *         spec: opensearch.share.common
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Open Search App Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:opensearch/appGroup:AppGroup example <id>
 * ```
 */
public class AppGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.opensearch.AppGroup,
) : KotlinCustomResource(javaResource, AppGroupMapper) {
    /**
     * Application Group Name.
     */
    public val appGroupName: Output<String>
        get() = javaResource.appGroupName().applyValue({ args0 -> args0 })

    /**
     * Billing model. Valid values:`compute_resource` and `qps`.
     */
    public val chargeWay: Output<String>
        get() = javaResource.chargeWay().applyValue({ args0 -> args0 })

    /**
     * The version of Application Group Name.
     */
    public val currentVersion: Output<String>?
        get() = javaResource.currentVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the resource.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The instance id.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * Order change type. Valid values: `UPGRADE` and `DOWNGRADE`.
     */
    public val orderType: Output<String>
        get() = javaResource.orderType().applyValue({ args0 -> args0 })

    /**
     * Order cycle information. The details see Block order.
     */
    public val orders: Output<List<AppGroupOrder>>?
        get() = javaResource.orders().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> appGroupOrderToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The billing method of the resource. Valid values: `Subscription` and `PayAsYouGo`.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * Quota information.  The details see Block quota.
     */
    public val quota: Output<AppGroupQuota>
        get() = javaResource.quota().applyValue({ args0 ->
            args0.let({ args0 ->
                appGroupQuotaToKotlin(args0)
            })
        })

    /**
     * The status of the resource. Valid values: `producing`,`review_pending`,`config_pending`,`normal`,`frozen`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Application type. Valid Values: `standard`, `enhanced`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AppGroupMapper : ResourceMapper<AppGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.opensearch.AppGroup::class == javaResource::class

    override fun map(javaResource: Resource): AppGroup = AppGroup(
        javaResource as
            com.pulumi.alicloud.opensearch.AppGroup,
    )
}

/**
 * @see [AppGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AppGroup].
 */
public suspend fun appGroup(name: String, block: suspend AppGroupResourceBuilder.() -> Unit): AppGroup {
    val builder = AppGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AppGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun appGroup(name: String): AppGroup {
    val builder = AppGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
