@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.opensearch.kotlin

import com.pulumi.alicloud.opensearch.AppGroupArgs.builder
import com.pulumi.alicloud.opensearch.kotlin.inputs.AppGroupOrderArgs
import com.pulumi.alicloud.opensearch.kotlin.inputs.AppGroupOrderArgsBuilder
import com.pulumi.alicloud.opensearch.kotlin.inputs.AppGroupQuotaArgs
import com.pulumi.alicloud.opensearch.kotlin.inputs.AppGroupQuotaArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Open Search App Group resource.
 * For information about Open Search App Group and how to use it, see [What is App Group](https://www.aliyun.com/product/opensearch).
 * > **NOTE:** Available in v1.136.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "name";
 * const _default = new alicloud.opensearch.AppGroup("default", {
 *     appGroupName: name,
 *     paymentType: "PayAsYouGo",
 *     type: "standard",
 *     quota: {
 *         docSize: 1,
 *         computeResource: 20,
 *         spec: "opensearch.share.common",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "name"
 * default = alicloud.opensearch.AppGroup("default",
 *     app_group_name=name,
 *     payment_type="PayAsYouGo",
 *     type="standard",
 *     quota={
 *         "doc_size": 1,
 *         "compute_resource": 20,
 *         "spec": "opensearch.share.common",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "name";
 *     var @default = new AliCloud.OpenSearch.AppGroup("default", new()
 *     {
 *         AppGroupName = name,
 *         PaymentType = "PayAsYouGo",
 *         Type = "standard",
 *         Quota = new AliCloud.OpenSearch.Inputs.AppGroupQuotaArgs
 *         {
 *             DocSize = 1,
 *             ComputeResource = 20,
 *             Spec = "opensearch.share.common",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/opensearch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "name"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := opensearch.NewAppGroup(ctx, "default", &opensearch.AppGroupArgs{
 * 			AppGroupName: pulumi.String(name),
 * 			PaymentType:  pulumi.String("PayAsYouGo"),
 * 			Type:         pulumi.String("standard"),
 * 			Quota: &opensearch.AppGroupQuotaArgs{
 * 				DocSize:         pulumi.Int(1),
 * 				ComputeResource: pulumi.Int(20),
 * 				Spec:            pulumi.String("opensearch.share.common"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.opensearch.AppGroup;
 * import com.pulumi.alicloud.opensearch.AppGroupArgs;
 * import com.pulumi.alicloud.opensearch.inputs.AppGroupQuotaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("name");
 *         var default_ = new AppGroup("default", AppGroupArgs.builder()
 *             .appGroupName(name)
 *             .paymentType("PayAsYouGo")
 *             .type("standard")
 *             .quota(AppGroupQuotaArgs.builder()
 *                 .docSize(1)
 *                 .computeResource(20)
 *                 .spec("opensearch.share.common")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: name
 * resources:
 *   default:
 *     type: alicloud:opensearch:AppGroup
 *     properties:
 *       appGroupName: ${name}
 *       paymentType: PayAsYouGo
 *       type: standard
 *       quota:
 *         docSize: 1
 *         computeResource: 20
 *         spec: opensearch.share.common
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Open Search App Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:opensearch/appGroup:AppGroup example <id>
 * ```
 * @property appGroupName Application Group Name.
 * @property chargeWay Billing model. Valid values:`compute_resource` and `qps`.
 * @property currentVersion The version of Application Group Name.
 * @property description The description of the resource.
 * @property orderType Order change type. Valid values: `UPGRADE` and `DOWNGRADE`.
 * @property orders Order cycle information. The details see Block order.
 * @property paymentType The billing method of the resource. Valid values: `Subscription` and `PayAsYouGo`.
 * @property quota Quota information.  The details see Block quota.
 * @property type Application type. Valid Values: `standard`, `enhanced`.
 */
public data class AppGroupArgs(
    public val appGroupName: Output<String>? = null,
    public val chargeWay: Output<String>? = null,
    public val currentVersion: Output<String>? = null,
    public val description: Output<String>? = null,
    public val orderType: Output<String>? = null,
    public val orders: Output<List<AppGroupOrderArgs>>? = null,
    public val paymentType: Output<String>? = null,
    public val quota: Output<AppGroupQuotaArgs>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.opensearch.AppGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.opensearch.AppGroupArgs =
        com.pulumi.alicloud.opensearch.AppGroupArgs.builder()
            .appGroupName(appGroupName?.applyValue({ args0 -> args0 }))
            .chargeWay(chargeWay?.applyValue({ args0 -> args0 }))
            .currentVersion(currentVersion?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .orderType(orderType?.applyValue({ args0 -> args0 }))
            .orders(orders?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .quota(quota?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppGroupArgs].
 */
@PulumiTagMarker
public class AppGroupArgsBuilder internal constructor() {
    private var appGroupName: Output<String>? = null

    private var chargeWay: Output<String>? = null

    private var currentVersion: Output<String>? = null

    private var description: Output<String>? = null

    private var orderType: Output<String>? = null

    private var orders: Output<List<AppGroupOrderArgs>>? = null

    private var paymentType: Output<String>? = null

    private var quota: Output<AppGroupQuotaArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value Application Group Name.
     */
    @JvmName("majfnivtghqgaxus")
    public suspend fun appGroupName(`value`: Output<String>) {
        this.appGroupName = value
    }

    /**
     * @param value Billing model. Valid values:`compute_resource` and `qps`.
     */
    @JvmName("fpqgbcyaekmwjkhy")
    public suspend fun chargeWay(`value`: Output<String>) {
        this.chargeWay = value
    }

    /**
     * @param value The version of Application Group Name.
     */
    @JvmName("pwhoqahmmmbjwtlh")
    public suspend fun currentVersion(`value`: Output<String>) {
        this.currentVersion = value
    }

    /**
     * @param value The description of the resource.
     */
    @JvmName("ujaogrgcenoqkbna")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Order change type. Valid values: `UPGRADE` and `DOWNGRADE`.
     */
    @JvmName("smuuplpsqtgconpu")
    public suspend fun orderType(`value`: Output<String>) {
        this.orderType = value
    }

    /**
     * @param value Order cycle information. The details see Block order.
     */
    @JvmName("xmdlbgmvuwnyfepm")
    public suspend fun orders(`value`: Output<List<AppGroupOrderArgs>>) {
        this.orders = value
    }

    @JvmName("fllakbpnuimlfnfy")
    public suspend fun orders(vararg values: Output<AppGroupOrderArgs>) {
        this.orders = Output.all(values.asList())
    }

    /**
     * @param values Order cycle information. The details see Block order.
     */
    @JvmName("erhkeodvtsvihsyp")
    public suspend fun orders(values: List<Output<AppGroupOrderArgs>>) {
        this.orders = Output.all(values)
    }

    /**
     * @param value The billing method of the resource. Valid values: `Subscription` and `PayAsYouGo`.
     */
    @JvmName("rxuiulfuencpbrsj")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value Quota information.  The details see Block quota.
     */
    @JvmName("xelmqltoxnsxyasq")
    public suspend fun quota(`value`: Output<AppGroupQuotaArgs>) {
        this.quota = value
    }

    /**
     * @param value Application type. Valid Values: `standard`, `enhanced`.
     */
    @JvmName("yrnaxphuxqujfmxa")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Application Group Name.
     */
    @JvmName("pdxytwldtamqxxck")
    public suspend fun appGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appGroupName = mapped
    }

    /**
     * @param value Billing model. Valid values:`compute_resource` and `qps`.
     */
    @JvmName("eifiiwrnlobweaog")
    public suspend fun chargeWay(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.chargeWay = mapped
    }

    /**
     * @param value The version of Application Group Name.
     */
    @JvmName("ukpaystedonablty")
    public suspend fun currentVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.currentVersion = mapped
    }

    /**
     * @param value The description of the resource.
     */
    @JvmName("hkgxvpapjrhxwsqg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Order change type. Valid values: `UPGRADE` and `DOWNGRADE`.
     */
    @JvmName("scbjtfsbrxnboady")
    public suspend fun orderType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orderType = mapped
    }

    /**
     * @param value Order cycle information. The details see Block order.
     */
    @JvmName("witwstmsmanmqomp")
    public suspend fun orders(`value`: List<AppGroupOrderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orders = mapped
    }

    /**
     * @param argument Order cycle information. The details see Block order.
     */
    @JvmName("aqtresttbqcsvyox")
    public suspend fun orders(argument: List<suspend AppGroupOrderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AppGroupOrderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.orders = mapped
    }

    /**
     * @param argument Order cycle information. The details see Block order.
     */
    @JvmName("obdqtjsugkptkexb")
    public suspend fun orders(vararg argument: suspend AppGroupOrderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AppGroupOrderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.orders = mapped
    }

    /**
     * @param argument Order cycle information. The details see Block order.
     */
    @JvmName("vtqfgirshkrttqyg")
    public suspend fun orders(argument: suspend AppGroupOrderArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AppGroupOrderArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.orders = mapped
    }

    /**
     * @param values Order cycle information. The details see Block order.
     */
    @JvmName("hjkefghkmkagdkew")
    public suspend fun orders(vararg values: AppGroupOrderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.orders = mapped
    }

    /**
     * @param value The billing method of the resource. Valid values: `Subscription` and `PayAsYouGo`.
     */
    @JvmName("mlpvhuqkmfqmklyo")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value Quota information.  The details see Block quota.
     */
    @JvmName("vwqcfkybmsswpuiy")
    public suspend fun quota(`value`: AppGroupQuotaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quota = mapped
    }

    /**
     * @param argument Quota information.  The details see Block quota.
     */
    @JvmName("xvejlbxqacsniind")
    public suspend fun quota(argument: suspend AppGroupQuotaArgsBuilder.() -> Unit) {
        val toBeMapped = AppGroupQuotaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.quota = mapped
    }

    /**
     * @param value Application type. Valid Values: `standard`, `enhanced`.
     */
    @JvmName("mqnjhxfjcvtkebke")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AppGroupArgs = AppGroupArgs(
        appGroupName = appGroupName,
        chargeWay = chargeWay,
        currentVersion = currentVersion,
        description = description,
        orderType = orderType,
        orders = orders,
        paymentType = paymentType,
        quota = quota,
        type = type,
    )
}
