@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.opensearch.kotlin.inputs

import com.pulumi.alicloud.opensearch.inputs.AppGroupOrderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property autoRenew Whether to renew automatically. It only takes effect when the parameter payment_type takes the value `Subscription`.
 * @property duration Order cycle. The minimum value is not less than 0.
 * @property pricingCycle Order cycle unit. Valid values: `Year` and `Month`.
 */
public data class AppGroupOrderArgs(
    public val autoRenew: Output<Boolean>? = null,
    public val duration: Output<Int>? = null,
    public val pricingCycle: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.opensearch.inputs.AppGroupOrderArgs> {
    override fun toJava(): com.pulumi.alicloud.opensearch.inputs.AppGroupOrderArgs =
        com.pulumi.alicloud.opensearch.inputs.AppGroupOrderArgs.builder()
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .duration(duration?.applyValue({ args0 -> args0 }))
            .pricingCycle(pricingCycle?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppGroupOrderArgs].
 */
@PulumiTagMarker
public class AppGroupOrderArgsBuilder internal constructor() {
    private var autoRenew: Output<Boolean>? = null

    private var duration: Output<Int>? = null

    private var pricingCycle: Output<String>? = null

    /**
     * @param value Whether to renew automatically. It only takes effect when the parameter payment_type takes the value `Subscription`.
     */
    @JvmName("yoggwnednajmwngr")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value Order cycle. The minimum value is not less than 0.
     */
    @JvmName("lmqmyagkwehwhdxl")
    public suspend fun duration(`value`: Output<Int>) {
        this.duration = value
    }

    /**
     * @param value Order cycle unit. Valid values: `Year` and `Month`.
     */
    @JvmName("ystjhnituwdjnafr")
    public suspend fun pricingCycle(`value`: Output<String>) {
        this.pricingCycle = value
    }

    /**
     * @param value Whether to renew automatically. It only takes effect when the parameter payment_type takes the value `Subscription`.
     */
    @JvmName("bbiagsavuqmuyiod")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value Order cycle. The minimum value is not less than 0.
     */
    @JvmName("kfiehhbdjbwitnav")
    public suspend fun duration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value Order cycle unit. Valid values: `Year` and `Month`.
     */
    @JvmName("oakwabhxmxxlhtmd")
    public suspend fun pricingCycle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pricingCycle = mapped
    }

    internal fun build(): AppGroupOrderArgs = AppGroupOrderArgs(
        autoRenew = autoRenew,
        duration = duration,
        pricingCycle = pricingCycle,
    )
}
