@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.opensearch.kotlin.inputs

import com.pulumi.alicloud.opensearch.inputs.AppGroupQuotaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property computeResource Computing resources. Unit: LCU.
 * @property docSize Storage Size. Unit: GB.
 * @property qps Search request. Unit: times/second.
 * @property spec Specification. Valid values:
 * * `opensearch.share.junior`: Entry-level.
 * * `opensearch.share.common`: Shared universal.
 * * `opensearch.share.compute`: Shared computing.
 * * `opensearch.share.storage`: Shared storage type.
 * * `opensearch.private.common`: Exclusive universal type.
 * * `opensearch.private.compute`: Exclusive computing type.
 * * `opensearch.private.storage`: Exclusive storage type
 */
public data class AppGroupQuotaArgs(
    public val computeResource: Output<Int>,
    public val docSize: Output<Int>,
    public val qps: Output<Int>? = null,
    public val spec: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.opensearch.inputs.AppGroupQuotaArgs> {
    override fun toJava(): com.pulumi.alicloud.opensearch.inputs.AppGroupQuotaArgs =
        com.pulumi.alicloud.opensearch.inputs.AppGroupQuotaArgs.builder()
            .computeResource(computeResource.applyValue({ args0 -> args0 }))
            .docSize(docSize.applyValue({ args0 -> args0 }))
            .qps(qps?.applyValue({ args0 -> args0 }))
            .spec(spec.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppGroupQuotaArgs].
 */
@PulumiTagMarker
public class AppGroupQuotaArgsBuilder internal constructor() {
    private var computeResource: Output<Int>? = null

    private var docSize: Output<Int>? = null

    private var qps: Output<Int>? = null

    private var spec: Output<String>? = null

    /**
     * @param value Computing resources. Unit: LCU.
     */
    @JvmName("msxrqpsegylpluuw")
    public suspend fun computeResource(`value`: Output<Int>) {
        this.computeResource = value
    }

    /**
     * @param value Storage Size. Unit: GB.
     */
    @JvmName("vgqevlptuudkbslu")
    public suspend fun docSize(`value`: Output<Int>) {
        this.docSize = value
    }

    /**
     * @param value Search request. Unit: times/second.
     */
    @JvmName("dsminkhovhnnreir")
    public suspend fun qps(`value`: Output<Int>) {
        this.qps = value
    }

    /**
     * @param value Specification. Valid values:
     * * `opensearch.share.junior`: Entry-level.
     * * `opensearch.share.common`: Shared universal.
     * * `opensearch.share.compute`: Shared computing.
     * * `opensearch.share.storage`: Shared storage type.
     * * `opensearch.private.common`: Exclusive universal type.
     * * `opensearch.private.compute`: Exclusive computing type.
     * * `opensearch.private.storage`: Exclusive storage type
     */
    @JvmName("gbtfyophsvfudgqi")
    public suspend fun spec(`value`: Output<String>) {
        this.spec = value
    }

    /**
     * @param value Computing resources. Unit: LCU.
     */
    @JvmName("aurffslgblsbyifx")
    public suspend fun computeResource(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.computeResource = mapped
    }

    /**
     * @param value Storage Size. Unit: GB.
     */
    @JvmName("etyxfmntwbeoopit")
    public suspend fun docSize(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.docSize = mapped
    }

    /**
     * @param value Search request. Unit: times/second.
     */
    @JvmName("cjdaodrjosxqwtsb")
    public suspend fun qps(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qps = mapped
    }

    /**
     * @param value Specification. Valid values:
     * * `opensearch.share.junior`: Entry-level.
     * * `opensearch.share.common`: Shared universal.
     * * `opensearch.share.compute`: Shared computing.
     * * `opensearch.share.storage`: Shared storage type.
     * * `opensearch.private.common`: Exclusive universal type.
     * * `opensearch.private.compute`: Exclusive computing type.
     * * `opensearch.private.storage`: Exclusive storage type
     */
    @JvmName("wpgyapiccokkkufb")
    public suspend fun spec(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.spec = mapped
    }

    internal fun build(): AppGroupQuotaArgs = AppGroupQuotaArgs(
        computeResource = computeResource ?: throw PulumiNullFieldException("computeResource"),
        docSize = docSize ?: throw PulumiNullFieldException("docSize"),
        qps = qps,
        spec = spec ?: throw PulumiNullFieldException("spec"),
    )
}
