@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.opensearch.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property autoRenew Whether to renew automatically. It only takes effect when the parameter payment_type takes the value `Subscription`.
 * @property duration Order cycle. The minimum value is not less than 0.
 * @property pricingCycle Order cycle unit. Valid values: `Year` and `Month`.
 */
public data class AppGroupOrder(
    public val autoRenew: Boolean? = null,
    public val duration: Int? = null,
    public val pricingCycle: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.opensearch.outputs.AppGroupOrder): AppGroupOrder = AppGroupOrder(
            autoRenew = javaType.autoRenew().map({ args0 -> args0 }).orElse(null),
            duration = javaType.duration().map({ args0 -> args0 }).orElse(null),
            pricingCycle = javaType.pricingCycle().map({ args0 -> args0 }).orElse(null),
        )
    }
}
