@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.opensearch.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property computeResource Computing resources. Unit: LCU.
 * @property docSize Storage Size. Unit: GB.
 * @property qps Search request. Unit: times/second.
 * @property spec Specification. Valid values:
 * * `opensearch.share.junior`: Entry-level.
 * * `opensearch.share.common`: Shared universal.
 * * `opensearch.share.compute`: Shared computing.
 * * `opensearch.share.storage`: Shared storage type.
 * * `opensearch.private.common`: Exclusive universal type.
 * * `opensearch.private.compute`: Exclusive computing type.
 * * `opensearch.private.storage`: Exclusive storage type
 */
public data class AppGroupQuota(
    public val computeResource: Int,
    public val docSize: Int,
    public val qps: Int? = null,
    public val spec: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.opensearch.outputs.AppGroupQuota): AppGroupQuota = AppGroupQuota(
            computeResource = javaType.computeResource(),
            docSize = javaType.docSize(),
            qps = javaType.qps().map({ args0 -> args0 }).orElse(null),
            spec = javaType.spec(),
        )
    }
}
