@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.opensearch.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property appGroupId The ID of the App Group.
 * @property appGroupName Application Group Name.
 * @property chargeWay Billing model. Valid values:`compute_resource` and `qps`.
 * @property commodityCode The commodity code.
 * @property createTime The time of creation.
 * @property currentVersion The version of Application Group Name.
 * @property description The description of the resource.
 * @property domain Domain name.
 * @property expireOn Expiration Time.
 * @property firstRankAlgoDeploymentId Coarse deployment ID.
 * @property hasPendingQuotaReviewTask Whether the quota status is under approval. Valid status:
 * @property id
 * @property instanceId The Instance ID.
 * @property lockMode Locked state. Valid status: `Unlock`,`LockByExpiration`,`ManualLock`.
 * @property lockedByExpiration Instance is automatically locked after expiration.
 * @property paymentType The billing method of the resource. Valid values: `Subscription` and `PayAsYouGo`.
 * @property pendingSecondRankAlgoDeploymentId Refine deployment ID in deployment.
 * @property processingOrderId Unfinished order number.
 * @property produced Whether the production is completed. Valid values:
 * @property projectId The Project ID.
 * @property quotas Quota information.
 * @property resourceGroupId The Resource Group ID.
 * @property secondRankAlgoDeploymentId Refine deployment ID.
 * @property status The status of the resource. Valid values: `producing`,`review_pending`,`config_pending`,`normal`,`frozen`.
 * @property switchedTime The Switched time.
 * @property type Application type. Valid Values: `standard`, `enhanced`.
 */
public data class GetAppGroupsGroup(
    public val appGroupId: String,
    public val appGroupName: String,
    public val chargeWay: Int,
    public val commodityCode: String,
    public val createTime: Int,
    public val currentVersion: String,
    public val description: String,
    public val domain: String,
    public val expireOn: String,
    public val firstRankAlgoDeploymentId: Int,
    public val hasPendingQuotaReviewTask: Int,
    public val id: String,
    public val instanceId: String,
    public val lockMode: String,
    public val lockedByExpiration: Int,
    public val paymentType: String,
    public val pendingSecondRankAlgoDeploymentId: Int,
    public val processingOrderId: String,
    public val produced: Int,
    public val projectId: String,
    public val quotas: List<GetAppGroupsGroupQuota>,
    public val resourceGroupId: String,
    public val secondRankAlgoDeploymentId: Int,
    public val status: String,
    public val switchedTime: Int,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.opensearch.outputs.GetAppGroupsGroup): GetAppGroupsGroup = GetAppGroupsGroup(
            appGroupId = javaType.appGroupId(),
            appGroupName = javaType.appGroupName(),
            chargeWay = javaType.chargeWay(),
            commodityCode = javaType.commodityCode(),
            createTime = javaType.createTime(),
            currentVersion = javaType.currentVersion(),
            description = javaType.description(),
            domain = javaType.domain(),
            expireOn = javaType.expireOn(),
            firstRankAlgoDeploymentId = javaType.firstRankAlgoDeploymentId(),
            hasPendingQuotaReviewTask = javaType.hasPendingQuotaReviewTask(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            lockMode = javaType.lockMode(),
            lockedByExpiration = javaType.lockedByExpiration(),
            paymentType = javaType.paymentType(),
            pendingSecondRankAlgoDeploymentId = javaType.pendingSecondRankAlgoDeploymentId(),
            processingOrderId = javaType.processingOrderId(),
            produced = javaType.produced(),
            projectId = javaType.projectId(),
            quotas = javaType.quotas().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.opensearch.kotlin.outputs.GetAppGroupsGroupQuota.Companion.toKotlin(args0)
                })
            }),
            resourceGroupId = javaType.resourceGroupId(),
            secondRankAlgoDeploymentId = javaType.secondRankAlgoDeploymentId(),
            status = javaType.status(),
            switchedTime = javaType.switchedTime(),
            type = javaType.type(),
        )
    }
}
