@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.opensearch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property computeResource Computing resources. Unit: LCU.
 * @property docSize Storage Size. Unit: GB.
 * @property spec Specification. Valid values:
 * * `opensearch.share.junior`: Entry-level.
 * * `opensearch.share.common`: Shared universal.
 * * `opensearch.share.compute`: Shared computing.
 * * `opensearch.share.storage`: Shared storage type.
 * * `opensearch.private.common`: Exclusive universal type.
 * * `opensearch.private.compute`: Exclusive computing type.
 * * `opensearch.private.storage`: Exclusive storage type
 */
public data class GetAppGroupsGroupQuota(
    public val computeResource: String,
    public val docSize: String,
    public val spec: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.opensearch.outputs.GetAppGroupsGroupQuota): GetAppGroupsGroupQuota = GetAppGroupsGroupQuota(
            computeResource = javaType.computeResource(),
            docSize = javaType.docSize(),
            spec = javaType.spec(),
        )
    }
}
