@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AccountPublicAccessBlock].
 */
@PulumiTagMarker
public class AccountPublicAccessBlockResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountPublicAccessBlockArgs = AccountPublicAccessBlockArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountPublicAccessBlockArgsBuilder.() -> Unit) {
        val builder = AccountPublicAccessBlockArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccountPublicAccessBlock {
        val builtJavaResource =
            com.pulumi.alicloud.oss.AccountPublicAccessBlock(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AccountPublicAccessBlock(builtJavaResource)
    }
}

/**
 * Provides a OSS Account Public Access Block resource. Blocking public access at the account level.
 * For information about OSS Account Public Access Block and how to use it, see [What is Account Public Access Block](https://www.alibabacloud.com/help/en/oss/developer-reference/putpublicaccessblock).
 * > **NOTE:** Available since v1.224.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.oss.AccountPublicAccessBlock("default", {blockPublicAccess: true});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.oss.AccountPublicAccessBlock("default", block_public_access=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Oss.AccountPublicAccessBlock("default", new()
 *     {
 *         BlockPublicAccess = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := oss.NewAccountPublicAccessBlock(ctx, "default", &oss.AccountPublicAccessBlockArgs{
 * 			BlockPublicAccess: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.oss.AccountPublicAccessBlock;
 * import com.pulumi.alicloud.oss.AccountPublicAccessBlockArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new AccountPublicAccessBlock("default", AccountPublicAccessBlockArgs.builder()
 *             .blockPublicAccess(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:oss:AccountPublicAccessBlock
 *     properties:
 *       blockPublicAccess: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OSS Account Public Access Block can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oss/accountPublicAccessBlock:AccountPublicAccessBlock example
 * ```
 */
public class AccountPublicAccessBlock internal constructor(
    override val javaResource: com.pulumi.alicloud.oss.AccountPublicAccessBlock,
) : KotlinCustomResource(javaResource, AccountPublicAccessBlockMapper) {
    /**
     * Whether or not AlibabaCloud OSS should block public bucket policies for buckets in this account is enabled.
     */
    public val blockPublicAccess: Output<Boolean>
        get() = javaResource.blockPublicAccess().applyValue({ args0 -> args0 })
}

public object AccountPublicAccessBlockMapper : ResourceMapper<AccountPublicAccessBlock> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.oss.AccountPublicAccessBlock::class == javaResource::class

    override fun map(javaResource: Resource): AccountPublicAccessBlock =
        AccountPublicAccessBlock(javaResource as com.pulumi.alicloud.oss.AccountPublicAccessBlock)
}

/**
 * @see [AccountPublicAccessBlock].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccountPublicAccessBlock].
 */
public suspend fun accountPublicAccessBlock(
    name: String,
    block: suspend AccountPublicAccessBlockResourceBuilder.() -> Unit,
): AccountPublicAccessBlock {
    val builder = AccountPublicAccessBlockResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccountPublicAccessBlock].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accountPublicAccessBlock(name: String): AccountPublicAccessBlock {
    val builder = AccountPublicAccessBlockResourceBuilder()
    builder.name(name)
    return builder.build()
}
