@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin

import com.pulumi.alicloud.oss.kotlin.outputs.BucketAccessMonitor
import com.pulumi.alicloud.oss.kotlin.outputs.BucketCorsRule
import com.pulumi.alicloud.oss.kotlin.outputs.BucketLifecycleRule
import com.pulumi.alicloud.oss.kotlin.outputs.BucketLogging
import com.pulumi.alicloud.oss.kotlin.outputs.BucketRefererConfig
import com.pulumi.alicloud.oss.kotlin.outputs.BucketServerSideEncryptionRule
import com.pulumi.alicloud.oss.kotlin.outputs.BucketTransferAcceleration
import com.pulumi.alicloud.oss.kotlin.outputs.BucketVersioning
import com.pulumi.alicloud.oss.kotlin.outputs.BucketWebsite
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.oss.kotlin.outputs.BucketAccessMonitor.Companion.toKotlin as bucketAccessMonitorToKotlin
import com.pulumi.alicloud.oss.kotlin.outputs.BucketCorsRule.Companion.toKotlin as bucketCorsRuleToKotlin
import com.pulumi.alicloud.oss.kotlin.outputs.BucketLifecycleRule.Companion.toKotlin as bucketLifecycleRuleToKotlin
import com.pulumi.alicloud.oss.kotlin.outputs.BucketLogging.Companion.toKotlin as bucketLoggingToKotlin
import com.pulumi.alicloud.oss.kotlin.outputs.BucketRefererConfig.Companion.toKotlin as bucketRefererConfigToKotlin
import com.pulumi.alicloud.oss.kotlin.outputs.BucketServerSideEncryptionRule.Companion.toKotlin as bucketServerSideEncryptionRuleToKotlin
import com.pulumi.alicloud.oss.kotlin.outputs.BucketTransferAcceleration.Companion.toKotlin as bucketTransferAccelerationToKotlin
import com.pulumi.alicloud.oss.kotlin.outputs.BucketVersioning.Companion.toKotlin as bucketVersioningToKotlin
import com.pulumi.alicloud.oss.kotlin.outputs.BucketWebsite.Companion.toKotlin as bucketWebsiteToKotlin

/**
 * Builder for [Bucket].
 */
@PulumiTagMarker
public class BucketResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketArgs = BucketArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketArgsBuilder.() -> Unit) {
        val builder = BucketArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Bucket {
        val builtJavaResource = com.pulumi.alicloud.oss.Bucket(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Bucket(builtJavaResource)
    }
}

/**
 * Provides a resource to create a oss bucket and set its attribution.
 * > **NOTE:** The bucket namespace is shared by all users of the OSS system. Please set bucket name as unique as possible.
 * > **NOTE:** Available since v1.2.0.
 * ## Example Usage
 * Private Bucket
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const bucket_acl = new alicloud.oss.Bucket("bucket-acl", {
 *     bucket: `example-value-${_default.result}`,
 *     acl: "private",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * bucket_acl = alicloud.oss.Bucket("bucket-acl",
 *     bucket=f"example-value-{default['result']}",
 *     acl="private")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var bucket_acl = new AliCloud.Oss.Bucket("bucket-acl", new()
 *     {
 *         BucketName = $"example-value-{@default.Result}",
 *         Acl = "private",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oss.NewBucket(ctx, "bucket-acl", &oss.BucketArgs{
 * 			Bucket: pulumi.Sprintf("example-value-%v", _default.Result),
 * 			Acl:    pulumi.String("private"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var bucket_acl = new Bucket("bucket-acl", BucketArgs.builder()
 *             .bucket(String.format("example-value-%s", default_.result()))
 *             .acl("private")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   bucket-acl:
 *     type: alicloud:oss:Bucket
 *     properties:
 *       bucket: example-value-${default.result}
 *       acl: private
 * ```
 * <!--End PulumiCodeChooser -->
 * Static Website
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const bucket_website = new alicloud.oss.Bucket("bucket-website", {
 *     bucket: `example-value-${_default.result}`,
 *     website: {
 *         indexDocument: "index.html",
 *         errorDocument: "error.html",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * bucket_website = alicloud.oss.Bucket("bucket-website",
 *     bucket=f"example-value-{default['result']}",
 *     website={
 *         "index_document": "index.html",
 *         "error_document": "error.html",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var bucket_website = new AliCloud.Oss.Bucket("bucket-website", new()
 *     {
 *         BucketName = $"example-value-{@default.Result}",
 *         Website = new AliCloud.Oss.Inputs.BucketWebsiteArgs
 *         {
 *             IndexDocument = "index.html",
 *             ErrorDocument = "error.html",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oss.NewBucket(ctx, "bucket-website", &oss.BucketArgs{
 * 			Bucket: pulumi.Sprintf("example-value-%v", _default.Result),
 * 			Website: &oss.BucketWebsiteArgs{
 * 				IndexDocument: pulumi.String("index.html"),
 * 				ErrorDocument: pulumi.String("error.html"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.oss.inputs.BucketWebsiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var bucket_website = new Bucket("bucket-website", BucketArgs.builder()
 *             .bucket(String.format("example-value-%s", default_.result()))
 *             .website(BucketWebsiteArgs.builder()
 *                 .indexDocument("index.html")
 *                 .errorDocument("error.html")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   bucket-website:
 *     type: alicloud:oss:Bucket
 *     properties:
 *       bucket: example-value-${default.result}
 *       website:
 *         indexDocument: index.html
 *         errorDocument: error.html
 * ```
 * <!--End PulumiCodeChooser -->
 * Enable Logging
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const bucket_target = new alicloud.oss.Bucket("bucket-target", {
 *     bucket: `example-value-${_default.result}`,
 *     acl: "public-read",
 * });
 * const bucket_logging = new alicloud.oss.Bucket("bucket-logging", {
 *     bucket: `example-logging-${_default.result}`,
 *     logging: {
 *         targetBucket: bucket_target.id,
 *         targetPrefix: "log/",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * bucket_target = alicloud.oss.Bucket("bucket-target",
 *     bucket=f"example-value-{default['result']}",
 *     acl="public-read")
 * bucket_logging = alicloud.oss.Bucket("bucket-logging",
 *     bucket=f"example-logging-{default['result']}",
 *     logging={
 *         "target_bucket": bucket_target.id,
 *         "target_prefix": "log/",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var bucket_target = new AliCloud.Oss.Bucket("bucket-target", new()
 *     {
 *         BucketName = $"example-value-{@default.Result}",
 *         Acl = "public-read",
 *     });
 *     var bucket_logging = new AliCloud.Oss.Bucket("bucket-logging", new()
 *     {
 *         BucketName = $"example-logging-{@default.Result}",
 *         Logging = new AliCloud.Oss.Inputs.BucketLoggingArgs
 *         {
 *             TargetBucket = bucket_target.Id,
 *             TargetPrefix = "log/",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oss.NewBucket(ctx, "bucket-target", &oss.BucketArgs{
 * 			Bucket: pulumi.Sprintf("example-value-%v", _default.Result),
 * 			Acl:    pulumi.String("public-read"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oss.NewBucket(ctx, "bucket-logging", &oss.BucketArgs{
 * 			Bucket: pulumi.Sprintf("example-logging-%v", _default.Result),
 * 			Logging: &oss.BucketLoggingTypeArgs{
 * 				TargetBucket: bucket_target.ID(),
 * 				TargetPrefix: pulumi.String("log/"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.oss.inputs.BucketLoggingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var bucket_target = new Bucket("bucket-target", BucketArgs.builder()
 *             .bucket(String.format("example-value-%s", default_.result()))
 *             .acl("public-read")
 *             .build());
 *         var bucket_logging = new Bucket("bucket-logging", BucketArgs.builder()
 *             .bucket(String.format("example-logging-%s", default_.result()))
 *             .logging(BucketLoggingArgs.builder()
 *                 .targetBucket(bucket_target.id())
 *                 .targetPrefix("log/")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   bucket-target:
 *     type: alicloud:oss:Bucket
 *     properties:
 *       bucket: example-value-${default.result}
 *       acl: public-read
 *   bucket-logging:
 *     type: alicloud:oss:Bucket
 *     properties:
 *       bucket: example-logging-${default.result}
 *       logging:
 *         targetBucket: ${["bucket-target"].id}
 *         targetPrefix: log/
 * ```
 * <!--End PulumiCodeChooser -->
 * Referer configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const bucket_referer = new alicloud.oss.Bucket("bucket-referer", {
 *     bucket: `example-value-${_default.result}`,
 *     acl: "private",
 *     refererConfig: {
 *         allowEmpty: false,
 *         referers: [
 *             "http://www.aliyun.com",
 *             "https://www.aliyun.com",
 *         ],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * bucket_referer = alicloud.oss.Bucket("bucket-referer",
 *     bucket=f"example-value-{default['result']}",
 *     acl="private",
 *     referer_config={
 *         "allow_empty": False,
 *         "referers": [
 *             "http://www.aliyun.com",
 *             "https://www.aliyun.com",
 *         ],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var bucket_referer = new AliCloud.Oss.Bucket("bucket-referer", new()
 *     {
 *         BucketName = $"example-value-{@default.Result}",
 *         Acl = "private",
 *         RefererConfig = new AliCloud.Oss.Inputs.BucketRefererConfigArgs
 *         {
 *             AllowEmpty = false,
 *             Referers = new[]
 *             {
 *                 "http://www.aliyun.com",
 *                 "https://www.aliyun.com",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oss.NewBucket(ctx, "bucket-referer", &oss.BucketArgs{
 * 			Bucket: pulumi.Sprintf("example-value-%v", _default.Result),
 * 			Acl:    pulumi.String("private"),
 * 			RefererConfig: &oss.BucketRefererConfigArgs{
 * 				AllowEmpty: pulumi.Bool(false),
 * 				Referers: pulumi.StringArray{
 * 					pulumi.String("http://www.aliyun.com"),
 * 					pulumi.String("https://www.aliyun.com"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.oss.inputs.BucketRefererConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var bucket_referer = new Bucket("bucket-referer", BucketArgs.builder()
 *             .bucket(String.format("example-value-%s", default_.result()))
 *             .acl("private")
 *             .refererConfig(BucketRefererConfigArgs.builder()
 *                 .allowEmpty(false)
 *                 .referers(
 *                     "http://www.aliyun.com",
 *                     "https://www.aliyun.com")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   bucket-referer:
 *     type: alicloud:oss:Bucket
 *     properties:
 *       bucket: example-value-${default.result}
 *       acl: private
 *       refererConfig:
 *         allowEmpty: false
 *         referers:
 *           - http://www.aliyun.com
 *           - https://www.aliyun.com
 * ```
 * <!--End PulumiCodeChooser -->
 * Set lifecycle rule
 * ## Import
 * OSS bucket can be imported using the bucket name, e.g.
 * ```sh
 * $ pulumi import alicloud:oss/bucket:Bucket bucket bucket-12345678
 * ```
 */
public class Bucket internal constructor(
    override val javaResource: com.pulumi.alicloud.oss.Bucket,
) : KotlinCustomResource(javaResource, BucketMapper) {
    /**
     * A access monitor status of a bucket. See `access_monitor` below.
     */
    public val accessMonitor: Output<BucketAccessMonitor>
        get() = javaResource.accessMonitor().applyValue({ args0 ->
            args0.let({ args0 ->
                bucketAccessMonitorToKotlin(args0)
            })
        })

    /**
     * The [canned ACL](https://www.alibabacloud.com/help/doc-detail/31898.htm) to apply. Can be "private", "public-read" and "public-read-write". This property has been deprecated since 1.220.0, please use the resource `alicloud.oss.BucketAcl` instead.
     */
    @Deprecated(
        message = """
  Field 'acl' has been deprecated since provider version 1.220.0. New resource
      'alicloud_oss_bucket_acl' instead.
  """,
    )
    public val acl: Output<String>
        get() = javaResource.acl().applyValue({ args0 -> args0 })

    public val bucket: Output<String>?
        get() = javaResource.bucket().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A rule of  [Cross-Origin Resource Sharing](https://www.alibabacloud.com/help/doc-detail/31903.htm). The items of core rule are no more than 10 for every OSS bucket. See `cors_rule` below.
     */
    public val corsRules: Output<List<BucketCorsRule>>?
        get() = javaResource.corsRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> bucketCorsRuleToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The creation date of the bucket.
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * The extranet access endpoint of the bucket.
     */
    public val extranetEndpoint: Output<String>
        get() = javaResource.extranetEndpoint().applyValue({ args0 -> args0 })

    /**
     * A boolean that indicates all objects should be deleted from the bucket so that the bucket can be destroyed without error. These objects are not recoverable. Defaults to "false".
     */
    public val forceDestroy: Output<Boolean>?
        get() = javaResource.forceDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The intranet access endpoint of the bucket.
     */
    public val intranetEndpoint: Output<String>
        get() = javaResource.intranetEndpoint().applyValue({ args0 -> args0 })

    /**
     * A boolean that indicates lifecycle rules allow prefix overlap.
     */
    public val lifecycleRuleAllowSameActionOverlap: Output<Boolean>?
        get() = javaResource.lifecycleRuleAllowSameActionOverlap().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * A configuration of [object lifecycle management](https://www.alibabacloud.com/help/doc-detail/31904.htm). See `lifecycle_rule` below.
     */
    public val lifecycleRules: Output<List<BucketLifecycleRule>>?
        get() = javaResource.lifecycleRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        bucketLifecycleRuleToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The location of the bucket.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * A Settings of [bucket logging](https://www.alibabacloud.com/help/doc-detail/31900.htm). See `logging` below.
     */
    public val logging: Output<BucketLogging>?
        get() = javaResource.logging().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    bucketLoggingToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The flag of using logging enable container. Defaults true.
     */
    @Deprecated(
        message = """
  Deprecated from 1.37.0. When `logging` is set, the bucket logging will be able.
  """,
    )
    public val loggingIsenable: Output<Boolean>?
        get() = javaResource.loggingIsenable().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The bucket owner.
     */
    public val owner: Output<String>
        get() = javaResource.owner().applyValue({ args0 -> args0 })

    /**
     * Json format text of bucket policy [bucket policy management](https://www.alibabacloud.com/help/doc-detail/100680.htm). This property has been deprecated since 1.220.0, please use the resource `alicloud.oss.BucketPolicy` instead.
     */
    public val policy: Output<String>?
        get() = javaResource.policy().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The [redundancy type](https://www.alibabacloud.com/help/doc-detail/90589.htm) to enable. Can be "LRS", and "ZRS". Defaults to "LRS".
     */
    public val redundancyType: Output<String>?
        get() = javaResource.redundancyType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The configuration of [referer](https://www.alibabacloud.com/help/doc-detail/31901.htm). This property has been deprecated since 1.220.0, please use the resource `alicloud.oss.BucketReferer` instead. See `referer_config` below.
     */
    public val refererConfig: Output<BucketRefererConfig>?
        get() = javaResource.refererConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> bucketRefererConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The ID of the resource group to which the bucket belongs.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * A configuration of server-side encryption. See `server_side_encryption_rule` below.
     */
    public val serverSideEncryptionRule: Output<BucketServerSideEncryptionRule>?
        get() = javaResource.serverSideEncryptionRule().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> bucketServerSideEncryptionRuleToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
     */
    public val storageClass: Output<String>?
        get() = javaResource.storageClass().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A mapping of tags to assign to the bucket. The items are no more than 10 for a bucket.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A transfer acceleration status of a bucket. See `transfer_acceleration` below.
     */
    public val transferAcceleration: Output<BucketTransferAcceleration>?
        get() = javaResource.transferAcceleration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> bucketTransferAccelerationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A state of versioning. See `versioning` below.
     */
    public val versioning: Output<BucketVersioning>?
        get() = javaResource.versioning().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    bucketVersioningToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A website configuration. See `website` below.
     */
    public val website: Output<BucketWebsite>?
        get() = javaResource.website().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    bucketWebsiteToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object BucketMapper : ResourceMapper<Bucket> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.oss.Bucket::class == javaResource::class

    override fun map(javaResource: Resource): Bucket = Bucket(
        javaResource as
            com.pulumi.alicloud.oss.Bucket,
    )
}

/**
 * @see [Bucket].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Bucket].
 */
public suspend fun bucket(name: String, block: suspend BucketResourceBuilder.() -> Unit): Bucket {
    val builder = BucketResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Bucket].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucket(name: String): Bucket {
    val builder = BucketResourceBuilder()
    builder.name(name)
    return builder.build()
}
