@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BucketAccessMonitor].
 */
@PulumiTagMarker
public class BucketAccessMonitorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketAccessMonitorArgs = BucketAccessMonitorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketAccessMonitorArgsBuilder.() -> Unit) {
        val builder = BucketAccessMonitorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BucketAccessMonitor {
        val builtJavaResource = com.pulumi.alicloud.oss.BucketAccessMonitor(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BucketAccessMonitor(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * OSS Bucket Access Monitor can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oss/bucketAccessMonitor:BucketAccessMonitor example <id>
 * ```
 */
public class BucketAccessMonitor internal constructor(
    override val javaResource: com.pulumi.alicloud.oss.BucketAccessMonitor,
) : KotlinCustomResource(javaResource, BucketAccessMonitorMapper) {
    /**
     * The name of the bucket.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to enable access tracking for the bucket. Valid values: Enabled: enables access tracking. Disabled: disables access tracking.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object BucketAccessMonitorMapper : ResourceMapper<BucketAccessMonitor> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.oss.BucketAccessMonitor::class == javaResource::class

    override fun map(javaResource: Resource): BucketAccessMonitor = BucketAccessMonitor(
        javaResource
            as com.pulumi.alicloud.oss.BucketAccessMonitor,
    )
}

/**
 * @see [BucketAccessMonitor].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketAccessMonitor].
 */
public suspend fun bucketAccessMonitor(
    name: String,
    block: suspend BucketAccessMonitorResourceBuilder.() -> Unit,
): BucketAccessMonitor {
    val builder = BucketAccessMonitorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketAccessMonitor].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketAccessMonitor(name: String): BucketAccessMonitor {
    val builder = BucketAccessMonitorResourceBuilder()
    builder.name(name)
    return builder.build()
}
