@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin

import com.pulumi.alicloud.oss.BucketAccessMonitorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * OSS Bucket Access Monitor can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oss/bucketAccessMonitor:BucketAccessMonitor example <id>
 * ```
 * @property bucket The name of the bucket.
 * @property status Specifies whether to enable access tracking for the bucket. Valid values: Enabled: enables access tracking. Disabled: disables access tracking.
 */
public data class BucketAccessMonitorArgs(
    public val bucket: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.BucketAccessMonitorArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.BucketAccessMonitorArgs =
        com.pulumi.alicloud.oss.BucketAccessMonitorArgs.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketAccessMonitorArgs].
 */
@PulumiTagMarker
public class BucketAccessMonitorArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value The name of the bucket.
     */
    @JvmName("arbyfcggiprotrmc")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Specifies whether to enable access tracking for the bucket. Valid values: Enabled: enables access tracking. Disabled: disables access tracking.
     */
    @JvmName("egtewpuxkegowvpt")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The name of the bucket.
     */
    @JvmName("xcrkiwbqfrtisbqf")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Specifies whether to enable access tracking for the bucket. Valid values: Enabled: enables access tracking. Disabled: disables access tracking.
     */
    @JvmName("wlputfwpclmwdlsu")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): BucketAccessMonitorArgs = BucketAccessMonitorArgs(
        bucket = bucket,
        status = status,
    )
}
