@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BucketAcl].
 */
@PulumiTagMarker
public class BucketAclResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketAclArgs = BucketAclArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketAclArgsBuilder.() -> Unit) {
        val builder = BucketAclArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BucketAcl {
        val builtJavaResource = com.pulumi.alicloud.oss.BucketAcl(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BucketAcl(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * OSS Bucket Acl can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oss/bucketAcl:BucketAcl example <id>
 * ```
 */
public class BucketAcl internal constructor(
    override val javaResource: com.pulumi.alicloud.oss.BucketAcl,
) : KotlinCustomResource(javaResource, BucketAclMapper) {
    /**
     * Bucket-level Access Control List (ACL)，Valid values: `private`, `public-read`, `public-read-write`.
     */
    public val acl: Output<String>
        get() = javaResource.acl().applyValue({ args0 -> args0 })

    /**
     * The name of the bucket to which the current ACL configuration belongs.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })
}

public object BucketAclMapper : ResourceMapper<BucketAcl> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.oss.BucketAcl::class == javaResource::class

    override fun map(javaResource: Resource): BucketAcl = BucketAcl(
        javaResource as
            com.pulumi.alicloud.oss.BucketAcl,
    )
}

/**
 * @see [BucketAcl].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketAcl].
 */
public suspend fun bucketAcl(name: String, block: suspend BucketAclResourceBuilder.() -> Unit): BucketAcl {
    val builder = BucketAclResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketAcl].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketAcl(name: String): BucketAcl {
    val builder = BucketAclResourceBuilder()
    builder.name(name)
    return builder.build()
}
