@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin

import com.pulumi.alicloud.oss.BucketAclArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * OSS Bucket Acl can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oss/bucketAcl:BucketAcl example <id>
 * ```
 * @property acl Bucket-level Access Control List (ACL)，Valid values: `private`, `public-read`, `public-read-write`.
 * @property bucket The name of the bucket to which the current ACL configuration belongs.
 */
public data class BucketAclArgs(
    public val acl: Output<String>? = null,
    public val bucket: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.BucketAclArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.BucketAclArgs =
        com.pulumi.alicloud.oss.BucketAclArgs.builder()
            .acl(acl?.applyValue({ args0 -> args0 }))
            .bucket(bucket?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketAclArgs].
 */
@PulumiTagMarker
public class BucketAclArgsBuilder internal constructor() {
    private var acl: Output<String>? = null

    private var bucket: Output<String>? = null

    /**
     * @param value Bucket-level Access Control List (ACL)，Valid values: `private`, `public-read`, `public-read-write`.
     */
    @JvmName("aspgvvlofmcxqwlx")
    public suspend fun acl(`value`: Output<String>) {
        this.acl = value
    }

    /**
     * @param value The name of the bucket to which the current ACL configuration belongs.
     */
    @JvmName("nrxhvbffliwyrbvh")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Bucket-level Access Control List (ACL)，Valid values: `private`, `public-read`, `public-read-write`.
     */
    @JvmName("wwurtvspedhgtvhg")
    public suspend fun acl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acl = mapped
    }

    /**
     * @param value The name of the bucket to which the current ACL configuration belongs.
     */
    @JvmName("jgphwdxdbvcllfto")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    internal fun build(): BucketAclArgs = BucketAclArgs(
        acl = acl,
        bucket = bucket,
    )
}
