@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin

import com.pulumi.alicloud.oss.BucketArgs.builder
import com.pulumi.alicloud.oss.kotlin.inputs.BucketAccessMonitorArgs
import com.pulumi.alicloud.oss.kotlin.inputs.BucketAccessMonitorArgsBuilder
import com.pulumi.alicloud.oss.kotlin.inputs.BucketCorsRuleArgs
import com.pulumi.alicloud.oss.kotlin.inputs.BucketCorsRuleArgsBuilder
import com.pulumi.alicloud.oss.kotlin.inputs.BucketLifecycleRuleArgs
import com.pulumi.alicloud.oss.kotlin.inputs.BucketLifecycleRuleArgsBuilder
import com.pulumi.alicloud.oss.kotlin.inputs.BucketLoggingArgs
import com.pulumi.alicloud.oss.kotlin.inputs.BucketLoggingArgsBuilder
import com.pulumi.alicloud.oss.kotlin.inputs.BucketRefererConfigArgs
import com.pulumi.alicloud.oss.kotlin.inputs.BucketRefererConfigArgsBuilder
import com.pulumi.alicloud.oss.kotlin.inputs.BucketServerSideEncryptionRuleArgs
import com.pulumi.alicloud.oss.kotlin.inputs.BucketServerSideEncryptionRuleArgsBuilder
import com.pulumi.alicloud.oss.kotlin.inputs.BucketTransferAccelerationArgs
import com.pulumi.alicloud.oss.kotlin.inputs.BucketTransferAccelerationArgsBuilder
import com.pulumi.alicloud.oss.kotlin.inputs.BucketVersioningArgs
import com.pulumi.alicloud.oss.kotlin.inputs.BucketVersioningArgsBuilder
import com.pulumi.alicloud.oss.kotlin.inputs.BucketWebsiteArgs
import com.pulumi.alicloud.oss.kotlin.inputs.BucketWebsiteArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to create a oss bucket and set its attribution.
 * > **NOTE:** The bucket namespace is shared by all users of the OSS system. Please set bucket name as unique as possible.
 * > **NOTE:** Available since v1.2.0.
 * ## Example Usage
 * Private Bucket
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const bucket_acl = new alicloud.oss.Bucket("bucket-acl", {
 *     bucket: `example-value-${_default.result}`,
 *     acl: "private",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * bucket_acl = alicloud.oss.Bucket("bucket-acl",
 *     bucket=f"example-value-{default['result']}",
 *     acl="private")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var bucket_acl = new AliCloud.Oss.Bucket("bucket-acl", new()
 *     {
 *         BucketName = $"example-value-{@default.Result}",
 *         Acl = "private",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oss.NewBucket(ctx, "bucket-acl", &oss.BucketArgs{
 * 			Bucket: pulumi.Sprintf("example-value-%v", _default.Result),
 * 			Acl:    pulumi.String("private"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var bucket_acl = new Bucket("bucket-acl", BucketArgs.builder()
 *             .bucket(String.format("example-value-%s", default_.result()))
 *             .acl("private")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   bucket-acl:
 *     type: alicloud:oss:Bucket
 *     properties:
 *       bucket: example-value-${default.result}
 *       acl: private
 * ```
 * <!--End PulumiCodeChooser -->
 * Static Website
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const bucket_website = new alicloud.oss.Bucket("bucket-website", {
 *     bucket: `example-value-${_default.result}`,
 *     website: {
 *         indexDocument: "index.html",
 *         errorDocument: "error.html",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * bucket_website = alicloud.oss.Bucket("bucket-website",
 *     bucket=f"example-value-{default['result']}",
 *     website={
 *         "index_document": "index.html",
 *         "error_document": "error.html",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var bucket_website = new AliCloud.Oss.Bucket("bucket-website", new()
 *     {
 *         BucketName = $"example-value-{@default.Result}",
 *         Website = new AliCloud.Oss.Inputs.BucketWebsiteArgs
 *         {
 *             IndexDocument = "index.html",
 *             ErrorDocument = "error.html",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oss.NewBucket(ctx, "bucket-website", &oss.BucketArgs{
 * 			Bucket: pulumi.Sprintf("example-value-%v", _default.Result),
 * 			Website: &oss.BucketWebsiteArgs{
 * 				IndexDocument: pulumi.String("index.html"),
 * 				ErrorDocument: pulumi.String("error.html"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.oss.inputs.BucketWebsiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var bucket_website = new Bucket("bucket-website", BucketArgs.builder()
 *             .bucket(String.format("example-value-%s", default_.result()))
 *             .website(BucketWebsiteArgs.builder()
 *                 .indexDocument("index.html")
 *                 .errorDocument("error.html")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   bucket-website:
 *     type: alicloud:oss:Bucket
 *     properties:
 *       bucket: example-value-${default.result}
 *       website:
 *         indexDocument: index.html
 *         errorDocument: error.html
 * ```
 * <!--End PulumiCodeChooser -->
 * Enable Logging
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const bucket_target = new alicloud.oss.Bucket("bucket-target", {
 *     bucket: `example-value-${_default.result}`,
 *     acl: "public-read",
 * });
 * const bucket_logging = new alicloud.oss.Bucket("bucket-logging", {
 *     bucket: `example-logging-${_default.result}`,
 *     logging: {
 *         targetBucket: bucket_target.id,
 *         targetPrefix: "log/",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * bucket_target = alicloud.oss.Bucket("bucket-target",
 *     bucket=f"example-value-{default['result']}",
 *     acl="public-read")
 * bucket_logging = alicloud.oss.Bucket("bucket-logging",
 *     bucket=f"example-logging-{default['result']}",
 *     logging={
 *         "target_bucket": bucket_target.id,
 *         "target_prefix": "log/",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var bucket_target = new AliCloud.Oss.Bucket("bucket-target", new()
 *     {
 *         BucketName = $"example-value-{@default.Result}",
 *         Acl = "public-read",
 *     });
 *     var bucket_logging = new AliCloud.Oss.Bucket("bucket-logging", new()
 *     {
 *         BucketName = $"example-logging-{@default.Result}",
 *         Logging = new AliCloud.Oss.Inputs.BucketLoggingArgs
 *         {
 *             TargetBucket = bucket_target.Id,
 *             TargetPrefix = "log/",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oss.NewBucket(ctx, "bucket-target", &oss.BucketArgs{
 * 			Bucket: pulumi.Sprintf("example-value-%v", _default.Result),
 * 			Acl:    pulumi.String("public-read"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oss.NewBucket(ctx, "bucket-logging", &oss.BucketArgs{
 * 			Bucket: pulumi.Sprintf("example-logging-%v", _default.Result),
 * 			Logging: &oss.BucketLoggingTypeArgs{
 * 				TargetBucket: bucket_target.ID(),
 * 				TargetPrefix: pulumi.String("log/"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.oss.inputs.BucketLoggingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var bucket_target = new Bucket("bucket-target", BucketArgs.builder()
 *             .bucket(String.format("example-value-%s", default_.result()))
 *             .acl("public-read")
 *             .build());
 *         var bucket_logging = new Bucket("bucket-logging", BucketArgs.builder()
 *             .bucket(String.format("example-logging-%s", default_.result()))
 *             .logging(BucketLoggingArgs.builder()
 *                 .targetBucket(bucket_target.id())
 *                 .targetPrefix("log/")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   bucket-target:
 *     type: alicloud:oss:Bucket
 *     properties:
 *       bucket: example-value-${default.result}
 *       acl: public-read
 *   bucket-logging:
 *     type: alicloud:oss:Bucket
 *     properties:
 *       bucket: example-logging-${default.result}
 *       logging:
 *         targetBucket: ${["bucket-target"].id}
 *         targetPrefix: log/
 * ```
 * <!--End PulumiCodeChooser -->
 * Referer configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const bucket_referer = new alicloud.oss.Bucket("bucket-referer", {
 *     bucket: `example-value-${_default.result}`,
 *     acl: "private",
 *     refererConfig: {
 *         allowEmpty: false,
 *         referers: [
 *             "http://www.aliyun.com",
 *             "https://www.aliyun.com",
 *         ],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * bucket_referer = alicloud.oss.Bucket("bucket-referer",
 *     bucket=f"example-value-{default['result']}",
 *     acl="private",
 *     referer_config={
 *         "allow_empty": False,
 *         "referers": [
 *             "http://www.aliyun.com",
 *             "https://www.aliyun.com",
 *         ],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var bucket_referer = new AliCloud.Oss.Bucket("bucket-referer", new()
 *     {
 *         BucketName = $"example-value-{@default.Result}",
 *         Acl = "private",
 *         RefererConfig = new AliCloud.Oss.Inputs.BucketRefererConfigArgs
 *         {
 *             AllowEmpty = false,
 *             Referers = new[]
 *             {
 *                 "http://www.aliyun.com",
 *                 "https://www.aliyun.com",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oss.NewBucket(ctx, "bucket-referer", &oss.BucketArgs{
 * 			Bucket: pulumi.Sprintf("example-value-%v", _default.Result),
 * 			Acl:    pulumi.String("private"),
 * 			RefererConfig: &oss.BucketRefererConfigArgs{
 * 				AllowEmpty: pulumi.Bool(false),
 * 				Referers: pulumi.StringArray{
 * 					pulumi.String("http://www.aliyun.com"),
 * 					pulumi.String("https://www.aliyun.com"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.oss.inputs.BucketRefererConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var bucket_referer = new Bucket("bucket-referer", BucketArgs.builder()
 *             .bucket(String.format("example-value-%s", default_.result()))
 *             .acl("private")
 *             .refererConfig(BucketRefererConfigArgs.builder()
 *                 .allowEmpty(false)
 *                 .referers(
 *                     "http://www.aliyun.com",
 *                     "https://www.aliyun.com")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   bucket-referer:
 *     type: alicloud:oss:Bucket
 *     properties:
 *       bucket: example-value-${default.result}
 *       acl: private
 *       refererConfig:
 *         allowEmpty: false
 *         referers:
 *           - http://www.aliyun.com
 *           - https://www.aliyun.com
 * ```
 * <!--End PulumiCodeChooser -->
 * Set lifecycle rule
 * ## Import
 * OSS bucket can be imported using the bucket name, e.g.
 * ```sh
 * $ pulumi import alicloud:oss/bucket:Bucket bucket bucket-12345678
 * ```
 * @property accessMonitor A access monitor status of a bucket. See `access_monitor` below.
 * @property acl The [canned ACL](https://www.alibabacloud.com/help/doc-detail/31898.htm) to apply. Can be "private", "public-read" and "public-read-write". This property has been deprecated since 1.220.0, please use the resource `alicloud.oss.BucketAcl` instead.
 * @property bucket
 * @property corsRules A rule of  [Cross-Origin Resource Sharing](https://www.alibabacloud.com/help/doc-detail/31903.htm). The items of core rule are no more than 10 for every OSS bucket. See `cors_rule` below.
 * @property forceDestroy A boolean that indicates all objects should be deleted from the bucket so that the bucket can be destroyed without error. These objects are not recoverable. Defaults to "false".
 * @property lifecycleRuleAllowSameActionOverlap A boolean that indicates lifecycle rules allow prefix overlap.
 * @property lifecycleRules A configuration of [object lifecycle management](https://www.alibabacloud.com/help/doc-detail/31904.htm). See `lifecycle_rule` below.
 * @property logging A Settings of [bucket logging](https://www.alibabacloud.com/help/doc-detail/31900.htm). See `logging` below.
 * @property loggingIsenable The flag of using logging enable container. Defaults true.
 * @property policy Json format text of bucket policy [bucket policy management](https://www.alibabacloud.com/help/doc-detail/100680.htm). This property has been deprecated since 1.220.0, please use the resource `alicloud.oss.BucketPolicy` instead.
 * @property redundancyType The [redundancy type](https://www.alibabacloud.com/help/doc-detail/90589.htm) to enable. Can be "LRS", and "ZRS". Defaults to "LRS".
 * @property refererConfig The configuration of [referer](https://www.alibabacloud.com/help/doc-detail/31901.htm). This property has been deprecated since 1.220.0, please use the resource `alicloud.oss.BucketReferer` instead. See `referer_config` below.
 * @property resourceGroupId The ID of the resource group to which the bucket belongs.
 * @property serverSideEncryptionRule A configuration of server-side encryption. See `server_side_encryption_rule` below.
 * @property storageClass The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
 * @property tags A mapping of tags to assign to the bucket. The items are no more than 10 for a bucket.
 * @property transferAcceleration A transfer acceleration status of a bucket. See `transfer_acceleration` below.
 * @property versioning A state of versioning. See `versioning` below.
 * @property website A website configuration. See `website` below.
 */
public data class BucketArgs(
    public val accessMonitor: Output<BucketAccessMonitorArgs>? = null,
    @Deprecated(
        message = """
  Field 'acl' has been deprecated since provider version 1.220.0. New resource
      'alicloud_oss_bucket_acl' instead.
  """,
    )
    public val acl: Output<String>? = null,
    public val bucket: Output<String>? = null,
    public val corsRules: Output<List<BucketCorsRuleArgs>>? = null,
    public val forceDestroy: Output<Boolean>? = null,
    public val lifecycleRuleAllowSameActionOverlap: Output<Boolean>? = null,
    public val lifecycleRules: Output<List<BucketLifecycleRuleArgs>>? = null,
    public val logging: Output<BucketLoggingArgs>? = null,
    @Deprecated(
        message = """
  Deprecated from 1.37.0. When `logging` is set, the bucket logging will be able.
  """,
    )
    public val loggingIsenable: Output<Boolean>? = null,
    public val policy: Output<String>? = null,
    public val redundancyType: Output<String>? = null,
    public val refererConfig: Output<BucketRefererConfigArgs>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val serverSideEncryptionRule: Output<BucketServerSideEncryptionRuleArgs>? = null,
    public val storageClass: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transferAcceleration: Output<BucketTransferAccelerationArgs>? = null,
    public val versioning: Output<BucketVersioningArgs>? = null,
    public val website: Output<BucketWebsiteArgs>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.BucketArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.BucketArgs =
        com.pulumi.alicloud.oss.BucketArgs.builder()
            .accessMonitor(accessMonitor?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .acl(acl?.applyValue({ args0 -> args0 }))
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .corsRules(
                corsRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .forceDestroy(forceDestroy?.applyValue({ args0 -> args0 }))
            .lifecycleRuleAllowSameActionOverlap(
                lifecycleRuleAllowSameActionOverlap?.applyValue({ args0 ->
                    args0
                }),
            )
            .lifecycleRules(
                lifecycleRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .logging(logging?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .loggingIsenable(loggingIsenable?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .redundancyType(redundancyType?.applyValue({ args0 -> args0 }))
            .refererConfig(refererConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .serverSideEncryptionRule(
                serverSideEncryptionRule?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .storageClass(storageClass?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transferAcceleration(
                transferAcceleration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .versioning(versioning?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .website(website?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BucketArgs].
 */
@PulumiTagMarker
public class BucketArgsBuilder internal constructor() {
    private var accessMonitor: Output<BucketAccessMonitorArgs>? = null

    private var acl: Output<String>? = null

    private var bucket: Output<String>? = null

    private var corsRules: Output<List<BucketCorsRuleArgs>>? = null

    private var forceDestroy: Output<Boolean>? = null

    private var lifecycleRuleAllowSameActionOverlap: Output<Boolean>? = null

    private var lifecycleRules: Output<List<BucketLifecycleRuleArgs>>? = null

    private var logging: Output<BucketLoggingArgs>? = null

    private var loggingIsenable: Output<Boolean>? = null

    private var policy: Output<String>? = null

    private var redundancyType: Output<String>? = null

    private var refererConfig: Output<BucketRefererConfigArgs>? = null

    private var resourceGroupId: Output<String>? = null

    private var serverSideEncryptionRule: Output<BucketServerSideEncryptionRuleArgs>? = null

    private var storageClass: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transferAcceleration: Output<BucketTransferAccelerationArgs>? = null

    private var versioning: Output<BucketVersioningArgs>? = null

    private var website: Output<BucketWebsiteArgs>? = null

    /**
     * @param value A access monitor status of a bucket. See `access_monitor` below.
     */
    @JvmName("jstybahoalsdjgwf")
    public suspend fun accessMonitor(`value`: Output<BucketAccessMonitorArgs>) {
        this.accessMonitor = value
    }

    /**
     * @param value The [canned ACL](https://www.alibabacloud.com/help/doc-detail/31898.htm) to apply. Can be "private", "public-read" and "public-read-write". This property has been deprecated since 1.220.0, please use the resource `alicloud.oss.BucketAcl` instead.
     */
    @Deprecated(
        message = """
  Field 'acl' has been deprecated since provider version 1.220.0. New resource
      'alicloud_oss_bucket_acl' instead.
  """,
    )
    @JvmName("sadqykvvbqhncvvk")
    public suspend fun acl(`value`: Output<String>) {
        this.acl = value
    }

    /**
     * @param value
     */
    @JvmName("eqlaantgggxxtcyu")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value A rule of  [Cross-Origin Resource Sharing](https://www.alibabacloud.com/help/doc-detail/31903.htm). The items of core rule are no more than 10 for every OSS bucket. See `cors_rule` below.
     */
    @JvmName("gthlythsltpipcug")
    public suspend fun corsRules(`value`: Output<List<BucketCorsRuleArgs>>) {
        this.corsRules = value
    }

    @JvmName("shvputygditjpfgb")
    public suspend fun corsRules(vararg values: Output<BucketCorsRuleArgs>) {
        this.corsRules = Output.all(values.asList())
    }

    /**
     * @param values A rule of  [Cross-Origin Resource Sharing](https://www.alibabacloud.com/help/doc-detail/31903.htm). The items of core rule are no more than 10 for every OSS bucket. See `cors_rule` below.
     */
    @JvmName("swalhxwldvjesayu")
    public suspend fun corsRules(values: List<Output<BucketCorsRuleArgs>>) {
        this.corsRules = Output.all(values)
    }

    /**
     * @param value A boolean that indicates all objects should be deleted from the bucket so that the bucket can be destroyed without error. These objects are not recoverable. Defaults to "false".
     */
    @JvmName("cwhshybaoywowwoe")
    public suspend fun forceDestroy(`value`: Output<Boolean>) {
        this.forceDestroy = value
    }

    /**
     * @param value A boolean that indicates lifecycle rules allow prefix overlap.
     */
    @JvmName("sbfmqyvqsqtvhjnw")
    public suspend fun lifecycleRuleAllowSameActionOverlap(`value`: Output<Boolean>) {
        this.lifecycleRuleAllowSameActionOverlap = value
    }

    /**
     * @param value A configuration of [object lifecycle management](https://www.alibabacloud.com/help/doc-detail/31904.htm). See `lifecycle_rule` below.
     */
    @JvmName("eyodoswpoxmdklch")
    public suspend fun lifecycleRules(`value`: Output<List<BucketLifecycleRuleArgs>>) {
        this.lifecycleRules = value
    }

    @JvmName("ndwtmrhfsvusbehp")
    public suspend fun lifecycleRules(vararg values: Output<BucketLifecycleRuleArgs>) {
        this.lifecycleRules = Output.all(values.asList())
    }

    /**
     * @param values A configuration of [object lifecycle management](https://www.alibabacloud.com/help/doc-detail/31904.htm). See `lifecycle_rule` below.
     */
    @JvmName("hakhbiverbjdfihq")
    public suspend fun lifecycleRules(values: List<Output<BucketLifecycleRuleArgs>>) {
        this.lifecycleRules = Output.all(values)
    }

    /**
     * @param value A Settings of [bucket logging](https://www.alibabacloud.com/help/doc-detail/31900.htm). See `logging` below.
     */
    @JvmName("uxudhmwcasqwlsnm")
    public suspend fun logging(`value`: Output<BucketLoggingArgs>) {
        this.logging = value
    }

    /**
     * @param value The flag of using logging enable container. Defaults true.
     */
    @Deprecated(
        message = """
  Deprecated from 1.37.0. When `logging` is set, the bucket logging will be able.
  """,
    )
    @JvmName("sjonshhwfhlbouwl")
    public suspend fun loggingIsenable(`value`: Output<Boolean>) {
        this.loggingIsenable = value
    }

    /**
     * @param value Json format text of bucket policy [bucket policy management](https://www.alibabacloud.com/help/doc-detail/100680.htm). This property has been deprecated since 1.220.0, please use the resource `alicloud.oss.BucketPolicy` instead.
     */
    @JvmName("ynrnhunsevhhrlrg")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The [redundancy type](https://www.alibabacloud.com/help/doc-detail/90589.htm) to enable. Can be "LRS", and "ZRS". Defaults to "LRS".
     */
    @JvmName("algchximlgjfwgmr")
    public suspend fun redundancyType(`value`: Output<String>) {
        this.redundancyType = value
    }

    /**
     * @param value The configuration of [referer](https://www.alibabacloud.com/help/doc-detail/31901.htm). This property has been deprecated since 1.220.0, please use the resource `alicloud.oss.BucketReferer` instead. See `referer_config` below.
     */
    @JvmName("hlrndajharosfvne")
    public suspend fun refererConfig(`value`: Output<BucketRefererConfigArgs>) {
        this.refererConfig = value
    }

    /**
     * @param value The ID of the resource group to which the bucket belongs.
     */
    @JvmName("ukduxdlugmgqwfsy")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value A configuration of server-side encryption. See `server_side_encryption_rule` below.
     */
    @JvmName("awjrfayddqfedyvl")
    public suspend fun serverSideEncryptionRule(`value`: Output<BucketServerSideEncryptionRuleArgs>) {
        this.serverSideEncryptionRule = value
    }

    /**
     * @param value The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
     */
    @JvmName("jbdjrrwdvbfxecbj")
    public suspend fun storageClass(`value`: Output<String>) {
        this.storageClass = value
    }

    /**
     * @param value A mapping of tags to assign to the bucket. The items are no more than 10 for a bucket.
     */
    @JvmName("uessvujojxqvqpkm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A transfer acceleration status of a bucket. See `transfer_acceleration` below.
     */
    @JvmName("sbngjbkqyqgynaay")
    public suspend fun transferAcceleration(`value`: Output<BucketTransferAccelerationArgs>) {
        this.transferAcceleration = value
    }

    /**
     * @param value A state of versioning. See `versioning` below.
     */
    @JvmName("unkxijchbmfttxlm")
    public suspend fun versioning(`value`: Output<BucketVersioningArgs>) {
        this.versioning = value
    }

    /**
     * @param value A website configuration. See `website` below.
     */
    @JvmName("yamvkjbanbbjkwgp")
    public suspend fun website(`value`: Output<BucketWebsiteArgs>) {
        this.website = value
    }

    /**
     * @param value A access monitor status of a bucket. See `access_monitor` below.
     */
    @JvmName("eyhqiyaegpdtllio")
    public suspend fun accessMonitor(`value`: BucketAccessMonitorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessMonitor = mapped
    }

    /**
     * @param argument A access monitor status of a bucket. See `access_monitor` below.
     */
    @JvmName("cjjdvcvgpnuclegv")
    public suspend fun accessMonitor(argument: suspend BucketAccessMonitorArgsBuilder.() -> Unit) {
        val toBeMapped = BucketAccessMonitorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accessMonitor = mapped
    }

    /**
     * @param value The [canned ACL](https://www.alibabacloud.com/help/doc-detail/31898.htm) to apply. Can be "private", "public-read" and "public-read-write". This property has been deprecated since 1.220.0, please use the resource `alicloud.oss.BucketAcl` instead.
     */
    @Deprecated(
        message = """
  Field 'acl' has been deprecated since provider version 1.220.0. New resource
      'alicloud_oss_bucket_acl' instead.
  """,
    )
    @JvmName("wuuweimvcnvjgshs")
    public suspend fun acl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acl = mapped
    }

    /**
     * @param value
     */
    @JvmName("ruqkgqqjimqaflft")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value A rule of  [Cross-Origin Resource Sharing](https://www.alibabacloud.com/help/doc-detail/31903.htm). The items of core rule are no more than 10 for every OSS bucket. See `cors_rule` below.
     */
    @JvmName("djjrtrdoacssqmpc")
    public suspend fun corsRules(`value`: List<BucketCorsRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.corsRules = mapped
    }

    /**
     * @param argument A rule of  [Cross-Origin Resource Sharing](https://www.alibabacloud.com/help/doc-detail/31903.htm). The items of core rule are no more than 10 for every OSS bucket. See `cors_rule` below.
     */
    @JvmName("fcpcmpdnbmhbnarx")
    public suspend fun corsRules(argument: List<suspend BucketCorsRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketCorsRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.corsRules = mapped
    }

    /**
     * @param argument A rule of  [Cross-Origin Resource Sharing](https://www.alibabacloud.com/help/doc-detail/31903.htm). The items of core rule are no more than 10 for every OSS bucket. See `cors_rule` below.
     */
    @JvmName("ghpffrjhbiqxspwx")
    public suspend fun corsRules(vararg argument: suspend BucketCorsRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BucketCorsRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.corsRules = mapped
    }

    /**
     * @param argument A rule of  [Cross-Origin Resource Sharing](https://www.alibabacloud.com/help/doc-detail/31903.htm). The items of core rule are no more than 10 for every OSS bucket. See `cors_rule` below.
     */
    @JvmName("ypiebmudihkexcnf")
    public suspend fun corsRules(argument: suspend BucketCorsRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BucketCorsRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.corsRules = mapped
    }

    /**
     * @param values A rule of  [Cross-Origin Resource Sharing](https://www.alibabacloud.com/help/doc-detail/31903.htm). The items of core rule are no more than 10 for every OSS bucket. See `cors_rule` below.
     */
    @JvmName("jntnyedvdmaxabkq")
    public suspend fun corsRules(vararg values: BucketCorsRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.corsRules = mapped
    }

    /**
     * @param value A boolean that indicates all objects should be deleted from the bucket so that the bucket can be destroyed without error. These objects are not recoverable. Defaults to "false".
     */
    @JvmName("jsjkyubbbyjxhyoc")
    public suspend fun forceDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDestroy = mapped
    }

    /**
     * @param value A boolean that indicates lifecycle rules allow prefix overlap.
     */
    @JvmName("bjpcbnqkokiewnel")
    public suspend fun lifecycleRuleAllowSameActionOverlap(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleRuleAllowSameActionOverlap = mapped
    }

    /**
     * @param value A configuration of [object lifecycle management](https://www.alibabacloud.com/help/doc-detail/31904.htm). See `lifecycle_rule` below.
     */
    @JvmName("sonaglnqrirwvhuw")
    public suspend fun lifecycleRules(`value`: List<BucketLifecycleRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleRules = mapped
    }

    /**
     * @param argument A configuration of [object lifecycle management](https://www.alibabacloud.com/help/doc-detail/31904.htm). See `lifecycle_rule` below.
     */
    @JvmName("hkcmuauflhvtfnwx")
    public suspend fun lifecycleRules(argument: List<suspend BucketLifecycleRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketLifecycleRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lifecycleRules = mapped
    }

    /**
     * @param argument A configuration of [object lifecycle management](https://www.alibabacloud.com/help/doc-detail/31904.htm). See `lifecycle_rule` below.
     */
    @JvmName("oisyoqwkfukakkjl")
    public suspend fun lifecycleRules(vararg argument: suspend BucketLifecycleRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BucketLifecycleRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lifecycleRules = mapped
    }

    /**
     * @param argument A configuration of [object lifecycle management](https://www.alibabacloud.com/help/doc-detail/31904.htm). See `lifecycle_rule` below.
     */
    @JvmName("rngcgbtgiotsldim")
    public suspend fun lifecycleRules(argument: suspend BucketLifecycleRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BucketLifecycleRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.lifecycleRules = mapped
    }

    /**
     * @param values A configuration of [object lifecycle management](https://www.alibabacloud.com/help/doc-detail/31904.htm). See `lifecycle_rule` below.
     */
    @JvmName("wmxjkjtwqtuuhqqv")
    public suspend fun lifecycleRules(vararg values: BucketLifecycleRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lifecycleRules = mapped
    }

    /**
     * @param value A Settings of [bucket logging](https://www.alibabacloud.com/help/doc-detail/31900.htm). See `logging` below.
     */
    @JvmName("ddnohcchguproamt")
    public suspend fun logging(`value`: BucketLoggingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logging = mapped
    }

    /**
     * @param argument A Settings of [bucket logging](https://www.alibabacloud.com/help/doc-detail/31900.htm). See `logging` below.
     */
    @JvmName("crcmtrnkpnbcpklk")
    public suspend fun logging(argument: suspend BucketLoggingArgsBuilder.() -> Unit) {
        val toBeMapped = BucketLoggingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logging = mapped
    }

    /**
     * @param value The flag of using logging enable container. Defaults true.
     */
    @Deprecated(
        message = """
  Deprecated from 1.37.0. When `logging` is set, the bucket logging will be able.
  """,
    )
    @JvmName("hhvrshkqcvbolicp")
    public suspend fun loggingIsenable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingIsenable = mapped
    }

    /**
     * @param value Json format text of bucket policy [bucket policy management](https://www.alibabacloud.com/help/doc-detail/100680.htm). This property has been deprecated since 1.220.0, please use the resource `alicloud.oss.BucketPolicy` instead.
     */
    @JvmName("neseyrldlwsegtus")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The [redundancy type](https://www.alibabacloud.com/help/doc-detail/90589.htm) to enable. Can be "LRS", and "ZRS". Defaults to "LRS".
     */
    @JvmName("udubvpmwihetysfm")
    public suspend fun redundancyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redundancyType = mapped
    }

    /**
     * @param value The configuration of [referer](https://www.alibabacloud.com/help/doc-detail/31901.htm). This property has been deprecated since 1.220.0, please use the resource `alicloud.oss.BucketReferer` instead. See `referer_config` below.
     */
    @JvmName("yffidneqnqagndow")
    public suspend fun refererConfig(`value`: BucketRefererConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refererConfig = mapped
    }

    /**
     * @param argument The configuration of [referer](https://www.alibabacloud.com/help/doc-detail/31901.htm). This property has been deprecated since 1.220.0, please use the resource `alicloud.oss.BucketReferer` instead. See `referer_config` below.
     */
    @JvmName("ymoqcuqspyffujur")
    public suspend fun refererConfig(argument: suspend BucketRefererConfigArgsBuilder.() -> Unit) {
        val toBeMapped = BucketRefererConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.refererConfig = mapped
    }

    /**
     * @param value The ID of the resource group to which the bucket belongs.
     */
    @JvmName("whdnwoiwhdltykds")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value A configuration of server-side encryption. See `server_side_encryption_rule` below.
     */
    @JvmName("chfcbaewrlmwailu")
    public suspend fun serverSideEncryptionRule(`value`: BucketServerSideEncryptionRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverSideEncryptionRule = mapped
    }

    /**
     * @param argument A configuration of server-side encryption. See `server_side_encryption_rule` below.
     */
    @JvmName("hcshynovtkkdkgyw")
    public suspend fun serverSideEncryptionRule(argument: suspend BucketServerSideEncryptionRuleArgsBuilder.() -> Unit) {
        val toBeMapped = BucketServerSideEncryptionRuleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.serverSideEncryptionRule = mapped
    }

    /**
     * @param value The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
     */
    @JvmName("bbnbcdppanxhtubu")
    public suspend fun storageClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageClass = mapped
    }

    /**
     * @param value A mapping of tags to assign to the bucket. The items are no more than 10 for a bucket.
     */
    @JvmName("gltxfmgdivubmqik")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the bucket. The items are no more than 10 for a bucket.
     */
    @JvmName("dtkfhqgvneaqbnct")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A transfer acceleration status of a bucket. See `transfer_acceleration` below.
     */
    @JvmName("hqcdofdcuqkkfiad")
    public suspend fun transferAcceleration(`value`: BucketTransferAccelerationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transferAcceleration = mapped
    }

    /**
     * @param argument A transfer acceleration status of a bucket. See `transfer_acceleration` below.
     */
    @JvmName("qxqtlnbrhnxohens")
    public suspend fun transferAcceleration(argument: suspend BucketTransferAccelerationArgsBuilder.() -> Unit) {
        val toBeMapped = BucketTransferAccelerationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.transferAcceleration = mapped
    }

    /**
     * @param value A state of versioning. See `versioning` below.
     */
    @JvmName("qxlgpuuccpceqjjg")
    public suspend fun versioning(`value`: BucketVersioningArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versioning = mapped
    }

    /**
     * @param argument A state of versioning. See `versioning` below.
     */
    @JvmName("vwdajrsfmhnjbtbw")
    public suspend fun versioning(argument: suspend BucketVersioningArgsBuilder.() -> Unit) {
        val toBeMapped = BucketVersioningArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.versioning = mapped
    }

    /**
     * @param value A website configuration. See `website` below.
     */
    @JvmName("dmjlacxuaunlfcku")
    public suspend fun website(`value`: BucketWebsiteArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.website = mapped
    }

    /**
     * @param argument A website configuration. See `website` below.
     */
    @JvmName("bjwwgvomaaetfdaj")
    public suspend fun website(argument: suspend BucketWebsiteArgsBuilder.() -> Unit) {
        val toBeMapped = BucketWebsiteArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.website = mapped
    }

    internal fun build(): BucketArgs = BucketArgs(
        accessMonitor = accessMonitor,
        acl = acl,
        bucket = bucket,
        corsRules = corsRules,
        forceDestroy = forceDestroy,
        lifecycleRuleAllowSameActionOverlap = lifecycleRuleAllowSameActionOverlap,
        lifecycleRules = lifecycleRules,
        logging = logging,
        loggingIsenable = loggingIsenable,
        policy = policy,
        redundancyType = redundancyType,
        refererConfig = refererConfig,
        resourceGroupId = resourceGroupId,
        serverSideEncryptionRule = serverSideEncryptionRule,
        storageClass = storageClass,
        tags = tags,
        transferAcceleration = transferAcceleration,
        versioning = versioning,
        website = website,
    )
}
