@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin

import com.pulumi.alicloud.oss.BucketCorsArgs.builder
import com.pulumi.alicloud.oss.kotlin.inputs.BucketCorsCorsRuleArgs
import com.pulumi.alicloud.oss.kotlin.inputs.BucketCorsCorsRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a OSS Bucket Cors resource. Cross-Origin Resource Sharing (CORS) allows web applications to access resources in other regions.
 * For information about OSS Bucket Cors and how to use it, see [What is Bucket Cors](https://www.alibabacloud.com/help/en/).
 * > **NOTE:** Available since v1.223.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new random.index.Uuid("default", {});
 * const createBucket = new alicloud.oss.Bucket("CreateBucket", {
 *     storageClass: "Standard",
 *     bucket: `${name}-${_default.result}`,
 * });
 * const defaultBucketCors = new alicloud.oss.BucketCors("default", {
 *     bucket: createBucket.bucket,
 *     responseVary: true,
 *     corsRules: [{
 *         allowedMethods: ["GET"],
 *         allowedOrigins: ["*"],
 *         allowedHeaders: [
 *             "x-oss-test",
 *             "x-oss-abc",
 *         ],
 *         exposeHeaders: ["x-oss-request-id"],
 *         maxAgeSeconds: 1000,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = random.index.Uuid("default")
 * create_bucket = alicloud.oss.Bucket("CreateBucket",
 *     storage_class="Standard",
 *     bucket=f"{name}-{default['result']}")
 * default_bucket_cors = alicloud.oss.BucketCors("default",
 *     bucket=create_bucket.bucket,
 *     response_vary=True,
 *     cors_rules=[{
 *         "allowed_methods": ["GET"],
 *         "allowed_origins": ["*"],
 *         "allowed_headers": [
 *             "x-oss-test",
 *             "x-oss-abc",
 *         ],
 *         "expose_headers": ["x-oss-request-id"],
 *         "max_age_seconds": 1000,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new Random.Index.Uuid("default");
 *     var createBucket = new AliCloud.Oss.Bucket("CreateBucket", new()
 *     {
 *         StorageClass = "Standard",
 *         BucketName = $"{name}-{@default.Result}",
 *     });
 *     var defaultBucketCors = new AliCloud.Oss.BucketCors("default", new()
 *     {
 *         Bucket = createBucket.BucketName,
 *         ResponseVary = true,
 *         CorsRules = new[]
 *         {
 *             new AliCloud.Oss.Inputs.BucketCorsCorsRuleArgs
 *             {
 *                 AllowedMethods = new[]
 *                 {
 *                     "GET",
 *                 },
 *                 AllowedOrigins = new[]
 *                 {
 *                     "*",
 *                 },
 *                 AllowedHeaders = new[]
 *                 {
 *                     "x-oss-test",
 *                     "x-oss-abc",
 *                 },
 *                 ExposeHeaders = new[]
 *                 {
 *                     "x-oss-request-id",
 *                 },
 *                 MaxAgeSeconds = 1000,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewUuid(ctx, "default", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		createBucket, err := oss.NewBucket(ctx, "CreateBucket", &oss.BucketArgs{
 * 			StorageClass: pulumi.String("Standard"),
 * 			Bucket:       pulumi.Sprintf("%v-%v", name, _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oss.NewBucketCors(ctx, "default", &oss.BucketCorsArgs{
 * 			Bucket:       createBucket.Bucket,
 * 			ResponseVary: pulumi.Bool(true),
 * 			CorsRules: oss.BucketCorsCorsRuleArray{
 * 				&oss.BucketCorsCorsRuleArgs{
 * 					AllowedMethods: pulumi.StringArray{
 * 						pulumi.String("GET"),
 * 					},
 * 					AllowedOrigins: pulumi.StringArray{
 * 						pulumi.String("*"),
 * 					},
 * 					AllowedHeaders: pulumi.StringArray{
 * 						pulumi.String("x-oss-test"),
 * 						pulumi.String("x-oss-abc"),
 * 					},
 * 					ExposeHeaders: pulumi.StringArray{
 * 						pulumi.String("x-oss-request-id"),
 * 					},
 * 					MaxAgeSeconds: pulumi.Int(1000),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.uuid;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.oss.BucketCors;
 * import com.pulumi.alicloud.oss.BucketCorsArgs;
 * import com.pulumi.alicloud.oss.inputs.BucketCorsCorsRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Uuid("default");
 *         var createBucket = new Bucket("createBucket", BucketArgs.builder()
 *             .storageClass("Standard")
 *             .bucket(String.format("%s-%s", name,default_.result()))
 *             .build());
 *         var defaultBucketCors = new BucketCors("defaultBucketCors", BucketCorsArgs.builder()
 *             .bucket(createBucket.bucket())
 *             .responseVary(true)
 *             .corsRules(BucketCorsCorsRuleArgs.builder()
 *                 .allowedMethods("GET")
 *                 .allowedOrigins("*")
 *                 .allowedHeaders(
 *                     "x-oss-test",
 *                     "x-oss-abc")
 *                 .exposeHeaders("x-oss-request-id")
 *                 .maxAgeSeconds("1000")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: random:uuid
 *   createBucket:
 *     type: alicloud:oss:Bucket
 *     name: CreateBucket
 *     properties:
 *       storageClass: Standard
 *       bucket: ${name}-${default.result}
 *   defaultBucketCors:
 *     type: alicloud:oss:BucketCors
 *     name: default
 *     properties:
 *       bucket: ${createBucket.bucket}
 *       responseVary: true
 *       corsRules:
 *         - allowedMethods:
 *             - GET
 *           allowedOrigins:
 *             - '*'
 *           allowedHeaders:
 *             - x-oss-test
 *             - x-oss-abc
 *           exposeHeaders:
 *             - x-oss-request-id
 *           maxAgeSeconds: '1000'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OSS Bucket Cors can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oss/bucketCors:BucketCors example <id>
 * ```
 * @property bucket The name of the Bucket.
 * @property corsRules The Cross-Origin Resource Sharing (CORS) configuration of the Bucket. See `cors_rule` below.
 * @property responseVary Specifies whether to return the Vary: Origin header. Valid values: true: returns the Vary: Origin header, regardless of whether the request is a cross-origin request or whether the cross-origin request succeeds. false: does not return the Vary: Origin header. This element is valid only when at least one CORS rule is configured.
 */
public data class BucketCorsArgs(
    public val bucket: Output<String>? = null,
    public val corsRules: Output<List<BucketCorsCorsRuleArgs>>? = null,
    public val responseVary: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.BucketCorsArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.BucketCorsArgs =
        com.pulumi.alicloud.oss.BucketCorsArgs.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .corsRules(
                corsRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .responseVary(responseVary?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketCorsArgs].
 */
@PulumiTagMarker
public class BucketCorsArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var corsRules: Output<List<BucketCorsCorsRuleArgs>>? = null

    private var responseVary: Output<Boolean>? = null

    /**
     * @param value The name of the Bucket.
     */
    @JvmName("amkxrwfblrmxbkcc")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value The Cross-Origin Resource Sharing (CORS) configuration of the Bucket. See `cors_rule` below.
     */
    @JvmName("grpwcdnfavvuifmv")
    public suspend fun corsRules(`value`: Output<List<BucketCorsCorsRuleArgs>>) {
        this.corsRules = value
    }

    @JvmName("jkpdpyaqgsvpmpyg")
    public suspend fun corsRules(vararg values: Output<BucketCorsCorsRuleArgs>) {
        this.corsRules = Output.all(values.asList())
    }

    /**
     * @param values The Cross-Origin Resource Sharing (CORS) configuration of the Bucket. See `cors_rule` below.
     */
    @JvmName("logtqxerkhxqavnv")
    public suspend fun corsRules(values: List<Output<BucketCorsCorsRuleArgs>>) {
        this.corsRules = Output.all(values)
    }

    /**
     * @param value Specifies whether to return the Vary: Origin header. Valid values: true: returns the Vary: Origin header, regardless of whether the request is a cross-origin request or whether the cross-origin request succeeds. false: does not return the Vary: Origin header. This element is valid only when at least one CORS rule is configured.
     */
    @JvmName("ggbkaxmwunsrjyqt")
    public suspend fun responseVary(`value`: Output<Boolean>) {
        this.responseVary = value
    }

    /**
     * @param value The name of the Bucket.
     */
    @JvmName("urjqnkgxxfccaxml")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value The Cross-Origin Resource Sharing (CORS) configuration of the Bucket. See `cors_rule` below.
     */
    @JvmName("wtsuilfsmupkhtwr")
    public suspend fun corsRules(`value`: List<BucketCorsCorsRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.corsRules = mapped
    }

    /**
     * @param argument The Cross-Origin Resource Sharing (CORS) configuration of the Bucket. See `cors_rule` below.
     */
    @JvmName("iqycecsbpqfimwto")
    public suspend fun corsRules(argument: List<suspend BucketCorsCorsRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketCorsCorsRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.corsRules = mapped
    }

    /**
     * @param argument The Cross-Origin Resource Sharing (CORS) configuration of the Bucket. See `cors_rule` below.
     */
    @JvmName("lwiutnlbvwbwhdyu")
    public suspend fun corsRules(vararg argument: suspend BucketCorsCorsRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BucketCorsCorsRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.corsRules = mapped
    }

    /**
     * @param argument The Cross-Origin Resource Sharing (CORS) configuration of the Bucket. See `cors_rule` below.
     */
    @JvmName("btsiskwvobxhjrkb")
    public suspend fun corsRules(argument: suspend BucketCorsCorsRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BucketCorsCorsRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.corsRules = mapped
    }

    /**
     * @param values The Cross-Origin Resource Sharing (CORS) configuration of the Bucket. See `cors_rule` below.
     */
    @JvmName("bnwwopobitbgpbdy")
    public suspend fun corsRules(vararg values: BucketCorsCorsRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.corsRules = mapped
    }

    /**
     * @param value Specifies whether to return the Vary: Origin header. Valid values: true: returns the Vary: Origin header, regardless of whether the request is a cross-origin request or whether the cross-origin request succeeds. false: does not return the Vary: Origin header. This element is valid only when at least one CORS rule is configured.
     */
    @JvmName("xlvuxykovkjegthh")
    public suspend fun responseVary(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseVary = mapped
    }

    internal fun build(): BucketCorsArgs = BucketCorsArgs(
        bucket = bucket,
        corsRules = corsRules,
        responseVary = responseVary,
    )
}
