@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin

import com.pulumi.alicloud.oss.BucketDataRedundancyTransitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a OSS Bucket Data Redundancy Transition resource. Create a storage redundancy transition task to convert local redundant storage(LRS) to zone redundant storage(ZRS).
 * For information about OSS Bucket Data Redundancy Transition and how to use it, see [What is Bucket Data Redundancy Transition](https://www.alibabacloud.com/help/en/oss/developer-reference/createbucketdataredundancytransition).
 * > **NOTE:** Available since v1.224.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const createBucket = new alicloud.oss.Bucket("CreateBucket", {
 *     storageClass: "Standard",
 *     bucket: `${name}-${_default.result}`,
 * });
 * const defaultBucketDataRedundancyTransition = new alicloud.oss.BucketDataRedundancyTransition("default", {bucket: createBucket.bucket});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * create_bucket = alicloud.oss.Bucket("CreateBucket",
 *     storage_class="Standard",
 *     bucket=f"{name}-{default['result']}")
 * default_bucket_data_redundancy_transition = alicloud.oss.BucketDataRedundancyTransition("default", bucket=create_bucket.bucket)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var createBucket = new AliCloud.Oss.Bucket("CreateBucket", new()
 *     {
 *         StorageClass = "Standard",
 *         BucketName = $"{name}-{@default.Result}",
 *     });
 *     var defaultBucketDataRedundancyTransition = new AliCloud.Oss.BucketDataRedundancyTransition("default", new()
 *     {
 *         Bucket = createBucket.BucketName,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		createBucket, err := oss.NewBucket(ctx, "CreateBucket", &oss.BucketArgs{
 * 			StorageClass: pulumi.String("Standard"),
 * 			Bucket:       pulumi.Sprintf("%v-%v", name, _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oss.NewBucketDataRedundancyTransition(ctx, "default", &oss.BucketDataRedundancyTransitionArgs{
 * 			Bucket: createBucket.Bucket,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.oss.BucketDataRedundancyTransition;
 * import com.pulumi.alicloud.oss.BucketDataRedundancyTransitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var createBucket = new Bucket("createBucket", BucketArgs.builder()
 *             .storageClass("Standard")
 *             .bucket(String.format("%s-%s", name,default_.result()))
 *             .build());
 *         var defaultBucketDataRedundancyTransition = new BucketDataRedundancyTransition("defaultBucketDataRedundancyTransition", BucketDataRedundancyTransitionArgs.builder()
 *             .bucket(createBucket.bucket())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   createBucket:
 *     type: alicloud:oss:Bucket
 *     name: CreateBucket
 *     properties:
 *       storageClass: Standard
 *       bucket: ${name}-${default.result}
 *   defaultBucketDataRedundancyTransition:
 *     type: alicloud:oss:BucketDataRedundancyTransition
 *     name: default
 *     properties:
 *       bucket: ${createBucket.bucket}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OSS Bucket Data Redundancy Transition can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oss/bucketDataRedundancyTransition:BucketDataRedundancyTransition example <bucket>:<task_id>
 * ```
 * @property bucket Storage space name.
 */
public data class BucketDataRedundancyTransitionArgs(
    public val bucket: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.BucketDataRedundancyTransitionArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.BucketDataRedundancyTransitionArgs =
        com.pulumi.alicloud.oss.BucketDataRedundancyTransitionArgs.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketDataRedundancyTransitionArgs].
 */
@PulumiTagMarker
public class BucketDataRedundancyTransitionArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    /**
     * @param value Storage space name.
     */
    @JvmName("ahycayauryukkexo")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Storage space name.
     */
    @JvmName("vmyawmutndjwjejs")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    internal fun build(): BucketDataRedundancyTransitionArgs = BucketDataRedundancyTransitionArgs(
        bucket = bucket,
    )
}
