@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [BucketHttpsConfig].
 */
@PulumiTagMarker
public class BucketHttpsConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketHttpsConfigArgs = BucketHttpsConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketHttpsConfigArgsBuilder.() -> Unit) {
        val builder = BucketHttpsConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BucketHttpsConfig {
        val builtJavaResource = com.pulumi.alicloud.oss.BucketHttpsConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BucketHttpsConfig(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * OSS Bucket Https Config can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oss/bucketHttpsConfig:BucketHttpsConfig example <id>
 * ```
 */
public class BucketHttpsConfig internal constructor(
    override val javaResource: com.pulumi.alicloud.oss.BucketHttpsConfig,
) : KotlinCustomResource(javaResource, BucketHttpsConfigMapper) {
    /**
     * The name of the bucket.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to enable TLS version management for the bucket. Valid values: true, false.
     */
    public val enable: Output<Boolean>
        get() = javaResource.enable().applyValue({ args0 -> args0 })

    /**
     * Specifies the TLS versions allowed to access this buckets.
     */
    public val tlsVersions: Output<List<String>>?
        get() = javaResource.tlsVersions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object BucketHttpsConfigMapper : ResourceMapper<BucketHttpsConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.oss.BucketHttpsConfig::class == javaResource::class

    override fun map(javaResource: Resource): BucketHttpsConfig = BucketHttpsConfig(
        javaResource as
            com.pulumi.alicloud.oss.BucketHttpsConfig,
    )
}

/**
 * @see [BucketHttpsConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketHttpsConfig].
 */
public suspend fun bucketHttpsConfig(
    name: String,
    block: suspend BucketHttpsConfigResourceBuilder.() -> Unit,
): BucketHttpsConfig {
    val builder = BucketHttpsConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketHttpsConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketHttpsConfig(name: String): BucketHttpsConfig {
    val builder = BucketHttpsConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
