@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin

import com.pulumi.alicloud.oss.BucketHttpsConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * OSS Bucket Https Config can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oss/bucketHttpsConfig:BucketHttpsConfig example <id>
 * ```
 * @property bucket The name of the bucket.
 * @property enable Specifies whether to enable TLS version management for the bucket. Valid values: true, false.
 * @property tlsVersions Specifies the TLS versions allowed to access this buckets.
 */
public data class BucketHttpsConfigArgs(
    public val bucket: Output<String>? = null,
    public val enable: Output<Boolean>? = null,
    public val tlsVersions: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.BucketHttpsConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.BucketHttpsConfigArgs =
        com.pulumi.alicloud.oss.BucketHttpsConfigArgs.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .enable(enable?.applyValue({ args0 -> args0 }))
            .tlsVersions(tlsVersions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [BucketHttpsConfigArgs].
 */
@PulumiTagMarker
public class BucketHttpsConfigArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var enable: Output<Boolean>? = null

    private var tlsVersions: Output<List<String>>? = null

    /**
     * @param value The name of the bucket.
     */
    @JvmName("stmrywxvonsovkhj")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Specifies whether to enable TLS version management for the bucket. Valid values: true, false.
     */
    @JvmName("rgamokmshqetjrod")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value Specifies the TLS versions allowed to access this buckets.
     */
    @JvmName("gdmpbyqqippyxwme")
    public suspend fun tlsVersions(`value`: Output<List<String>>) {
        this.tlsVersions = value
    }

    @JvmName("arwcrhdvesryfiki")
    public suspend fun tlsVersions(vararg values: Output<String>) {
        this.tlsVersions = Output.all(values.asList())
    }

    /**
     * @param values Specifies the TLS versions allowed to access this buckets.
     */
    @JvmName("yrfdkcagpdknuorf")
    public suspend fun tlsVersions(values: List<Output<String>>) {
        this.tlsVersions = Output.all(values)
    }

    /**
     * @param value The name of the bucket.
     */
    @JvmName("qyjmylprpxgfgdav")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Specifies whether to enable TLS version management for the bucket. Valid values: true, false.
     */
    @JvmName("faoikfrogxfgnbgb")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value Specifies the TLS versions allowed to access this buckets.
     */
    @JvmName("mssqyladbcmvlyxo")
    public suspend fun tlsVersions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tlsVersions = mapped
    }

    /**
     * @param values Specifies the TLS versions allowed to access this buckets.
     */
    @JvmName("cgrhpjhenemprybn")
    public suspend fun tlsVersions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tlsVersions = mapped
    }

    internal fun build(): BucketHttpsConfigArgs = BucketHttpsConfigArgs(
        bucket = bucket,
        enable = enable,
        tlsVersions = tlsVersions,
    )
}
