@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BucketLogging].
 */
@PulumiTagMarker
public class BucketLoggingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketLoggingArgs = BucketLoggingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketLoggingArgsBuilder.() -> Unit) {
        val builder = BucketLoggingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BucketLogging {
        val builtJavaResource = com.pulumi.alicloud.oss.BucketLogging(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BucketLogging(builtJavaResource)
    }
}

/**
 * Provides a OSS Bucket Logging resource. After you enable and configure logging for a bucket, Object Storage Service (OSS) generates log objects based on a predefined naming convention. This way, access logs are generated and stored in the specified bucket on an hourly basis.
 * For information about OSS Bucket Logging and how to use it, see [What is Bucket Logging](https://www.alibabacloud.com/help/en/oss/developer-reference/putbucketlogging).
 * > **NOTE:** Available since v1.222.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const createBucket = new alicloud.oss.Bucket("CreateBucket", {
 *     storageClass: "Standard",
 *     bucket: `${name}-${_default.result}`,
 * });
 * const defaultBucketLogging = new alicloud.oss.BucketLogging("default", {
 *     bucket: createBucket.bucket,
 *     targetBucket: createBucket.bucket,
 *     targetPrefix: "log/",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * create_bucket = alicloud.oss.Bucket("CreateBucket",
 *     storage_class="Standard",
 *     bucket=f"{name}-{default['result']}")
 * default_bucket_logging = alicloud.oss.BucketLogging("default",
 *     bucket=create_bucket.bucket,
 *     target_bucket=create_bucket.bucket,
 *     target_prefix="log/")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var createBucket = new AliCloud.Oss.Bucket("CreateBucket", new()
 *     {
 *         StorageClass = "Standard",
 *         BucketName = $"{name}-{@default.Result}",
 *     });
 *     var defaultBucketLogging = new AliCloud.Oss.BucketLogging("default", new()
 *     {
 *         Bucket = createBucket.BucketName,
 *         TargetBucket = createBucket.BucketName,
 *         TargetPrefix = "log/",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		createBucket, err := oss.NewBucket(ctx, "CreateBucket", &oss.BucketArgs{
 * 			StorageClass: pulumi.String("Standard"),
 * 			Bucket:       pulumi.Sprintf("%v-%v", name, _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oss.NewBucketLogging(ctx, "default", &oss.BucketLoggingArgs{
 * 			Bucket:       createBucket.Bucket,
 * 			TargetBucket: createBucket.Bucket,
 * 			TargetPrefix: pulumi.String("log/"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.oss.BucketLogging;
 * import com.pulumi.alicloud.oss.BucketLoggingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var createBucket = new Bucket("createBucket", BucketArgs.builder()
 *             .storageClass("Standard")
 *             .bucket(String.format("%s-%s", name,default_.result()))
 *             .build());
 *         var defaultBucketLogging = new BucketLogging("defaultBucketLogging", BucketLoggingArgs.builder()
 *             .bucket(createBucket.bucket())
 *             .targetBucket(createBucket.bucket())
 *             .targetPrefix("log/")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   createBucket:
 *     type: alicloud:oss:Bucket
 *     name: CreateBucket
 *     properties:
 *       storageClass: Standard
 *       bucket: ${name}-${default.result}
 *   defaultBucketLogging:
 *     type: alicloud:oss:BucketLogging
 *     name: default
 *     properties:
 *       bucket: ${createBucket.bucket}
 *       targetBucket: ${createBucket.bucket}
 *       targetPrefix: log/
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OSS Bucket Logging can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oss/bucketLogging:BucketLogging example <id>
 * ```
 */
public class BucketLogging internal constructor(
    override val javaResource: com.pulumi.alicloud.oss.BucketLogging,
) : KotlinCustomResource(javaResource, BucketLoggingMapper) {
    /**
     * The name of the bucket.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * The bucket that stores access logs.
     */
    public val targetBucket: Output<String>
        get() = javaResource.targetBucket().applyValue({ args0 -> args0 })

    /**
     * The prefix of the saved log objects. This element can be left empty.
     */
    public val targetPrefix: Output<String>?
        get() = javaResource.targetPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object BucketLoggingMapper : ResourceMapper<BucketLogging> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.oss.BucketLogging::class == javaResource::class

    override fun map(javaResource: Resource): BucketLogging = BucketLogging(
        javaResource as
            com.pulumi.alicloud.oss.BucketLogging,
    )
}

/**
 * @see [BucketLogging].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketLogging].
 */
public suspend fun bucketLogging(
    name: String,
    block: suspend BucketLoggingResourceBuilder.() -> Unit,
): BucketLogging {
    val builder = BucketLoggingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketLogging].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketLogging(name: String): BucketLogging {
    val builder = BucketLoggingResourceBuilder()
    builder.name(name)
    return builder.build()
}
