@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin

import com.pulumi.alicloud.oss.BucketLoggingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a OSS Bucket Logging resource. After you enable and configure logging for a bucket, Object Storage Service (OSS) generates log objects based on a predefined naming convention. This way, access logs are generated and stored in the specified bucket on an hourly basis.
 * For information about OSS Bucket Logging and how to use it, see [What is Bucket Logging](https://www.alibabacloud.com/help/en/oss/developer-reference/putbucketlogging).
 * > **NOTE:** Available since v1.222.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const createBucket = new alicloud.oss.Bucket("CreateBucket", {
 *     storageClass: "Standard",
 *     bucket: `${name}-${_default.result}`,
 * });
 * const defaultBucketLogging = new alicloud.oss.BucketLogging("default", {
 *     bucket: createBucket.bucket,
 *     targetBucket: createBucket.bucket,
 *     targetPrefix: "log/",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * create_bucket = alicloud.oss.Bucket("CreateBucket",
 *     storage_class="Standard",
 *     bucket=f"{name}-{default['result']}")
 * default_bucket_logging = alicloud.oss.BucketLogging("default",
 *     bucket=create_bucket.bucket,
 *     target_bucket=create_bucket.bucket,
 *     target_prefix="log/")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var createBucket = new AliCloud.Oss.Bucket("CreateBucket", new()
 *     {
 *         StorageClass = "Standard",
 *         BucketName = $"{name}-{@default.Result}",
 *     });
 *     var defaultBucketLogging = new AliCloud.Oss.BucketLogging("default", new()
 *     {
 *         Bucket = createBucket.BucketName,
 *         TargetBucket = createBucket.BucketName,
 *         TargetPrefix = "log/",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		createBucket, err := oss.NewBucket(ctx, "CreateBucket", &oss.BucketArgs{
 * 			StorageClass: pulumi.String("Standard"),
 * 			Bucket:       pulumi.Sprintf("%v-%v", name, _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oss.NewBucketLogging(ctx, "default", &oss.BucketLoggingArgs{
 * 			Bucket:       createBucket.Bucket,
 * 			TargetBucket: createBucket.Bucket,
 * 			TargetPrefix: pulumi.String("log/"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.oss.BucketLogging;
 * import com.pulumi.alicloud.oss.BucketLoggingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var createBucket = new Bucket("createBucket", BucketArgs.builder()
 *             .storageClass("Standard")
 *             .bucket(String.format("%s-%s", name,default_.result()))
 *             .build());
 *         var defaultBucketLogging = new BucketLogging("defaultBucketLogging", BucketLoggingArgs.builder()
 *             .bucket(createBucket.bucket())
 *             .targetBucket(createBucket.bucket())
 *             .targetPrefix("log/")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   createBucket:
 *     type: alicloud:oss:Bucket
 *     name: CreateBucket
 *     properties:
 *       storageClass: Standard
 *       bucket: ${name}-${default.result}
 *   defaultBucketLogging:
 *     type: alicloud:oss:BucketLogging
 *     name: default
 *     properties:
 *       bucket: ${createBucket.bucket}
 *       targetBucket: ${createBucket.bucket}
 *       targetPrefix: log/
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OSS Bucket Logging can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oss/bucketLogging:BucketLogging example <id>
 * ```
 * @property bucket The name of the bucket.
 * @property targetBucket The bucket that stores access logs.
 * @property targetPrefix The prefix of the saved log objects. This element can be left empty.
 */
public data class BucketLoggingArgs(
    public val bucket: Output<String>? = null,
    public val targetBucket: Output<String>? = null,
    public val targetPrefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.BucketLoggingArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.BucketLoggingArgs =
        com.pulumi.alicloud.oss.BucketLoggingArgs.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .targetBucket(targetBucket?.applyValue({ args0 -> args0 }))
            .targetPrefix(targetPrefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketLoggingArgs].
 */
@PulumiTagMarker
public class BucketLoggingArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var targetBucket: Output<String>? = null

    private var targetPrefix: Output<String>? = null

    /**
     * @param value The name of the bucket.
     */
    @JvmName("qoheshpaexnwymmn")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value The bucket that stores access logs.
     */
    @JvmName("xidiyfskmdkcoqoa")
    public suspend fun targetBucket(`value`: Output<String>) {
        this.targetBucket = value
    }

    /**
     * @param value The prefix of the saved log objects. This element can be left empty.
     */
    @JvmName("tadjgonlufpfievi")
    public suspend fun targetPrefix(`value`: Output<String>) {
        this.targetPrefix = value
    }

    /**
     * @param value The name of the bucket.
     */
    @JvmName("oshpnwxoqkdwlfav")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value The bucket that stores access logs.
     */
    @JvmName("mnkityafspxkiymu")
    public suspend fun targetBucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetBucket = mapped
    }

    /**
     * @param value The prefix of the saved log objects. This element can be left empty.
     */
    @JvmName("beecpmbfvvftrunw")
    public suspend fun targetPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetPrefix = mapped
    }

    internal fun build(): BucketLoggingArgs = BucketLoggingArgs(
        bucket = bucket,
        targetBucket = targetBucket,
        targetPrefix = targetPrefix,
    )
}
