@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BucketObject].
 */
@PulumiTagMarker
public class BucketObjectResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketObjectArgs = BucketObjectArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketObjectArgsBuilder.() -> Unit) {
        val builder = BucketObjectArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BucketObject {
        val builtJavaResource = com.pulumi.alicloud.oss.BucketObject(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BucketObject(builtJavaResource)
    }
}

/**
 * Provides a resource to put a object(content or file) to a oss bucket.
 * ## Example Usage
 * ### Uploading a file to a bucket
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const defaultBucket = new alicloud.oss.Bucket("default", {
 *     bucket: `terraform-example-${_default.result}`,
 *     acl: "private",
 * });
 * const defaultBucketObject = new alicloud.oss.BucketObject("default", {
 *     bucket: defaultBucket.bucket,
 *     key: "example_key",
 *     source: "./main.tf",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * default_bucket = alicloud.oss.Bucket("default",
 *     bucket=f"terraform-example-{default['result']}",
 *     acl="private")
 * default_bucket_object = alicloud.oss.BucketObject("default",
 *     bucket=default_bucket.bucket,
 *     key="example_key",
 *     source="./main.tf")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var defaultBucket = new AliCloud.Oss.Bucket("default", new()
 *     {
 *         BucketName = $"terraform-example-{@default.Result}",
 *         Acl = "private",
 *     });
 *     var defaultBucketObject = new AliCloud.Oss.BucketObject("default", new()
 *     {
 *         Bucket = defaultBucket.BucketName,
 *         Key = "example_key",
 *         Source = "./main.tf",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBucket, err := oss.NewBucket(ctx, "default", &oss.BucketArgs{
 * 			Bucket: pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Acl:    pulumi.String("private"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oss.NewBucketObject(ctx, "default", &oss.BucketObjectArgs{
 * 			Bucket: defaultBucket.Bucket,
 * 			Key:    pulumi.String("example_key"),
 * 			Source: pulumi.String("./main.tf"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.oss.BucketObject;
 * import com.pulumi.alicloud.oss.BucketObjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var defaultBucket = new Bucket("defaultBucket", BucketArgs.builder()
 *             .bucket(String.format("terraform-example-%s", default_.result()))
 *             .acl("private")
 *             .build());
 *         var defaultBucketObject = new BucketObject("defaultBucketObject", BucketObjectArgs.builder()
 *             .bucket(defaultBucket.bucket())
 *             .key("example_key")
 *             .source("./main.tf")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   defaultBucket:
 *     type: alicloud:oss:Bucket
 *     name: default
 *     properties:
 *       bucket: terraform-example-${default.result}
 *       acl: private
 *   defaultBucketObject:
 *     type: alicloud:oss:BucketObject
 *     name: default
 *     properties:
 *       bucket: ${defaultBucket.bucket}
 *       key: example_key
 *       source: ./main.tf
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Uploading a content to a bucket
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const defaultBucket = new alicloud.oss.Bucket("default", {
 *     bucket: `terraform-example-${_default.result}`,
 *     acl: "private",
 * });
 * const defaultBucketObject = new alicloud.oss.BucketObject("default", {
 *     bucket: defaultBucket.bucket,
 *     key: "example_key",
 *     content: "the content that you want to upload.",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * default_bucket = alicloud.oss.Bucket("default",
 *     bucket=f"terraform-example-{default['result']}",
 *     acl="private")
 * default_bucket_object = alicloud.oss.BucketObject("default",
 *     bucket=default_bucket.bucket,
 *     key="example_key",
 *     content="the content that you want to upload.")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var defaultBucket = new AliCloud.Oss.Bucket("default", new()
 *     {
 *         BucketName = $"terraform-example-{@default.Result}",
 *         Acl = "private",
 *     });
 *     var defaultBucketObject = new AliCloud.Oss.BucketObject("default", new()
 *     {
 *         Bucket = defaultBucket.BucketName,
 *         Key = "example_key",
 *         Content = "the content that you want to upload.",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBucket, err := oss.NewBucket(ctx, "default", &oss.BucketArgs{
 * 			Bucket: pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Acl:    pulumi.String("private"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oss.NewBucketObject(ctx, "default", &oss.BucketObjectArgs{
 * 			Bucket:  defaultBucket.Bucket,
 * 			Key:     pulumi.String("example_key"),
 * 			Content: pulumi.String("the content that you want to upload."),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.oss.BucketObject;
 * import com.pulumi.alicloud.oss.BucketObjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var defaultBucket = new Bucket("defaultBucket", BucketArgs.builder()
 *             .bucket(String.format("terraform-example-%s", default_.result()))
 *             .acl("private")
 *             .build());
 *         var defaultBucketObject = new BucketObject("defaultBucketObject", BucketObjectArgs.builder()
 *             .bucket(defaultBucket.bucket())
 *             .key("example_key")
 *             .content("the content that you want to upload.")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   defaultBucket:
 *     type: alicloud:oss:Bucket
 *     name: default
 *     properties:
 *       bucket: terraform-example-${default.result}
 *       acl: private
 *   defaultBucketObject:
 *     type: alicloud:oss:BucketObject
 *     name: default
 *     properties:
 *       bucket: ${defaultBucket.bucket}
 *       key: example_key
 *       content: the content that you want to upload.
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class BucketObject internal constructor(
    override val javaResource: com.pulumi.alicloud.oss.BucketObject,
) : KotlinCustomResource(javaResource, BucketObjectMapper) {
    /**
     * The [canned ACL](https://www.alibabacloud.com/help/doc-detail/52284.htm) to apply. Defaults to "private".
     */
    public val acl: Output<String>?
        get() = javaResource.acl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the bucket to put the file in.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Specifies caching behavior along the request/reply chain. Read [RFC2616 Cache-Control](https://www.ietf.org/rfc/rfc2616.txt) for further details.
     */
    public val cacheControl: Output<String>?
        get() = javaResource.cacheControl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The literal content being uploaded to the bucket.
     */
    public val content: Output<String>?
        get() = javaResource.content().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies presentational information for the object. Read [RFC2616 Content-Disposition](https://www.ietf.org/rfc/rfc2616.txt) for further details.
     */
    public val contentDisposition: Output<String>?
        get() = javaResource.contentDisposition().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [RFC2616 Content-Encoding](https://www.ietf.org/rfc/rfc2616.txt) for further details.
     */
    public val contentEncoding: Output<String>?
        get() = javaResource.contentEncoding().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * the content length of request.
     */
    public val contentLength: Output<String>
        get() = javaResource.contentLength().applyValue({ args0 -> args0 })

    /**
     * The MD5 value of the content. Read [MD5](https://www.alibabacloud.com/help/doc-detail/31978.htm) for computing method.
     */
    public val contentMd5: Output<String>?
        get() = javaResource.contentMd5().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A standard MIME type describing the format of the object data, e.g. application/octet-stream. All Valid MIME Types are valid for this input.
     */
    public val contentType: Output<String>
        get() = javaResource.contentType().applyValue({ args0 -> args0 })

    /**
     * the ETag generated for the object (an MD5 sum of the object content).
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Specifies expire date for the the request/response. Read [RFC2616 Expires](https://www.ietf.org/rfc/rfc2616.txt) for further details.
     */
    public val expires: Output<String>?
        get() = javaResource.expires().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the object once it is in the bucket.
     */
    public val key: Output<String>
        get() = javaResource.key().applyValue({ args0 -> args0 })

    /**
     * Specifies the primary key managed by KMS. This parameter is valid when the value of `server_side_encryption` is set to KMS.
     * Either `source` or `content` must be provided to specify the bucket content.
     * These two arguments are mutually-exclusive.
     */
    public val kmsKeyId: Output<String>?
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies server-side encryption of the object in OSS. Valid values are `AES256`, `KMS`. Default value is `AES256`.
     */
    public val serverSideEncryption: Output<String>?
        get() = javaResource.serverSideEncryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The path to the source file being uploaded to the bucket.
     */
    public val source: Output<String>?
        get() = javaResource.source().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A unique version ID value for the object, if bucket versioning is enabled.
     */
    public val versionId: Output<String>
        get() = javaResource.versionId().applyValue({ args0 -> args0 })
}

public object BucketObjectMapper : ResourceMapper<BucketObject> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.oss.BucketObject::class == javaResource::class

    override fun map(javaResource: Resource): BucketObject = BucketObject(
        javaResource as
            com.pulumi.alicloud.oss.BucketObject,
    )
}

/**
 * @see [BucketObject].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketObject].
 */
public suspend fun bucketObject(
    name: String,
    block: suspend BucketObjectResourceBuilder.() -> Unit,
): BucketObject {
    val builder = BucketObjectResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketObject].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketObject(name: String): BucketObject {
    val builder = BucketObjectResourceBuilder()
    builder.name(name)
    return builder.build()
}
