@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin

import com.pulumi.alicloud.oss.BucketObjectArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to put a object(content or file) to a oss bucket.
 * ## Example Usage
 * ### Uploading a file to a bucket
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const defaultBucket = new alicloud.oss.Bucket("default", {
 *     bucket: `terraform-example-${_default.result}`,
 *     acl: "private",
 * });
 * const defaultBucketObject = new alicloud.oss.BucketObject("default", {
 *     bucket: defaultBucket.bucket,
 *     key: "example_key",
 *     source: "./main.tf",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * default_bucket = alicloud.oss.Bucket("default",
 *     bucket=f"terraform-example-{default['result']}",
 *     acl="private")
 * default_bucket_object = alicloud.oss.BucketObject("default",
 *     bucket=default_bucket.bucket,
 *     key="example_key",
 *     source="./main.tf")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var defaultBucket = new AliCloud.Oss.Bucket("default", new()
 *     {
 *         BucketName = $"terraform-example-{@default.Result}",
 *         Acl = "private",
 *     });
 *     var defaultBucketObject = new AliCloud.Oss.BucketObject("default", new()
 *     {
 *         Bucket = defaultBucket.BucketName,
 *         Key = "example_key",
 *         Source = "./main.tf",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBucket, err := oss.NewBucket(ctx, "default", &oss.BucketArgs{
 * 			Bucket: pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Acl:    pulumi.String("private"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oss.NewBucketObject(ctx, "default", &oss.BucketObjectArgs{
 * 			Bucket: defaultBucket.Bucket,
 * 			Key:    pulumi.String("example_key"),
 * 			Source: pulumi.String("./main.tf"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.oss.BucketObject;
 * import com.pulumi.alicloud.oss.BucketObjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var defaultBucket = new Bucket("defaultBucket", BucketArgs.builder()
 *             .bucket(String.format("terraform-example-%s", default_.result()))
 *             .acl("private")
 *             .build());
 *         var defaultBucketObject = new BucketObject("defaultBucketObject", BucketObjectArgs.builder()
 *             .bucket(defaultBucket.bucket())
 *             .key("example_key")
 *             .source("./main.tf")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   defaultBucket:
 *     type: alicloud:oss:Bucket
 *     name: default
 *     properties:
 *       bucket: terraform-example-${default.result}
 *       acl: private
 *   defaultBucketObject:
 *     type: alicloud:oss:BucketObject
 *     name: default
 *     properties:
 *       bucket: ${defaultBucket.bucket}
 *       key: example_key
 *       source: ./main.tf
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Uploading a content to a bucket
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const defaultBucket = new alicloud.oss.Bucket("default", {
 *     bucket: `terraform-example-${_default.result}`,
 *     acl: "private",
 * });
 * const defaultBucketObject = new alicloud.oss.BucketObject("default", {
 *     bucket: defaultBucket.bucket,
 *     key: "example_key",
 *     content: "the content that you want to upload.",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * default_bucket = alicloud.oss.Bucket("default",
 *     bucket=f"terraform-example-{default['result']}",
 *     acl="private")
 * default_bucket_object = alicloud.oss.BucketObject("default",
 *     bucket=default_bucket.bucket,
 *     key="example_key",
 *     content="the content that you want to upload.")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var defaultBucket = new AliCloud.Oss.Bucket("default", new()
 *     {
 *         BucketName = $"terraform-example-{@default.Result}",
 *         Acl = "private",
 *     });
 *     var defaultBucketObject = new AliCloud.Oss.BucketObject("default", new()
 *     {
 *         Bucket = defaultBucket.BucketName,
 *         Key = "example_key",
 *         Content = "the content that you want to upload.",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBucket, err := oss.NewBucket(ctx, "default", &oss.BucketArgs{
 * 			Bucket: pulumi.Sprintf("terraform-example-%v", _default.Result),
 * 			Acl:    pulumi.String("private"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oss.NewBucketObject(ctx, "default", &oss.BucketObjectArgs{
 * 			Bucket:  defaultBucket.Bucket,
 * 			Key:     pulumi.String("example_key"),
 * 			Content: pulumi.String("the content that you want to upload."),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.oss.BucketObject;
 * import com.pulumi.alicloud.oss.BucketObjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var defaultBucket = new Bucket("defaultBucket", BucketArgs.builder()
 *             .bucket(String.format("terraform-example-%s", default_.result()))
 *             .acl("private")
 *             .build());
 *         var defaultBucketObject = new BucketObject("defaultBucketObject", BucketObjectArgs.builder()
 *             .bucket(defaultBucket.bucket())
 *             .key("example_key")
 *             .content("the content that you want to upload.")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   defaultBucket:
 *     type: alicloud:oss:Bucket
 *     name: default
 *     properties:
 *       bucket: terraform-example-${default.result}
 *       acl: private
 *   defaultBucketObject:
 *     type: alicloud:oss:BucketObject
 *     name: default
 *     properties:
 *       bucket: ${defaultBucket.bucket}
 *       key: example_key
 *       content: the content that you want to upload.
 * ```
 * <!--End PulumiCodeChooser -->
 * @property acl The [canned ACL](https://www.alibabacloud.com/help/doc-detail/52284.htm) to apply. Defaults to "private".
 * @property bucket The name of the bucket to put the file in.
 * @property cacheControl Specifies caching behavior along the request/reply chain. Read [RFC2616 Cache-Control](https://www.ietf.org/rfc/rfc2616.txt) for further details.
 * @property content The literal content being uploaded to the bucket.
 * @property contentDisposition Specifies presentational information for the object. Read [RFC2616 Content-Disposition](https://www.ietf.org/rfc/rfc2616.txt) for further details.
 * @property contentEncoding Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [RFC2616 Content-Encoding](https://www.ietf.org/rfc/rfc2616.txt) for further details.
 * @property contentMd5 The MD5 value of the content. Read [MD5](https://www.alibabacloud.com/help/doc-detail/31978.htm) for computing method.
 * @property contentType A standard MIME type describing the format of the object data, e.g. application/octet-stream. All Valid MIME Types are valid for this input.
 * @property expires Specifies expire date for the the request/response. Read [RFC2616 Expires](https://www.ietf.org/rfc/rfc2616.txt) for further details.
 * @property key The name of the object once it is in the bucket.
 * @property kmsKeyId Specifies the primary key managed by KMS. This parameter is valid when the value of `server_side_encryption` is set to KMS.
 * Either `source` or `content` must be provided to specify the bucket content.
 * These two arguments are mutually-exclusive.
 * @property serverSideEncryption Specifies server-side encryption of the object in OSS. Valid values are `AES256`, `KMS`. Default value is `AES256`.
 * @property source The path to the source file being uploaded to the bucket.
 */
public data class BucketObjectArgs(
    public val acl: Output<String>? = null,
    public val bucket: Output<String>? = null,
    public val cacheControl: Output<String>? = null,
    public val content: Output<String>? = null,
    public val contentDisposition: Output<String>? = null,
    public val contentEncoding: Output<String>? = null,
    public val contentMd5: Output<String>? = null,
    public val contentType: Output<String>? = null,
    public val expires: Output<String>? = null,
    public val key: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val serverSideEncryption: Output<String>? = null,
    public val source: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.BucketObjectArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.BucketObjectArgs =
        com.pulumi.alicloud.oss.BucketObjectArgs.builder()
            .acl(acl?.applyValue({ args0 -> args0 }))
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .cacheControl(cacheControl?.applyValue({ args0 -> args0 }))
            .content(content?.applyValue({ args0 -> args0 }))
            .contentDisposition(contentDisposition?.applyValue({ args0 -> args0 }))
            .contentEncoding(contentEncoding?.applyValue({ args0 -> args0 }))
            .contentMd5(contentMd5?.applyValue({ args0 -> args0 }))
            .contentType(contentType?.applyValue({ args0 -> args0 }))
            .expires(expires?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .serverSideEncryption(serverSideEncryption?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketObjectArgs].
 */
@PulumiTagMarker
public class BucketObjectArgsBuilder internal constructor() {
    private var acl: Output<String>? = null

    private var bucket: Output<String>? = null

    private var cacheControl: Output<String>? = null

    private var content: Output<String>? = null

    private var contentDisposition: Output<String>? = null

    private var contentEncoding: Output<String>? = null

    private var contentMd5: Output<String>? = null

    private var contentType: Output<String>? = null

    private var expires: Output<String>? = null

    private var key: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var serverSideEncryption: Output<String>? = null

    private var source: Output<String>? = null

    /**
     * @param value The [canned ACL](https://www.alibabacloud.com/help/doc-detail/52284.htm) to apply. Defaults to "private".
     */
    @JvmName("csuggksycvvoiiqm")
    public suspend fun acl(`value`: Output<String>) {
        this.acl = value
    }

    /**
     * @param value The name of the bucket to put the file in.
     */
    @JvmName("rvprsmtuhwejlfyr")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Specifies caching behavior along the request/reply chain. Read [RFC2616 Cache-Control](https://www.ietf.org/rfc/rfc2616.txt) for further details.
     */
    @JvmName("aptawhabfphikpvc")
    public suspend fun cacheControl(`value`: Output<String>) {
        this.cacheControl = value
    }

    /**
     * @param value The literal content being uploaded to the bucket.
     */
    @JvmName("fcemklvdnnyyeiad")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value Specifies presentational information for the object. Read [RFC2616 Content-Disposition](https://www.ietf.org/rfc/rfc2616.txt) for further details.
     */
    @JvmName("ryawvfhcueeynvga")
    public suspend fun contentDisposition(`value`: Output<String>) {
        this.contentDisposition = value
    }

    /**
     * @param value Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [RFC2616 Content-Encoding](https://www.ietf.org/rfc/rfc2616.txt) for further details.
     */
    @JvmName("naaflnfyqvggrqyp")
    public suspend fun contentEncoding(`value`: Output<String>) {
        this.contentEncoding = value
    }

    /**
     * @param value The MD5 value of the content. Read [MD5](https://www.alibabacloud.com/help/doc-detail/31978.htm) for computing method.
     */
    @JvmName("erdthqndlxlftccj")
    public suspend fun contentMd5(`value`: Output<String>) {
        this.contentMd5 = value
    }

    /**
     * @param value A standard MIME type describing the format of the object data, e.g. application/octet-stream. All Valid MIME Types are valid for this input.
     */
    @JvmName("hupsngxfpspkaqrs")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value Specifies expire date for the the request/response. Read [RFC2616 Expires](https://www.ietf.org/rfc/rfc2616.txt) for further details.
     */
    @JvmName("gfrgbhnlsxjessdb")
    public suspend fun expires(`value`: Output<String>) {
        this.expires = value
    }

    /**
     * @param value The name of the object once it is in the bucket.
     */
    @JvmName("ueueifamkitswbch")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Specifies the primary key managed by KMS. This parameter is valid when the value of `server_side_encryption` is set to KMS.
     * Either `source` or `content` must be provided to specify the bucket content.
     * These two arguments are mutually-exclusive.
     */
    @JvmName("hsreyardcnflxvfc")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Specifies server-side encryption of the object in OSS. Valid values are `AES256`, `KMS`. Default value is `AES256`.
     */
    @JvmName("oqkvyygqsosgnmid")
    public suspend fun serverSideEncryption(`value`: Output<String>) {
        this.serverSideEncryption = value
    }

    /**
     * @param value The path to the source file being uploaded to the bucket.
     */
    @JvmName("onwtdkxdqkfjjlws")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value The [canned ACL](https://www.alibabacloud.com/help/doc-detail/52284.htm) to apply. Defaults to "private".
     */
    @JvmName("cvokykaeustvikmb")
    public suspend fun acl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acl = mapped
    }

    /**
     * @param value The name of the bucket to put the file in.
     */
    @JvmName("wdwltnbqfgmqiyje")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Specifies caching behavior along the request/reply chain. Read [RFC2616 Cache-Control](https://www.ietf.org/rfc/rfc2616.txt) for further details.
     */
    @JvmName("jdwdjptporsgeatl")
    public suspend fun cacheControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheControl = mapped
    }

    /**
     * @param value The literal content being uploaded to the bucket.
     */
    @JvmName("lepdoqhkbftmohlm")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value Specifies presentational information for the object. Read [RFC2616 Content-Disposition](https://www.ietf.org/rfc/rfc2616.txt) for further details.
     */
    @JvmName("ejywvflyyoedxwmm")
    public suspend fun contentDisposition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentDisposition = mapped
    }

    /**
     * @param value Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [RFC2616 Content-Encoding](https://www.ietf.org/rfc/rfc2616.txt) for further details.
     */
    @JvmName("vrpqewleoqgiftrw")
    public suspend fun contentEncoding(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentEncoding = mapped
    }

    /**
     * @param value The MD5 value of the content. Read [MD5](https://www.alibabacloud.com/help/doc-detail/31978.htm) for computing method.
     */
    @JvmName("burpvyiroqbbehuo")
    public suspend fun contentMd5(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentMd5 = mapped
    }

    /**
     * @param value A standard MIME type describing the format of the object data, e.g. application/octet-stream. All Valid MIME Types are valid for this input.
     */
    @JvmName("pffhcomxvoruoqip")
    public suspend fun contentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value Specifies expire date for the the request/response. Read [RFC2616 Expires](https://www.ietf.org/rfc/rfc2616.txt) for further details.
     */
    @JvmName("mhbliywaxnoupqqo")
    public suspend fun expires(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expires = mapped
    }

    /**
     * @param value The name of the object once it is in the bucket.
     */
    @JvmName("jnraohbtmypxxhwa")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Specifies the primary key managed by KMS. This parameter is valid when the value of `server_side_encryption` is set to KMS.
     * Either `source` or `content` must be provided to specify the bucket content.
     * These two arguments are mutually-exclusive.
     */
    @JvmName("mmlkcmohjjwqyyxf")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Specifies server-side encryption of the object in OSS. Valid values are `AES256`, `KMS`. Default value is `AES256`.
     */
    @JvmName("xmyupdhcayhshscs")
    public suspend fun serverSideEncryption(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverSideEncryption = mapped
    }

    /**
     * @param value The path to the source file being uploaded to the bucket.
     */
    @JvmName("pxjeuwaetfsievxk")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    internal fun build(): BucketObjectArgs = BucketObjectArgs(
        acl = acl,
        bucket = bucket,
        cacheControl = cacheControl,
        content = content,
        contentDisposition = contentDisposition,
        contentEncoding = contentEncoding,
        contentMd5 = contentMd5,
        contentType = contentType,
        expires = expires,
        key = key,
        kmsKeyId = kmsKeyId,
        serverSideEncryption = serverSideEncryption,
        source = source,
    )
}
