@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BucketPolicy].
 */
@PulumiTagMarker
public class BucketPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketPolicyArgs = BucketPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketPolicyArgsBuilder.() -> Unit) {
        val builder = BucketPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BucketPolicy {
        val builtJavaResource = com.pulumi.alicloud.oss.BucketPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BucketPolicy(builtJavaResource)
    }
}

/**
 *  /* /* /* /* /* /*
 * Provides a OSS Bucket Policy resource.  Authorization policy of a bucket.
 * For information about OSS Bucket Policy and how to use it, see [What is Bucket Policy](https://www.alibabacloud.com/help/en/oss/user-guide/use-bucket-policy-to-grant-permission-to-access-oss).
 * > **NOTE:** Available since v1.220.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const createBucket = new alicloud.oss.Bucket("CreateBucket", {
 *     storageClass: "Standard",
 *     bucket: `${name}-${_default.result}`,
 * });
 * const defaultBucketPolicy = new alicloud.oss.BucketPolicy("default", {
 *     policy: JSON.stringify({
 *         Version: "1",
 *         Statement: [{
 *             Action: [
 *                 "oss:PutObject",
 *                 "oss:GetObject",
 *             ],
 *             Effect: "Deny",
 *             Principal: ["1234567890"],
 *             Resource: ["acs:oss:*:1234567890:*/*"],
 *         }],
 *     }),
 *     bucket: createBucket.bucket,
 * }, {
 *     dependsOn: [createBucket],
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * create_bucket = alicloud.oss.Bucket("CreateBucket",
 *     storage_class="Standard",
 *     bucket=f"{name}-{default['result']}")
 * default_bucket_policy = alicloud.oss.BucketPolicy("default",
 *     policy=json.dumps({
 *         "Version": "1",
 *         "Statement": [{
 *             "Action": [
 *                 "oss:PutObject",
 *                 "oss:GetObject",
 *             ],
 *             "Effect": "Deny",
 *             "Principal": ["1234567890"],
 *             "Resource": ["acs:oss:*:1234567890:*/*"],
 *         }],
 *     }),
 *     bucket=create_bucket.bucket,
 *     opts = pulumi.ResourceOptions(depends_on=[create_bucket]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var createBucket = new AliCloud.Oss.Bucket("CreateBucket", new()
 *     {
 *         StorageClass = "Standard",
 *         BucketName = $"{name}-{@default.Result}",
 *     });
 *     var defaultBucketPolicy = new AliCloud.Oss.BucketPolicy("default", new()
 *     {
 *         Policy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "1",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = new[]
 *                     {
 *                         "oss:PutObject",
 *                         "oss:GetObject",
 *                     },
 *                     ["Effect"] = "Deny",
 *                     ["Principal"] = new[]
 *                     {
 *                         "1234567890",
 *                     },
 *                     ["Resource"] = new[]
 *                     {
 *                         "acs:oss:*:1234567890:*/*",
 *                     },
 *                 },
 *             },
 *         }),
 *         Bucket = createBucket.BucketName,
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             createBucket,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		createBucket, err := oss.NewBucket(ctx, "CreateBucket", &oss.BucketArgs{
 * 			StorageClass: pulumi.String("Standard"),
 * 			Bucket:       pulumi.Sprintf("%v-%v", name, _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "1",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": []string{
 * 						"oss:PutObject",
 * 						"oss:GetObject",
 * 					},
 * 					"Effect": "Deny",
 * 					"Principal": []string{
 * 						"1234567890",
 * 					},
 * 					"Resource": []string{
 * 						"acs:oss:*:1234567890:*/*",
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = oss.NewBucketPolicy(ctx, "default", &oss.BucketPolicyArgs{
 * 			Policy: pulumi.String(json0),
 * 			Bucket: createBucket.Bucket,
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			createBucket,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.oss.BucketPolicy;
 * import com.pulumi.alicloud.oss.BucketPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var createBucket = new Bucket("createBucket", BucketArgs.builder()
 *             .storageClass("Standard")
 *             .bucket(String.format("%s-%s", name,default_.result()))
 *             .build());
 *         var defaultBucketPolicy = new BucketPolicy("defaultBucketPolicy", BucketPolicyArgs.builder()
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "1"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray(
 *                             "oss:PutObject",
 *                             "oss:GetObject"
 *                         )),
 *                         jsonProperty("Effect", "Deny"),
 *                         jsonProperty("Principal", jsonArray("1234567890")),
 *                         jsonProperty("Resource", jsonArray("acs:oss:*:1234567890:*/*"))
 *                     )))
 *                 )))
 *             .bucket(createBucket.bucket())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(createBucket)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   createBucket:
 *     type: alicloud:oss:Bucket
 *     name: CreateBucket
 *     properties:
 *       storageClass: Standard
 *       bucket: ${name}-${default.result}
 *   defaultBucketPolicy:
 *     type: alicloud:oss:BucketPolicy
 *     name: default
 *     properties:
 *       policy:
 *         fn::toJSON:
 *           Version: '1'
 *           Statement:
 *             - Action:
 *                 - oss:PutObject
 *                 - oss:GetObject
 *               Effect: Deny
 *               Principal:
 *                 - '1234567890'
 *               Resource:
 *                 - acs:oss:*:1234567890:*/*
 *       bucket: ${createBucket.bucket}
 *     options:
 *       dependson:
 *         - ${createBucket}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OSS Bucket Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oss/bucketPolicy:BucketPolicy example <id>
 * ```
 */
public class BucketPolicy internal constructor(
    override val javaResource: com.pulumi.alicloud.oss.BucketPolicy,
) : KotlinCustomResource(javaResource, BucketPolicyMapper) {
    /**
     * The name of the Bucket.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Json-formatted authorization policies for buckets.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })
}

public object BucketPolicyMapper : ResourceMapper<BucketPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.oss.BucketPolicy::class == javaResource::class

    override fun map(javaResource: Resource): BucketPolicy = BucketPolicy(
        javaResource as
            com.pulumi.alicloud.oss.BucketPolicy,
    )
}

/**
 * @see [BucketPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketPolicy].
 */
public suspend fun bucketPolicy(
    name: String,
    block: suspend BucketPolicyResourceBuilder.() -> Unit,
): BucketPolicy {
    val builder = BucketPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketPolicy(name: String): BucketPolicy {
    val builder = BucketPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
