@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [BucketReferer].
 */
@PulumiTagMarker
public class BucketRefererResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketRefererArgs = BucketRefererArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketRefererArgsBuilder.() -> Unit) {
        val builder = BucketRefererArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BucketReferer {
        val builtJavaResource = com.pulumi.alicloud.oss.BucketReferer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BucketReferer(builtJavaResource)
    }
}

/**
 * Provides a OSS Bucket Referer resource. Bucket Referer configuration (Hotlink protection).
 * For information about OSS Bucket Referer and how to use it, see [What is Bucket Referer](https://www.alibabacloud.com/help/en/oss/user-guide/hotlink-protection).
 * > **NOTE:** Available since v1.220.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const createBucket = new alicloud.oss.Bucket("CreateBucket", {
 *     storageClass: "Standard",
 *     bucket: `${name}-${_default.result}`,
 * });
 * const defaultBucketReferer = new alicloud.oss.BucketReferer("default", {
 *     allowEmptyReferer: true,
 *     refererBlacklists: ["*&#46;forbidden&#46;com"],
 *     bucket: createBucket.bucket,
 *     truncatePath: false,
 *     allowTruncateQueryString: true,
 *     refererLists: [
 *         "*.aliyun.com",
 *         "*.example.com",
 *     ],
 * }, {
 *     dependsOn: [createBucket],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * create_bucket = alicloud.oss.Bucket("CreateBucket",
 *     storage_class="Standard",
 *     bucket=f"{name}-{default['result']}")
 * default_bucket_referer = alicloud.oss.BucketReferer("default",
 *     allow_empty_referer=True,
 *     referer_blacklists=["*&#46;forbidden&#46;com"],
 *     bucket=create_bucket.bucket,
 *     truncate_path=False,
 *     allow_truncate_query_string=True,
 *     referer_lists=[
 *         "*.aliyun.com",
 *         "*.example.com",
 *     ],
 *     opts = pulumi.ResourceOptions(depends_on=[create_bucket]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var createBucket = new AliCloud.Oss.Bucket("CreateBucket", new()
 *     {
 *         StorageClass = "Standard",
 *         BucketName = $"{name}-{@default.Result}",
 *     });
 *     var defaultBucketReferer = new AliCloud.Oss.BucketReferer("default", new()
 *     {
 *         AllowEmptyReferer = true,
 *         RefererBlacklists = new[]
 *         {
 *             "*.forbidden.com",
 *         },
 *         Bucket = createBucket.BucketName,
 *         TruncatePath = false,
 *         AllowTruncateQueryString = true,
 *         RefererLists = new[]
 *         {
 *             "*.aliyun.com",
 *             "*.example.com",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             createBucket,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		createBucket, err := oss.NewBucket(ctx, "CreateBucket", &oss.BucketArgs{
 * 			StorageClass: pulumi.String("Standard"),
 * 			Bucket:       pulumi.Sprintf("%v-%v", name, _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oss.NewBucketReferer(ctx, "default", &oss.BucketRefererArgs{
 * 			AllowEmptyReferer: pulumi.Bool(true),
 * 			RefererBlacklists: pulumi.StringArray{
 * 				pulumi.String("*.forbidden.com"),
 * 			},
 * 			Bucket:                   createBucket.Bucket,
 * 			TruncatePath:             pulumi.Bool(false),
 * 			AllowTruncateQueryString: pulumi.Bool(true),
 * 			RefererLists: pulumi.StringArray{
 * 				pulumi.String("*.aliyun.com"),
 * 				pulumi.String("*.example.com"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			createBucket,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.oss.BucketReferer;
 * import com.pulumi.alicloud.oss.BucketRefererArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var createBucket = new Bucket("createBucket", BucketArgs.builder()
 *             .storageClass("Standard")
 *             .bucket(String.format("%s-%s", name,default_.result()))
 *             .build());
 *         var defaultBucketReferer = new BucketReferer("defaultBucketReferer", BucketRefererArgs.builder()
 *             .allowEmptyReferer("true")
 *             .refererBlacklists("*.forbidden.com")
 *             .bucket(createBucket.bucket())
 *             .truncatePath("false")
 *             .allowTruncateQueryString("true")
 *             .refererLists(
 *                 "*.aliyun.com",
 *                 "*.example.com")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(createBucket)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   createBucket:
 *     type: alicloud:oss:Bucket
 *     name: CreateBucket
 *     properties:
 *       storageClass: Standard
 *       bucket: ${name}-${default.result}
 *   defaultBucketReferer:
 *     type: alicloud:oss:BucketReferer
 *     name: default
 *     properties:
 *       allowEmptyReferer: 'true'
 *       refererBlacklists:
 *         - '*.forbidden.com'
 *       bucket: ${createBucket.bucket}
 *       truncatePath: 'false'
 *       allowTruncateQueryString: 'true'
 *       refererLists:
 *         - '*.aliyun.com'
 *         - '*.example.com'
 *     options:
 *       dependson:
 *         - ${createBucket}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OSS Bucket Referer can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oss/bucketReferer:BucketReferer example <id>
 * ```
 */
public class BucketReferer internal constructor(
    override val javaResource: com.pulumi.alicloud.oss.BucketReferer,
) : KotlinCustomResource(javaResource, BucketRefererMapper) {
    /**
     * Whether to allow empty Referer request headers.
     */
    public val allowEmptyReferer: Output<Boolean>
        get() = javaResource.allowEmptyReferer().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to truncate the query string in the URL when the Referer is matched. Valid values: true, false.
     */
    public val allowTruncateQueryString: Output<Boolean>
        get() = javaResource.allowTruncateQueryString().applyValue({ args0 -> args0 })

    /**
     * Name of the Bucket.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * The container that holds the Referer blacklist.
     */
    public val refererBlacklists: Output<List<String>>?
        get() = javaResource.refererBlacklists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The container that holds the Referer whitelist.
     */
    public val refererLists: Output<List<String>>?
        get() = javaResource.refererLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Specifies whether to truncate the path and parts that follow the path in the URL when the Referer is matched. Valid values: true, false. If TruncatePath is set to true, the value of AllowTruncateQueryString must be also true because the query string follows the path component. When the path is truncated, the query string is also truncated.
     */
    public val truncatePath: Output<Boolean>?
        get() = javaResource.truncatePath().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object BucketRefererMapper : ResourceMapper<BucketReferer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.oss.BucketReferer::class == javaResource::class

    override fun map(javaResource: Resource): BucketReferer = BucketReferer(
        javaResource as
            com.pulumi.alicloud.oss.BucketReferer,
    )
}

/**
 * @see [BucketReferer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketReferer].
 */
public suspend fun bucketReferer(
    name: String,
    block: suspend BucketRefererResourceBuilder.() -> Unit,
): BucketReferer {
    val builder = BucketRefererResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketReferer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketReferer(name: String): BucketReferer {
    val builder = BucketRefererResourceBuilder()
    builder.name(name)
    return builder.build()
}
