@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin

import com.pulumi.alicloud.oss.BucketRefererArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a OSS Bucket Referer resource. Bucket Referer configuration (Hotlink protection).
 * For information about OSS Bucket Referer and how to use it, see [What is Bucket Referer](https://www.alibabacloud.com/help/en/oss/user-guide/hotlink-protection).
 * > **NOTE:** Available since v1.220.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const createBucket = new alicloud.oss.Bucket("CreateBucket", {
 *     storageClass: "Standard",
 *     bucket: `${name}-${_default.result}`,
 * });
 * const defaultBucketReferer = new alicloud.oss.BucketReferer("default", {
 *     allowEmptyReferer: true,
 *     refererBlacklists: ["*&#46;forbidden&#46;com"],
 *     bucket: createBucket.bucket,
 *     truncatePath: false,
 *     allowTruncateQueryString: true,
 *     refererLists: [
 *         "*.aliyun.com",
 *         "*.example.com",
 *     ],
 * }, {
 *     dependsOn: [createBucket],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * create_bucket = alicloud.oss.Bucket("CreateBucket",
 *     storage_class="Standard",
 *     bucket=f"{name}-{default['result']}")
 * default_bucket_referer = alicloud.oss.BucketReferer("default",
 *     allow_empty_referer=True,
 *     referer_blacklists=["*&#46;forbidden&#46;com"],
 *     bucket=create_bucket.bucket,
 *     truncate_path=False,
 *     allow_truncate_query_string=True,
 *     referer_lists=[
 *         "*.aliyun.com",
 *         "*.example.com",
 *     ],
 *     opts = pulumi.ResourceOptions(depends_on=[create_bucket]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var createBucket = new AliCloud.Oss.Bucket("CreateBucket", new()
 *     {
 *         StorageClass = "Standard",
 *         BucketName = $"{name}-{@default.Result}",
 *     });
 *     var defaultBucketReferer = new AliCloud.Oss.BucketReferer("default", new()
 *     {
 *         AllowEmptyReferer = true,
 *         RefererBlacklists = new[]
 *         {
 *             "*.forbidden.com",
 *         },
 *         Bucket = createBucket.BucketName,
 *         TruncatePath = false,
 *         AllowTruncateQueryString = true,
 *         RefererLists = new[]
 *         {
 *             "*.aliyun.com",
 *             "*.example.com",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             createBucket,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		createBucket, err := oss.NewBucket(ctx, "CreateBucket", &oss.BucketArgs{
 * 			StorageClass: pulumi.String("Standard"),
 * 			Bucket:       pulumi.Sprintf("%v-%v", name, _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oss.NewBucketReferer(ctx, "default", &oss.BucketRefererArgs{
 * 			AllowEmptyReferer: pulumi.Bool(true),
 * 			RefererBlacklists: pulumi.StringArray{
 * 				pulumi.String("*.forbidden.com"),
 * 			},
 * 			Bucket:                   createBucket.Bucket,
 * 			TruncatePath:             pulumi.Bool(false),
 * 			AllowTruncateQueryString: pulumi.Bool(true),
 * 			RefererLists: pulumi.StringArray{
 * 				pulumi.String("*.aliyun.com"),
 * 				pulumi.String("*.example.com"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			createBucket,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.oss.BucketReferer;
 * import com.pulumi.alicloud.oss.BucketRefererArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var createBucket = new Bucket("createBucket", BucketArgs.builder()
 *             .storageClass("Standard")
 *             .bucket(String.format("%s-%s", name,default_.result()))
 *             .build());
 *         var defaultBucketReferer = new BucketReferer("defaultBucketReferer", BucketRefererArgs.builder()
 *             .allowEmptyReferer("true")
 *             .refererBlacklists("*.forbidden.com")
 *             .bucket(createBucket.bucket())
 *             .truncatePath("false")
 *             .allowTruncateQueryString("true")
 *             .refererLists(
 *                 "*.aliyun.com",
 *                 "*.example.com")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(createBucket)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   createBucket:
 *     type: alicloud:oss:Bucket
 *     name: CreateBucket
 *     properties:
 *       storageClass: Standard
 *       bucket: ${name}-${default.result}
 *   defaultBucketReferer:
 *     type: alicloud:oss:BucketReferer
 *     name: default
 *     properties:
 *       allowEmptyReferer: 'true'
 *       refererBlacklists:
 *         - '*.forbidden.com'
 *       bucket: ${createBucket.bucket}
 *       truncatePath: 'false'
 *       allowTruncateQueryString: 'true'
 *       refererLists:
 *         - '*.aliyun.com'
 *         - '*.example.com'
 *     options:
 *       dependson:
 *         - ${createBucket}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OSS Bucket Referer can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oss/bucketReferer:BucketReferer example <id>
 * ```
 * @property allowEmptyReferer Whether to allow empty Referer request headers.
 * @property allowTruncateQueryString Specifies whether to truncate the query string in the URL when the Referer is matched. Valid values: true, false.
 * @property bucket Name of the Bucket.
 * @property refererBlacklists The container that holds the Referer blacklist.
 * @property refererLists The container that holds the Referer whitelist.
 * @property truncatePath Specifies whether to truncate the path and parts that follow the path in the URL when the Referer is matched. Valid values: true, false. If TruncatePath is set to true, the value of AllowTruncateQueryString must be also true because the query string follows the path component. When the path is truncated, the query string is also truncated.
 */
public data class BucketRefererArgs(
    public val allowEmptyReferer: Output<Boolean>? = null,
    public val allowTruncateQueryString: Output<Boolean>? = null,
    public val bucket: Output<String>? = null,
    public val refererBlacklists: Output<List<String>>? = null,
    public val refererLists: Output<List<String>>? = null,
    public val truncatePath: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.BucketRefererArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.BucketRefererArgs =
        com.pulumi.alicloud.oss.BucketRefererArgs.builder()
            .allowEmptyReferer(allowEmptyReferer?.applyValue({ args0 -> args0 }))
            .allowTruncateQueryString(allowTruncateQueryString?.applyValue({ args0 -> args0 }))
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .refererBlacklists(refererBlacklists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .refererLists(refererLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .truncatePath(truncatePath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketRefererArgs].
 */
@PulumiTagMarker
public class BucketRefererArgsBuilder internal constructor() {
    private var allowEmptyReferer: Output<Boolean>? = null

    private var allowTruncateQueryString: Output<Boolean>? = null

    private var bucket: Output<String>? = null

    private var refererBlacklists: Output<List<String>>? = null

    private var refererLists: Output<List<String>>? = null

    private var truncatePath: Output<Boolean>? = null

    /**
     * @param value Whether to allow empty Referer request headers.
     */
    @JvmName("oifisupqymowdrsh")
    public suspend fun allowEmptyReferer(`value`: Output<Boolean>) {
        this.allowEmptyReferer = value
    }

    /**
     * @param value Specifies whether to truncate the query string in the URL when the Referer is matched. Valid values: true, false.
     */
    @JvmName("jpxlvmxbojvvdmif")
    public suspend fun allowTruncateQueryString(`value`: Output<Boolean>) {
        this.allowTruncateQueryString = value
    }

    /**
     * @param value Name of the Bucket.
     */
    @JvmName("oqwfwmfirgjdshyx")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value The container that holds the Referer blacklist.
     */
    @JvmName("cwjwwdrfffxkkxiw")
    public suspend fun refererBlacklists(`value`: Output<List<String>>) {
        this.refererBlacklists = value
    }

    @JvmName("nkievxxloavakcun")
    public suspend fun refererBlacklists(vararg values: Output<String>) {
        this.refererBlacklists = Output.all(values.asList())
    }

    /**
     * @param values The container that holds the Referer blacklist.
     */
    @JvmName("biqsgbqavsapitre")
    public suspend fun refererBlacklists(values: List<Output<String>>) {
        this.refererBlacklists = Output.all(values)
    }

    /**
     * @param value The container that holds the Referer whitelist.
     */
    @JvmName("jnjsqhmrnwjmdgwk")
    public suspend fun refererLists(`value`: Output<List<String>>) {
        this.refererLists = value
    }

    @JvmName("fqqhkugankjfmofd")
    public suspend fun refererLists(vararg values: Output<String>) {
        this.refererLists = Output.all(values.asList())
    }

    /**
     * @param values The container that holds the Referer whitelist.
     */
    @JvmName("oxjkykadqmhsohge")
    public suspend fun refererLists(values: List<Output<String>>) {
        this.refererLists = Output.all(values)
    }

    /**
     * @param value Specifies whether to truncate the path and parts that follow the path in the URL when the Referer is matched. Valid values: true, false. If TruncatePath is set to true, the value of AllowTruncateQueryString must be also true because the query string follows the path component. When the path is truncated, the query string is also truncated.
     */
    @JvmName("wmbehckoyfqvnhij")
    public suspend fun truncatePath(`value`: Output<Boolean>) {
        this.truncatePath = value
    }

    /**
     * @param value Whether to allow empty Referer request headers.
     */
    @JvmName("pfmwqjhxrjynejqp")
    public suspend fun allowEmptyReferer(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowEmptyReferer = mapped
    }

    /**
     * @param value Specifies whether to truncate the query string in the URL when the Referer is matched. Valid values: true, false.
     */
    @JvmName("jqgtbljxdkpxqdfi")
    public suspend fun allowTruncateQueryString(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowTruncateQueryString = mapped
    }

    /**
     * @param value Name of the Bucket.
     */
    @JvmName("nvqcgmrshyyjxpxd")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value The container that holds the Referer blacklist.
     */
    @JvmName("ndglwobewceldatx")
    public suspend fun refererBlacklists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refererBlacklists = mapped
    }

    /**
     * @param values The container that holds the Referer blacklist.
     */
    @JvmName("kunbnpbfaenhcyhf")
    public suspend fun refererBlacklists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.refererBlacklists = mapped
    }

    /**
     * @param value The container that holds the Referer whitelist.
     */
    @JvmName("uejhrimyynwxhtvm")
    public suspend fun refererLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refererLists = mapped
    }

    /**
     * @param values The container that holds the Referer whitelist.
     */
    @JvmName("vhynfpaaxggwxikn")
    public suspend fun refererLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.refererLists = mapped
    }

    /**
     * @param value Specifies whether to truncate the path and parts that follow the path in the URL when the Referer is matched. Valid values: true, false. If TruncatePath is set to true, the value of AllowTruncateQueryString must be also true because the query string follows the path component. When the path is truncated, the query string is also truncated.
     */
    @JvmName("sqhhreqhulpoiigw")
    public suspend fun truncatePath(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.truncatePath = mapped
    }

    internal fun build(): BucketRefererArgs = BucketRefererArgs(
        allowEmptyReferer = allowEmptyReferer,
        allowTruncateQueryString = allowTruncateQueryString,
        bucket = bucket,
        refererBlacklists = refererBlacklists,
        refererLists = refererLists,
        truncatePath = truncatePath,
    )
}
