@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin

import com.pulumi.alicloud.oss.BucketReplicationArgs.builder
import com.pulumi.alicloud.oss.kotlin.inputs.BucketReplicationDestinationArgs
import com.pulumi.alicloud.oss.kotlin.inputs.BucketReplicationDestinationArgsBuilder
import com.pulumi.alicloud.oss.kotlin.inputs.BucketReplicationEncryptionConfigurationArgs
import com.pulumi.alicloud.oss.kotlin.inputs.BucketReplicationEncryptionConfigurationArgsBuilder
import com.pulumi.alicloud.oss.kotlin.inputs.BucketReplicationPrefixSetArgs
import com.pulumi.alicloud.oss.kotlin.inputs.BucketReplicationPrefixSetArgsBuilder
import com.pulumi.alicloud.oss.kotlin.inputs.BucketReplicationProgressArgs
import com.pulumi.alicloud.oss.kotlin.inputs.BucketReplicationProgressArgsBuilder
import com.pulumi.alicloud.oss.kotlin.inputs.BucketReplicationSourceSelectionCriteriaArgs
import com.pulumi.alicloud.oss.kotlin.inputs.BucketReplicationSourceSelectionCriteriaArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an independent replication configuration resource for OSS bucket.
 * For information about OSS replication and how to use it, see [What is cross-region replication](https://www&#46;alibabacloud&#46;com/help/doc-detail/31864&#46;html) and [What is same-region replication](https://www.alibabacloud.com/help/doc-detail/254865.html).
 * > **NOTE:** Available since v1.161.0.
 * ## Example Usage
 * Set bucket replication configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const bucketSrc = new alicloud.oss.Bucket("bucket_src", {bucket: `example-src-${_default.result}`});
 * const bucketDest = new alicloud.oss.Bucket("bucket_dest", {bucket: `example-dest-${_default.result}`});
 * const role = new alicloud.ram.Role("role", {
 *     name: `example-role-${_default.result}`,
 *     document: `\x09\x09{
 * \x09\x09  "Statement": [
 * \x09\x09\x09{
 * \x09\x09\x09  "Action": "sts:AssumeRole",
 * \x09\x09\x09  "Effect": "Allow",
 * \x09\x09\x09  "Principal": {
 * \x09\x09\x09\x09"Service": [
 * \x09\x09\x09\x09  "oss.aliyuncs.com"
 * \x09\x09\x09\x09]
 * \x09\x09\x09  }
 * \x09\x09\x09}
 * \x09\x09  ],
 * \x09\x09  "Version": "1"
 * \x09\x09}
 * `,
 *     description: "this is a test",
 *     force: true,
 * });
 * const policy = new alicloud.ram.Policy("policy", {
 *     policyName: `example-policy-${_default.result}`,
 *     policyDocument: `\x09\x09{
 * \x09\x09  "Statement": [
 * \x09\x09\x09{
 * \x09\x09\x09  "Action": [
 * \x09\x09\x09\x09"*"
 * \x09\x09\x09  ],
 * \x09\x09\x09  "Effect": "Allow",
 * \x09\x09\x09  "Resource": [
 * \x09\x09\x09\x09"*"
 * \x09\x09\x09  ]
 * \x09\x09\x09}
 * \x09\x09  ],
 * \x09\x09\x09"Version": "1"
 * \x09\x09}
 * `,
 *     description: "this is a policy test",
 *     force: true,
 * });
 * const attach = new alicloud.ram.RolePolicyAttachment("attach", {
 *     policyName: policy.name,
 *     policyType: policy.type,
 *     roleName: role.name,
 * });
 * const key = new alicloud.kms.Key("key", {
 *     description: "Hello KMS",
 *     pendingWindowInDays: 7,
 *     status: "Enabled",
 * });
 * const cross_region_replication = new alicloud.oss.BucketReplication("cross-region-replication", {
 *     bucket: bucketSrc.id,
 *     action: "PUT,DELETE",
 *     historicalObjectReplication: "enabled",
 *     prefixSet: {
 *         prefixes: [
 *             "prefix1/",
 *             "prefix2/",
 *         ],
 *     },
 *     destination: {
 *         bucket: bucketDest.id,
 *         location: bucketDest.location,
 *     },
 *     syncRole: role.name,
 *     encryptionConfiguration: {
 *         replicaKmsKeyId: key.id,
 *     },
 *     sourceSelectionCriteria: {
 *         sseKmsEncryptedObjects: {
 *             status: "Enabled",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * bucket_src = alicloud.oss.Bucket("bucket_src", bucket=f"example-src-{default['result']}")
 * bucket_dest = alicloud.oss.Bucket("bucket_dest", bucket=f"example-dest-{default['result']}")
 * role = alicloud.ram.Role("role",
 *     name=f"example-role-{default['result']}",
 *     document="""\x09\x09{
 * \x09\x09  "Statement": [
 * \x09\x09\x09{
 * \x09\x09\x09  "Action": "sts:AssumeRole",
 * \x09\x09\x09  "Effect": "Allow",
 * \x09\x09\x09  "Principal": {
 * \x09\x09\x09\x09"Service": [
 * \x09\x09\x09\x09  "oss.aliyuncs.com"
 * \x09\x09\x09\x09]
 * \x09\x09\x09  }
 * \x09\x09\x09}
 * \x09\x09  ],
 * \x09\x09  "Version": "1"
 * \x09\x09}
 * """,
 *     description="this is a test",
 *     force=True)
 * policy = alicloud.ram.Policy("policy",
 *     policy_name=f"example-policy-{default['result']}",
 *     policy_document="""\x09\x09{
 * \x09\x09  "Statement": [
 * \x09\x09\x09{
 * \x09\x09\x09  "Action": [
 * \x09\x09\x09\x09"*"
 * \x09\x09\x09  ],
 * \x09\x09\x09  "Effect": "Allow",
 * \x09\x09\x09  "Resource": [
 * \x09\x09\x09\x09"*"
 * \x09\x09\x09  ]
 * \x09\x09\x09}
 * \x09\x09  ],
 * \x09\x09\x09"Version": "1"
 * \x09\x09}
 * """,
 *     description="this is a policy test",
 *     force=True)
 * attach = alicloud.ram.RolePolicyAttachment("attach",
 *     policy_name=policy.name,
 *     policy_type=policy.type,
 *     role_name=role.name)
 * key = alicloud.kms.Key("key",
 *     description="Hello KMS",
 *     pending_window_in_days=7,
 *     status="Enabled")
 * cross_region_replication = alicloud.oss.BucketReplication("cross-region-replication",
 *     bucket=bucket_src.id,
 *     action="PUT,DELETE",
 *     historical_object_replication="enabled",
 *     prefix_set={
 *         "prefixes": [
 *             "prefix1/",
 *             "prefix2/",
 *         ],
 *     },
 *     destination={
 *         "bucket": bucket_dest.id,
 *         "location": bucket_dest.location,
 *     },
 *     sync_role=role.name,
 *     encryption_configuration={
 *         "replica_kms_key_id": key.id,
 *     },
 *     source_selection_criteria={
 *         "sse_kms_encrypted_objects": {
 *             "status": "Enabled",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var bucketSrc = new AliCloud.Oss.Bucket("bucket_src", new()
 *     {
 *         BucketName = $"example-src-{@default.Result}",
 *     });
 *     var bucketDest = new AliCloud.Oss.Bucket("bucket_dest", new()
 *     {
 *         BucketName = $"example-dest-{@default.Result}",
 *     });
 *     var role = new AliCloud.Ram.Role("role", new()
 *     {
 *         Name = $"example-role-{@default.Result}",
 *         Document = @"		{
 * 		  ""Statement"": [
 * 			{
 * 			  ""Action"": ""sts:AssumeRole"",
 * 			  ""Effect"": ""Allow"",
 * 			  ""Principal"": {
 * 				""Service"": [
 * 				  ""oss.aliyuncs.com""
 * 				]
 * 			  }
 * 			}
 * 		  ],
 * 		  ""Version"": ""1""
 * 		}
 * ",
 *         Description = "this is a test",
 *         Force = true,
 *     });
 *     var policy = new AliCloud.Ram.Policy("policy", new()
 *     {
 *         PolicyName = $"example-policy-{@default.Result}",
 *         PolicyDocument = @"		{
 * 		  ""Statement"": [
 * 			{
 * 			  ""Action"": [
 * 				""*""
 * 			  ],
 * 			  ""Effect"": ""Allow"",
 * 			  ""Resource"": [
 * 				""*""
 * 			  ]
 * 			}
 * 		  ],
 * 			""Version"": ""1""
 * 		}
 * ",
 *         Description = "this is a policy test",
 *         Force = true,
 *     });
 *     var attach = new AliCloud.Ram.RolePolicyAttachment("attach", new()
 *     {
 *         PolicyName = policy.Name,
 *         PolicyType = policy.Type,
 *         RoleName = role.Name,
 *     });
 *     var key = new AliCloud.Kms.Key("key", new()
 *     {
 *         Description = "Hello KMS",
 *         PendingWindowInDays = 7,
 *         Status = "Enabled",
 *     });
 *     var cross_region_replication = new AliCloud.Oss.BucketReplication("cross-region-replication", new()
 *     {
 *         Bucket = bucketSrc.Id,
 *         Action = "PUT,DELETE",
 *         HistoricalObjectReplication = "enabled",
 *         PrefixSet = new AliCloud.Oss.Inputs.BucketReplicationPrefixSetArgs
 *         {
 *             Prefixes = new[]
 *             {
 *                 "prefix1/",
 *                 "prefix2/",
 *             },
 *         },
 *         Destination = new AliCloud.Oss.Inputs.BucketReplicationDestinationArgs
 *         {
 *             Bucket = bucketDest.Id,
 *             Location = bucketDest.Location,
 *         },
 *         SyncRole = role.Name,
 *         EncryptionConfiguration = new AliCloud.Oss.Inputs.BucketReplicationEncryptionConfigurationArgs
 *         {
 *             ReplicaKmsKeyId = key.Id,
 *         },
 *         SourceSelectionCriteria = new AliCloud.Oss.Inputs.BucketReplicationSourceSelectionCriteriaArgs
 *         {
 *             SseKmsEncryptedObjects = new AliCloud.Oss.Inputs.BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjectsArgs
 *             {
 *                 Status = "Enabled",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		bucketSrc, err := oss.NewBucket(ctx, "bucket_src", &oss.BucketArgs{
 * 			Bucket: pulumi.Sprintf("example-src-%v", _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		bucketDest, err := oss.NewBucket(ctx, "bucket_dest", &oss.BucketArgs{
 * 			Bucket: pulumi.Sprintf("example-dest-%v", _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		role, err := ram.NewRole(ctx, "role", &ram.RoleArgs{
 * 			Name: pulumi.Sprintf("example-role-%v", _default.Result),
 * 			Document: pulumi.String(`		{
 * 		  "Statement": [
 * 			{
 * 			  "Action": "sts:AssumeRole",
 * 			  "Effect": "Allow",
 * 			  "Principal": {
 * 				"Service": [
 * 				  "oss.aliyuncs.com"
 * 				]
 * 			  }
 * 			}
 * 		  ],
 * 		  "Version": "1"
 * 		}
 * `),
 * 			Description: pulumi.String("this is a test"),
 * 			Force:       pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		policy, err := ram.NewPolicy(ctx, "policy", &ram.PolicyArgs{
 * 			PolicyName: pulumi.Sprintf("example-policy-%v", _default.Result),
 * 			PolicyDocument: pulumi.String(`		{
 * 		  "Statement": [
 * 			{
 * 			  "Action": [
 * 				"*"
 * 			  ],
 * 			  "Effect": "Allow",
 * 			  "Resource": [
 * 				"*"
 * 			  ]
 * 			}
 * 		  ],
 * 			"Version": "1"
 * 		}
 * `),
 * 			Description: pulumi.String("this is a policy test"),
 * 			Force:       pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ram.NewRolePolicyAttachment(ctx, "attach", &ram.RolePolicyAttachmentArgs{
 * 			PolicyName: policy.Name,
 * 			PolicyType: policy.Type,
 * 			RoleName:   role.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		key, err := kms.NewKey(ctx, "key", &kms.KeyArgs{
 * 			Description:         pulumi.String("Hello KMS"),
 * 			PendingWindowInDays: pulumi.Int(7),
 * 			Status:              pulumi.String("Enabled"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oss.NewBucketReplication(ctx, "cross-region-replication", &oss.BucketReplicationArgs{
 * 			Bucket:                      bucketSrc.ID(),
 * 			Action:                      pulumi.String("PUT,DELETE"),
 * 			HistoricalObjectReplication: pulumi.String("enabled"),
 * 			PrefixSet: &oss.BucketReplicationPrefixSetArgs{
 * 				Prefixes: pulumi.StringArray{
 * 					pulumi.String("prefix1/"),
 * 					pulumi.String("prefix2/"),
 * 				},
 * 			},
 * 			Destination: &oss.BucketReplicationDestinationArgs{
 * 				Bucket:   bucketDest.ID(),
 * 				Location: bucketDest.Location,
 * 			},
 * 			SyncRole: role.Name,
 * 			EncryptionConfiguration: &oss.BucketReplicationEncryptionConfigurationArgs{
 * 				ReplicaKmsKeyId: key.ID(),
 * 			},
 * 			SourceSelectionCriteria: &oss.BucketReplicationSourceSelectionCriteriaArgs{
 * 				SseKmsEncryptedObjects: &oss.BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjectsArgs{
 * 					Status: pulumi.String("Enabled"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.ram.Role;
 * import com.pulumi.alicloud.ram.RoleArgs;
 * import com.pulumi.alicloud.ram.Policy;
 * import com.pulumi.alicloud.ram.PolicyArgs;
 * import com.pulumi.alicloud.ram.RolePolicyAttachment;
 * import com.pulumi.alicloud.ram.RolePolicyAttachmentArgs;
 * import com.pulumi.alicloud.kms.Key;
 * import com.pulumi.alicloud.kms.KeyArgs;
 * import com.pulumi.alicloud.oss.BucketReplication;
 * import com.pulumi.alicloud.oss.BucketReplicationArgs;
 * import com.pulumi.alicloud.oss.inputs.BucketReplicationPrefixSetArgs;
 * import com.pulumi.alicloud.oss.inputs.BucketReplicationDestinationArgs;
 * import com.pulumi.alicloud.oss.inputs.BucketReplicationEncryptionConfigurationArgs;
 * import com.pulumi.alicloud.oss.inputs.BucketReplicationSourceSelectionCriteriaArgs;
 * import com.pulumi.alicloud.oss.inputs.BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjectsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var bucketSrc = new Bucket("bucketSrc", BucketArgs.builder()
 *             .bucket(String.format("example-src-%s", default_.result()))
 *             .build());
 *         var bucketDest = new Bucket("bucketDest", BucketArgs.builder()
 *             .bucket(String.format("example-dest-%s", default_.result()))
 *             .build());
 *         var role = new Role("role", RoleArgs.builder()
 *             .name(String.format("example-role-%s", default_.result()))
 *             .document("""
 * 		{
 * 		  "Statement": [
 * 			{
 * 			  "Action": "sts:AssumeRole",
 * 			  "Effect": "Allow",
 * 			  "Principal": {
 * 				"Service": [
 * 				  "oss.aliyuncs.com"
 * 				]
 * 			  }
 * 			}
 * 		  ],
 * 		  "Version": "1"
 * 		}
 *             """)
 *             .description("this is a test")
 *             .force(true)
 *             .build());
 *         var policy = new Policy("policy", PolicyArgs.builder()
 *             .policyName(String.format("example-policy-%s", default_.result()))
 *             .policyDocument("""
 * 		{
 * 		  "Statement": [
 * 			{
 * 			  "Action": [
 * 				"*"
 * 			  ],
 * 			  "Effect": "Allow",
 * 			  "Resource": [
 * 				"*"
 * 			  ]
 * 			}
 * 		  ],
 * 			"Version": "1"
 * 		}
 *             """)
 *             .description("this is a policy test")
 *             .force(true)
 *             .build());
 *         var attach = new RolePolicyAttachment("attach", RolePolicyAttachmentArgs.builder()
 *             .policyName(policy.name())
 *             .policyType(policy.type())
 *             .roleName(role.name())
 *             .build());
 *         var key = new Key("key", KeyArgs.builder()
 *             .description("Hello KMS")
 *             .pendingWindowInDays("7")
 *             .status("Enabled")
 *             .build());
 *         var cross_region_replication = new BucketReplication("cross-region-replication", BucketReplicationArgs.builder()
 *             .bucket(bucketSrc.id())
 *             .action("PUT,DELETE")
 *             .historicalObjectReplication("enabled")
 *             .prefixSet(BucketReplicationPrefixSetArgs.builder()
 *                 .prefixes(
 *                     "prefix1/",
 *                     "prefix2/")
 *                 .build())
 *             .destination(BucketReplicationDestinationArgs.builder()
 *                 .bucket(bucketDest.id())
 *                 .location(bucketDest.location())
 *                 .build())
 *             .syncRole(role.name())
 *             .encryptionConfiguration(BucketReplicationEncryptionConfigurationArgs.builder()
 *                 .replicaKmsKeyId(key.id())
 *                 .build())
 *             .sourceSelectionCriteria(BucketReplicationSourceSelectionCriteriaArgs.builder()
 *                 .sseKmsEncryptedObjects(BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjectsArgs.builder()
 *                     .status("Enabled")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       max: 99999
 *       min: 10000
 *   bucketSrc:
 *     type: alicloud:oss:Bucket
 *     name: bucket_src
 *     properties:
 *       bucket: example-src-${default.result}
 *   bucketDest:
 *     type: alicloud:oss:Bucket
 *     name: bucket_dest
 *     properties:
 *       bucket: example-dest-${default.result}
 *   role:
 *     type: alicloud:ram:Role
 *     properties:
 *       name: example-role-${default.result}
 *       document: |
 *         		{
 *         		  "Statement": [
 *         			{
 *         			  "Action": "sts:AssumeRole",
 *         			  "Effect": "Allow",
 *         			  "Principal": {
 *         				"Service": [
 *         				  "oss.aliyuncs.com"
 *         				]
 *         			  }
 *         			}
 *         		  ],
 *         		  "Version": "1"
 *         		}
 *       description: this is a test
 *       force: true
 *   policy:
 *     type: alicloud:ram:Policy
 *     properties:
 *       policyName: example-policy-${default.result}
 *       policyDocument: |
 *         		{
 *         		  "Statement": [
 *         			{
 *         			  "Action": [
 *         				"*"
 *         			  ],
 *         			  "Effect": "Allow",
 *         			  "Resource": [
 *         				"*"
 *         			  ]
 *         			}
 *         		  ],
 *         			"Version": "1"
 *         		}
 *       description: this is a policy test
 *       force: true
 *   attach:
 *     type: alicloud:ram:RolePolicyAttachment
 *     properties:
 *       policyName: ${policy.name}
 *       policyType: ${policy.type}
 *       roleName: ${role.name}
 *   key:
 *     type: alicloud:kms:Key
 *     properties:
 *       description: Hello KMS
 *       pendingWindowInDays: '7'
 *       status: Enabled
 *   cross-region-replication:
 *     type: alicloud:oss:BucketReplication
 *     properties:
 *       bucket: ${bucketSrc.id}
 *       action: PUT,DELETE
 *       historicalObjectReplication: enabled
 *       prefixSet:
 *         prefixes:
 *           - prefix1/
 *           - prefix2/
 *       destination:
 *         bucket: ${bucketDest.id}
 *         location: ${bucketDest.location}
 *       syncRole: ${role.name}
 *       encryptionConfiguration:
 *         replicaKmsKeyId: ${key.id}
 *       sourceSelectionCriteria:
 *         sseKmsEncryptedObjects:
 *           status: Enabled
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ### Timeouts
 * The `timeouts` block allows you to specify timeouts for certain actions:
 * * `delete` - (Defaults to 30 mins) Used when delete a data replication rule (until the data replication task is cleared).
 * @property action The operations that can be synchronized to the destination bucket. You can set action to one or more of the following operation types. Valid values: `ALL`(contains PUT, DELETE, and ABORT), `PUT`, `DELETE` and `ABORT`. Defaults to `ALL`.
 * @property bucket The name of the bucket.
 * @property destination Specifies the destination for the rule. See `destination` below.
 * @property encryptionConfiguration Specifies the encryption configuration for the objects replicated to the destination bucket. See `encryption_configuration` below.
 * @property historicalObjectReplication Specifies whether to replicate historical data from the source bucket to the destination bucket before data replication is enabled. Can be `enabled` or `disabled`. Defaults to `enabled`.
 * @property prefixSet The prefixes used to specify the object to replicate. Only objects that match the prefix are replicated to the destination bucket. See `prefix_set` below.
 * @property progress Specifies the progress for querying the progress of a data replication task of a bucket.
 * @property sourceSelectionCriteria Specifies other conditions used to filter the source objects to replicate. See `source_selection_criteria` below.
 * @property syncRole Specifies the role that you authorize OSS to use to replicate data. If SSE-KMS is specified to encrypt the objects replicated to the destination bucket, it must be specified.
 */
public data class BucketReplicationArgs(
    public val action: Output<String>? = null,
    public val bucket: Output<String>? = null,
    public val destination: Output<BucketReplicationDestinationArgs>? = null,
    public val encryptionConfiguration: Output<BucketReplicationEncryptionConfigurationArgs>? = null,
    public val historicalObjectReplication: Output<String>? = null,
    public val prefixSet: Output<BucketReplicationPrefixSetArgs>? = null,
    public val progress: Output<BucketReplicationProgressArgs>? = null,
    public val sourceSelectionCriteria: Output<BucketReplicationSourceSelectionCriteriaArgs>? = null,
    public val syncRole: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.BucketReplicationArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.BucketReplicationArgs =
        com.pulumi.alicloud.oss.BucketReplicationArgs.builder()
            .action(action?.applyValue({ args0 -> args0 }))
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .destination(destination?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .encryptionConfiguration(
                encryptionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .historicalObjectReplication(historicalObjectReplication?.applyValue({ args0 -> args0 }))
            .prefixSet(prefixSet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .progress(progress?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceSelectionCriteria(
                sourceSelectionCriteria?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .syncRole(syncRole?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketReplicationArgs].
 */
@PulumiTagMarker
public class BucketReplicationArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var bucket: Output<String>? = null

    private var destination: Output<BucketReplicationDestinationArgs>? = null

    private var encryptionConfiguration: Output<BucketReplicationEncryptionConfigurationArgs>? = null

    private var historicalObjectReplication: Output<String>? = null

    private var prefixSet: Output<BucketReplicationPrefixSetArgs>? = null

    private var progress: Output<BucketReplicationProgressArgs>? = null

    private var sourceSelectionCriteria: Output<BucketReplicationSourceSelectionCriteriaArgs>? = null

    private var syncRole: Output<String>? = null

    /**
     * @param value The operations that can be synchronized to the destination bucket. You can set action to one or more of the following operation types. Valid values: `ALL`(contains PUT, DELETE, and ABORT), `PUT`, `DELETE` and `ABORT`. Defaults to `ALL`.
     */
    @JvmName("abjymnoxhhpavoiy")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value The name of the bucket.
     */
    @JvmName("pwdehoaipehbwqqm")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Specifies the destination for the rule. See `destination` below.
     */
    @JvmName("aaejlbqqgkiifvmb")
    public suspend fun destination(`value`: Output<BucketReplicationDestinationArgs>) {
        this.destination = value
    }

    /**
     * @param value Specifies the encryption configuration for the objects replicated to the destination bucket. See `encryption_configuration` below.
     */
    @JvmName("wevwdjoexhdcokta")
    public suspend fun encryptionConfiguration(`value`: Output<BucketReplicationEncryptionConfigurationArgs>) {
        this.encryptionConfiguration = value
    }

    /**
     * @param value Specifies whether to replicate historical data from the source bucket to the destination bucket before data replication is enabled. Can be `enabled` or `disabled`. Defaults to `enabled`.
     */
    @JvmName("leqddkyxymwhliss")
    public suspend fun historicalObjectReplication(`value`: Output<String>) {
        this.historicalObjectReplication = value
    }

    /**
     * @param value The prefixes used to specify the object to replicate. Only objects that match the prefix are replicated to the destination bucket. See `prefix_set` below.
     */
    @JvmName("gebbnapihgbaijkd")
    public suspend fun prefixSet(`value`: Output<BucketReplicationPrefixSetArgs>) {
        this.prefixSet = value
    }

    /**
     * @param value Specifies the progress for querying the progress of a data replication task of a bucket.
     */
    @JvmName("jhnqcemjhtyxhvrd")
    public suspend fun progress(`value`: Output<BucketReplicationProgressArgs>) {
        this.progress = value
    }

    /**
     * @param value Specifies other conditions used to filter the source objects to replicate. See `source_selection_criteria` below.
     */
    @JvmName("yomovkffhgrtjohq")
    public suspend fun sourceSelectionCriteria(`value`: Output<BucketReplicationSourceSelectionCriteriaArgs>) {
        this.sourceSelectionCriteria = value
    }

    /**
     * @param value Specifies the role that you authorize OSS to use to replicate data. If SSE-KMS is specified to encrypt the objects replicated to the destination bucket, it must be specified.
     */
    @JvmName("ipbrkkwjkmhyyoin")
    public suspend fun syncRole(`value`: Output<String>) {
        this.syncRole = value
    }

    /**
     * @param value The operations that can be synchronized to the destination bucket. You can set action to one or more of the following operation types. Valid values: `ALL`(contains PUT, DELETE, and ABORT), `PUT`, `DELETE` and `ABORT`. Defaults to `ALL`.
     */
    @JvmName("jinnyvydfnixysde")
    public suspend fun action(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value The name of the bucket.
     */
    @JvmName("bsbgoqiactkpumgp")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Specifies the destination for the rule. See `destination` below.
     */
    @JvmName("renfbfmvogtrsivo")
    public suspend fun destination(`value`: BucketReplicationDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param argument Specifies the destination for the rule. See `destination` below.
     */
    @JvmName("rpfhoojjbivpfoir")
    public suspend fun destination(argument: suspend BucketReplicationDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = BucketReplicationDestinationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.destination = mapped
    }

    /**
     * @param value Specifies the encryption configuration for the objects replicated to the destination bucket. See `encryption_configuration` below.
     */
    @JvmName("rigescxfbtrmthhu")
    public suspend fun encryptionConfiguration(`value`: BucketReplicationEncryptionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionConfiguration = mapped
    }

    /**
     * @param argument Specifies the encryption configuration for the objects replicated to the destination bucket. See `encryption_configuration` below.
     */
    @JvmName("sppcfcqiqdgvjcnn")
    public suspend fun encryptionConfiguration(argument: suspend BucketReplicationEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = BucketReplicationEncryptionConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.encryptionConfiguration = mapped
    }

    /**
     * @param value Specifies whether to replicate historical data from the source bucket to the destination bucket before data replication is enabled. Can be `enabled` or `disabled`. Defaults to `enabled`.
     */
    @JvmName("bbtkotggqtjjlysh")
    public suspend fun historicalObjectReplication(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.historicalObjectReplication = mapped
    }

    /**
     * @param value The prefixes used to specify the object to replicate. Only objects that match the prefix are replicated to the destination bucket. See `prefix_set` below.
     */
    @JvmName("mbxkiptglmdcomki")
    public suspend fun prefixSet(`value`: BucketReplicationPrefixSetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixSet = mapped
    }

    /**
     * @param argument The prefixes used to specify the object to replicate. Only objects that match the prefix are replicated to the destination bucket. See `prefix_set` below.
     */
    @JvmName("wcvntdpiwkivftqs")
    public suspend fun prefixSet(argument: suspend BucketReplicationPrefixSetArgsBuilder.() -> Unit) {
        val toBeMapped = BucketReplicationPrefixSetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.prefixSet = mapped
    }

    /**
     * @param value Specifies the progress for querying the progress of a data replication task of a bucket.
     */
    @JvmName("lycxcfdaeabsrhar")
    public suspend fun progress(`value`: BucketReplicationProgressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.progress = mapped
    }

    /**
     * @param argument Specifies the progress for querying the progress of a data replication task of a bucket.
     */
    @JvmName("yqhbuafesqonfhdy")
    public suspend fun progress(argument: suspend BucketReplicationProgressArgsBuilder.() -> Unit) {
        val toBeMapped = BucketReplicationProgressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.progress = mapped
    }

    /**
     * @param value Specifies other conditions used to filter the source objects to replicate. See `source_selection_criteria` below.
     */
    @JvmName("mbbvcgprwineylgt")
    public suspend fun sourceSelectionCriteria(`value`: BucketReplicationSourceSelectionCriteriaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceSelectionCriteria = mapped
    }

    /**
     * @param argument Specifies other conditions used to filter the source objects to replicate. See `source_selection_criteria` below.
     */
    @JvmName("olxprkwapnkuddvt")
    public suspend fun sourceSelectionCriteria(argument: suspend BucketReplicationSourceSelectionCriteriaArgsBuilder.() -> Unit) {
        val toBeMapped = BucketReplicationSourceSelectionCriteriaArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sourceSelectionCriteria = mapped
    }

    /**
     * @param value Specifies the role that you authorize OSS to use to replicate data. If SSE-KMS is specified to encrypt the objects replicated to the destination bucket, it must be specified.
     */
    @JvmName("jiaprlydpdvwpnvd")
    public suspend fun syncRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncRole = mapped
    }

    internal fun build(): BucketReplicationArgs = BucketReplicationArgs(
        action = action,
        bucket = bucket,
        destination = destination,
        encryptionConfiguration = encryptionConfiguration,
        historicalObjectReplication = historicalObjectReplication,
        prefixSet = prefixSet,
        progress = progress,
        sourceSelectionCriteria = sourceSelectionCriteria,
        syncRole = syncRole,
    )
}
