@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BucketRequestPayment].
 */
@PulumiTagMarker
public class BucketRequestPaymentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketRequestPaymentArgs = BucketRequestPaymentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketRequestPaymentArgsBuilder.() -> Unit) {
        val builder = BucketRequestPaymentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BucketRequestPayment {
        val builtJavaResource = com.pulumi.alicloud.oss.BucketRequestPayment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BucketRequestPayment(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * OSS Bucket Request Payment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oss/bucketRequestPayment:BucketRequestPayment example <id>
 * ```
 */
public class BucketRequestPayment internal constructor(
    override val javaResource: com.pulumi.alicloud.oss.BucketRequestPayment,
) : KotlinCustomResource(javaResource, BucketRequestPaymentMapper) {
    /**
     * The name of the bucket.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * The payer of the request and traffic fees.Valid values: BucketOwner: request and traffic fees are paid by the bucket owner. Requester: request and traffic fees are paid by the requester.
     */
    public val payer: Output<String>
        get() = javaResource.payer().applyValue({ args0 -> args0 })
}

public object BucketRequestPaymentMapper : ResourceMapper<BucketRequestPayment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.oss.BucketRequestPayment::class == javaResource::class

    override fun map(javaResource: Resource): BucketRequestPayment = BucketRequestPayment(
        javaResource
            as com.pulumi.alicloud.oss.BucketRequestPayment,
    )
}

/**
 * @see [BucketRequestPayment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketRequestPayment].
 */
public suspend fun bucketRequestPayment(
    name: String,
    block: suspend BucketRequestPaymentResourceBuilder.() -> Unit,
): BucketRequestPayment {
    val builder = BucketRequestPaymentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketRequestPayment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketRequestPayment(name: String): BucketRequestPayment {
    val builder = BucketRequestPaymentResourceBuilder()
    builder.name(name)
    return builder.build()
}
