@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin

import com.pulumi.alicloud.oss.BucketRequestPaymentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * OSS Bucket Request Payment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oss/bucketRequestPayment:BucketRequestPayment example <id>
 * ```
 * @property bucket The name of the bucket.
 * @property payer The payer of the request and traffic fees.Valid values: BucketOwner: request and traffic fees are paid by the bucket owner. Requester: request and traffic fees are paid by the requester.
 */
public data class BucketRequestPaymentArgs(
    public val bucket: Output<String>? = null,
    public val payer: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.BucketRequestPaymentArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.BucketRequestPaymentArgs =
        com.pulumi.alicloud.oss.BucketRequestPaymentArgs.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .payer(payer?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketRequestPaymentArgs].
 */
@PulumiTagMarker
public class BucketRequestPaymentArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var payer: Output<String>? = null

    /**
     * @param value The name of the bucket.
     */
    @JvmName("twwpuvtekffuxivn")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value The payer of the request and traffic fees.Valid values: BucketOwner: request and traffic fees are paid by the bucket owner. Requester: request and traffic fees are paid by the requester.
     */
    @JvmName("rpxyufarrqclweig")
    public suspend fun payer(`value`: Output<String>) {
        this.payer = value
    }

    /**
     * @param value The name of the bucket.
     */
    @JvmName("gsmbggnqfpomtito")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value The payer of the request and traffic fees.Valid values: BucketOwner: request and traffic fees are paid by the bucket owner. Requester: request and traffic fees are paid by the requester.
     */
    @JvmName("mxgjvfjoukdaxwmy")
    public suspend fun payer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payer = mapped
    }

    internal fun build(): BucketRequestPaymentArgs = BucketRequestPaymentArgs(
        bucket = bucket,
        payer = payer,
    )
}
