@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BucketTransferAcceleration].
 */
@PulumiTagMarker
public class BucketTransferAccelerationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketTransferAccelerationArgs = BucketTransferAccelerationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketTransferAccelerationArgsBuilder.() -> Unit) {
        val builder = BucketTransferAccelerationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BucketTransferAcceleration {
        val builtJavaResource =
            com.pulumi.alicloud.oss.BucketTransferAcceleration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BucketTransferAcceleration(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * OSS Bucket Transfer Acceleration can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oss/bucketTransferAcceleration:BucketTransferAcceleration example <id>
 * ```
 */
public class BucketTransferAcceleration internal constructor(
    override val javaResource: com.pulumi.alicloud.oss.BucketTransferAcceleration,
) : KotlinCustomResource(javaResource, BucketTransferAccelerationMapper) {
    /**
     * The name of the Bucket.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to enable transfer acceleration for the bucket. Valid values: true: transfer acceleration for the bucket is enabled. false: transfer acceleration for the bucket is disabled.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object BucketTransferAccelerationMapper : ResourceMapper<BucketTransferAcceleration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.oss.BucketTransferAcceleration::class == javaResource::class

    override fun map(javaResource: Resource): BucketTransferAcceleration =
        BucketTransferAcceleration(javaResource as com.pulumi.alicloud.oss.BucketTransferAcceleration)
}

/**
 * @see [BucketTransferAcceleration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketTransferAcceleration].
 */
public suspend fun bucketTransferAcceleration(
    name: String,
    block: suspend BucketTransferAccelerationResourceBuilder.() -> Unit,
): BucketTransferAcceleration {
    val builder = BucketTransferAccelerationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketTransferAcceleration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketTransferAcceleration(name: String): BucketTransferAcceleration {
    val builder = BucketTransferAccelerationResourceBuilder()
    builder.name(name)
    return builder.build()
}
