@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin

import com.pulumi.alicloud.oss.BucketTransferAccelerationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * OSS Bucket Transfer Acceleration can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oss/bucketTransferAcceleration:BucketTransferAcceleration example <id>
 * ```
 * @property bucket The name of the Bucket.
 * @property enabled Specifies whether to enable transfer acceleration for the bucket. Valid values: true: transfer acceleration for the bucket is enabled. false: transfer acceleration for the bucket is disabled.
 */
public data class BucketTransferAccelerationArgs(
    public val bucket: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.BucketTransferAccelerationArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.BucketTransferAccelerationArgs =
        com.pulumi.alicloud.oss.BucketTransferAccelerationArgs.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketTransferAccelerationArgs].
 */
@PulumiTagMarker
public class BucketTransferAccelerationArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value The name of the Bucket.
     */
    @JvmName("xwkgfevhfstkkkrj")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Specifies whether to enable transfer acceleration for the bucket. Valid values: true: transfer acceleration for the bucket is enabled. false: transfer acceleration for the bucket is disabled.
     */
    @JvmName("ajuxegegafnecukd")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The name of the Bucket.
     */
    @JvmName("bfwlxrovjjhgiawv")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Specifies whether to enable transfer acceleration for the bucket. Valid values: true: transfer acceleration for the bucket is enabled. false: transfer acceleration for the bucket is disabled.
     */
    @JvmName("hpxxbrouwgccogte")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): BucketTransferAccelerationArgs = BucketTransferAccelerationArgs(
        bucket = bucket,
        enabled = enabled,
    )
}
