@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BucketVersioning].
 */
@PulumiTagMarker
public class BucketVersioningResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketVersioningArgs = BucketVersioningArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketVersioningArgsBuilder.() -> Unit) {
        val builder = BucketVersioningArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BucketVersioning {
        val builtJavaResource = com.pulumi.alicloud.oss.BucketVersioning(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BucketVersioning(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * OSS Bucket Versioning can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oss/bucketVersioning:BucketVersioning example <id>
 * ```
 */
public class BucketVersioning internal constructor(
    override val javaResource: com.pulumi.alicloud.oss.BucketVersioning,
) : KotlinCustomResource(javaResource, BucketVersioningMapper) {
    /**
     * The name of the bucket.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * A bucket can be in one of the following versioning states: disabled, enabled, or suspended. By default, versioning is disabled for a bucket. Updating the value from Enabled or Suspended to Disabled will result in errors, because OSS does not support returning buckets to an unversioned state. .
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object BucketVersioningMapper : ResourceMapper<BucketVersioning> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.oss.BucketVersioning::class == javaResource::class

    override fun map(javaResource: Resource): BucketVersioning = BucketVersioning(
        javaResource as
            com.pulumi.alicloud.oss.BucketVersioning,
    )
}

/**
 * @see [BucketVersioning].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketVersioning].
 */
public suspend fun bucketVersioning(
    name: String,
    block: suspend BucketVersioningResourceBuilder.() -> Unit,
): BucketVersioning {
    val builder = BucketVersioningResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketVersioning].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketVersioning(name: String): BucketVersioning {
    val builder = BucketVersioningResourceBuilder()
    builder.name(name)
    return builder.build()
}
