@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin

import com.pulumi.alicloud.oss.BucketVersioningArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * OSS Bucket Versioning can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:oss/bucketVersioning:BucketVersioning example <id>
 * ```
 * @property bucket The name of the bucket.
 * @property status A bucket can be in one of the following versioning states: disabled, enabled, or suspended. By default, versioning is disabled for a bucket. Updating the value from Enabled or Suspended to Disabled will result in errors, because OSS does not support returning buckets to an unversioned state. .
 */
public data class BucketVersioningArgs(
    public val bucket: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.BucketVersioningArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.BucketVersioningArgs =
        com.pulumi.alicloud.oss.BucketVersioningArgs.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketVersioningArgs].
 */
@PulumiTagMarker
public class BucketVersioningArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value The name of the bucket.
     */
    @JvmName("ayevhjuejimrxecq")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value A bucket can be in one of the following versioning states: disabled, enabled, or suspended. By default, versioning is disabled for a bucket. Updating the value from Enabled or Suspended to Disabled will result in errors, because OSS does not support returning buckets to an unversioned state. .
     */
    @JvmName("pgxkxwpamgxqygbl")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The name of the bucket.
     */
    @JvmName("mufnjbeouoxrcsxj")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value A bucket can be in one of the following versioning states: disabled, enabled, or suspended. By default, versioning is disabled for a bucket. Updating the value from Enabled or Suspended to Disabled will result in errors, because OSS does not support returning buckets to an unversioned state. .
     */
    @JvmName("lyliqcvydsdeuqgd")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): BucketVersioningArgs = BucketVersioningArgs(
        bucket = bucket,
        status = status,
    )
}
