@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin

import com.pulumi.alicloud.oss.OssFunctions.getBucketObjectsPlain
import com.pulumi.alicloud.oss.OssFunctions.getBucketsPlain
import com.pulumi.alicloud.oss.OssFunctions.getInstanceAttachmentsPlain
import com.pulumi.alicloud.oss.OssFunctions.getInstancesPlain
import com.pulumi.alicloud.oss.OssFunctions.getServicePlain
import com.pulumi.alicloud.oss.OssFunctions.getTablesPlain
import com.pulumi.alicloud.oss.kotlin.inputs.GetBucketObjectsPlainArgs
import com.pulumi.alicloud.oss.kotlin.inputs.GetBucketObjectsPlainArgsBuilder
import com.pulumi.alicloud.oss.kotlin.inputs.GetBucketsPlainArgs
import com.pulumi.alicloud.oss.kotlin.inputs.GetBucketsPlainArgsBuilder
import com.pulumi.alicloud.oss.kotlin.inputs.GetInstanceAttachmentsPlainArgs
import com.pulumi.alicloud.oss.kotlin.inputs.GetInstanceAttachmentsPlainArgsBuilder
import com.pulumi.alicloud.oss.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.oss.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.oss.kotlin.inputs.GetServicePlainArgs
import com.pulumi.alicloud.oss.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.alicloud.oss.kotlin.inputs.GetTablesPlainArgs
import com.pulumi.alicloud.oss.kotlin.inputs.GetTablesPlainArgsBuilder
import com.pulumi.alicloud.oss.kotlin.outputs.GetBucketObjectsResult
import com.pulumi.alicloud.oss.kotlin.outputs.GetBucketsResult
import com.pulumi.alicloud.oss.kotlin.outputs.GetInstanceAttachmentsResult
import com.pulumi.alicloud.oss.kotlin.outputs.GetInstancesResult
import com.pulumi.alicloud.oss.kotlin.outputs.GetServiceResult
import com.pulumi.alicloud.oss.kotlin.outputs.GetTablesResult
import kotlinx.coroutines.future.await
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.oss.kotlin.outputs.GetBucketObjectsResult.Companion.toKotlin as getBucketObjectsResultToKotlin
import com.pulumi.alicloud.oss.kotlin.outputs.GetBucketsResult.Companion.toKotlin as getBucketsResultToKotlin
import com.pulumi.alicloud.oss.kotlin.outputs.GetInstanceAttachmentsResult.Companion.toKotlin as getInstanceAttachmentsResultToKotlin
import com.pulumi.alicloud.oss.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.alicloud.oss.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin
import com.pulumi.alicloud.oss.kotlin.outputs.GetTablesResult.Companion.toKotlin as getTablesResultToKotlin

public object OssFunctions {
    /**
     * This data source provides the objects of an OSS bucket.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const bucketObjectsDs = alicloud.oss.getBucketObjects({
     *     bucketName: "sample_bucket",
     *     keyRegex: "sample/sample_object.txt",
     * });
     * export const firstObjectKey = bucketObjectsDs.then(bucketObjectsDs => bucketObjectsDs.objects?.[0]?.key);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * bucket_objects_ds = alicloud.oss.get_bucket_objects(bucket_name="sample_bucket",
     *     key_regex="sample/sample_object.txt")
     * pulumi.export("firstObjectKey", bucket_objects_ds.objects[0].key)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var bucketObjectsDs = AliCloud.Oss.GetBucketObjects.Invoke(new()
     *     {
     *         BucketName = "sample_bucket",
     *         KeyRegex = "sample/sample_object.txt",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstObjectKey"] = bucketObjectsDs&#46;Apply(getBucketObjectsResult => getBucketObjectsResult&#46;Objects[0]?.Key),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		bucketObjectsDs, err := oss.GetBucketObjects(ctx, &oss.GetBucketObjectsArgs{
     * 			BucketName: "sample_bucket",
     * 			KeyRegex:   pulumi.StringRef("sample/sample_object.txt"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstObjectKey", bucketObjectsDs.Objects[0].Key)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.oss.OssFunctions;
     * import com.pulumi.alicloud.oss.inputs.GetBucketObjectsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var bucketObjectsDs = OssFunctions.getBucketObjects(GetBucketObjectsArgs.builder()
     *             .bucketName("sample_bucket")
     *             .keyRegex("sample/sample_object.txt")
     *             .build());
     *         ctx.export("firstObjectKey", bucketObjectsDs.applyValue(getBucketObjectsResult -> getBucketObjectsResult.objects()[0].key()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   bucketObjectsDs:
     *     fn::invoke:
     *       Function: alicloud:oss:getBucketObjects
     *       Arguments:
     *         bucketName: sample_bucket
     *         keyRegex: sample/sample_object.txt
     * outputs:
     *   firstObjectKey: ${bucketObjectsDs.objects[0].key}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBucketObjects.
     * @return A collection of values returned by getBucketObjects.
     */
    public suspend fun getBucketObjects(argument: GetBucketObjectsPlainArgs): GetBucketObjectsResult =
        getBucketObjectsResultToKotlin(getBucketObjectsPlain(argument.toJava()).await())

    /**
     * @see [getBucketObjects].
     * @param bucketName Name of the bucket that contains the objects to find.
     * @param keyPrefix Filter results by the given key prefix (such as "path/to/folder/logs-").
     * @param keyRegex A regex string to filter results by key.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getBucketObjects.
     */
    public suspend fun getBucketObjects(
        bucketName: String,
        keyPrefix: String? = null,
        keyRegex: String? = null,
        outputFile: String? = null,
    ): GetBucketObjectsResult {
        val argument = GetBucketObjectsPlainArgs(
            bucketName = bucketName,
            keyPrefix = keyPrefix,
            keyRegex = keyRegex,
            outputFile = outputFile,
        )
        return getBucketObjectsResultToKotlin(getBucketObjectsPlain(argument.toJava()).await())
    }

    /**
     * @see [getBucketObjects].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;oss&#46;kotlin&#46;inputs&#46;GetBucketObjectsPlainArgs].
     * @return A collection of values returned by getBucketObjects.
     */
    public suspend fun getBucketObjects(argument: suspend GetBucketObjectsPlainArgsBuilder.() -> Unit): GetBucketObjectsResult {
        val builder = GetBucketObjectsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBucketObjectsResultToKotlin(getBucketObjectsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the OSS buckets of the current Alibaba Cloud user.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ossBucketsDs = alicloud.oss.getBuckets({
     *     nameRegex: "sample_oss_bucket",
     * });
     * export const firstOssBucketName = ossBucketsDs.then(ossBucketsDs => ossBucketsDs.buckets?.[0]?.name);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * oss_buckets_ds = alicloud.oss.get_buckets(name_regex="sample_oss_bucket")
     * pulumi.export("firstOssBucketName", oss_buckets_ds.buckets[0].name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ossBucketsDs = AliCloud.Oss.GetBuckets.Invoke(new()
     *     {
     *         NameRegex = "sample_oss_bucket",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstOssBucketName"] = ossBucketsDs&#46;Apply(getBucketsResult => getBucketsResult&#46;Buckets[0]?.Name),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ossBucketsDs, err := oss.GetBuckets(ctx, &oss.GetBucketsArgs{
     * 			NameRegex: pulumi.StringRef("sample_oss_bucket"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstOssBucketName", ossBucketsDs.Buckets[0].Name)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.oss.OssFunctions;
     * import com.pulumi.alicloud.oss.inputs.GetBucketsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ossBucketsDs = OssFunctions.getBuckets(GetBucketsArgs.builder()
     *             .nameRegex("sample_oss_bucket")
     *             .build());
     *         ctx.export("firstOssBucketName", ossBucketsDs.applyValue(getBucketsResult -> getBucketsResult.buckets()[0].name()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ossBucketsDs:
     *     fn::invoke:
     *       Function: alicloud:oss:getBuckets
     *       Arguments:
     *         nameRegex: sample_oss_bucket
     * outputs:
     *   firstOssBucketName: ${ossBucketsDs.buckets[0].name}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBuckets.
     * @return A collection of values returned by getBuckets.
     */
    public suspend fun getBuckets(argument: GetBucketsPlainArgs): GetBucketsResult =
        getBucketsResultToKotlin(getBucketsPlain(argument.toJava()).await())

    /**
     * @see [getBuckets].
     * @param nameRegex A regex string to filter results by bucket name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getBuckets.
     */
    public suspend fun getBuckets(nameRegex: String? = null, outputFile: String? = null): GetBucketsResult {
        val argument = GetBucketsPlainArgs(
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getBucketsResultToKotlin(getBucketsPlain(argument.toJava()).await())
    }

    /**
     * @see [getBuckets].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;oss&#46;kotlin&#46;inputs&#46;GetBucketsPlainArgs].
     * @return A collection of values returned by getBuckets.
     */
    public suspend fun getBuckets(argument: suspend GetBucketsPlainArgsBuilder.() -> Unit): GetBucketsResult {
        val builder = GetBucketsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBucketsResultToKotlin(getBucketsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the ots instance attachments of the current Alibaba Cloud user.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const attachmentsDs = alicloud.ots.getInstanceAttachments({
     *     instanceName: "sample-instance",
     *     nameRegex: "testvpc",
     *     outputFile: "attachments.txt",
     * });
     * export const firstOtsAttachmentId = attachmentsDs.then(attachmentsDs => attachmentsDs.attachments?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * attachments_ds = alicloud.ots.get_instance_attachments(instance_name="sample-instance",
     *     name_regex="testvpc",
     *     output_file="attachments.txt")
     * pulumi.export("firstOtsAttachmentId", attachments_ds.attachments[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var attachmentsDs = AliCloud.Ots.GetInstanceAttachments.Invoke(new()
     *     {
     *         InstanceName = "sample-instance",
     *         NameRegex = "testvpc",
     *         OutputFile = "attachments.txt",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstOtsAttachmentId"] = attachmentsDs&#46;Apply(getInstanceAttachmentsResult => getInstanceAttachmentsResult&#46;Attachments[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ots"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		attachmentsDs, err := ots.GetInstanceAttachments(ctx, &ots.GetInstanceAttachmentsArgs{
     * 			InstanceName: "sample-instance",
     * 			NameRegex:    pulumi.StringRef("testvpc"),
     * 			OutputFile:   pulumi.StringRef("attachments.txt"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstOtsAttachmentId", attachmentsDs.Attachments[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ots.OtsFunctions;
     * import com.pulumi.alicloud.ots.inputs.GetInstanceAttachmentsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var attachmentsDs = OtsFunctions.getInstanceAttachments(GetInstanceAttachmentsArgs.builder()
     *             .instanceName("sample-instance")
     *             .nameRegex("testvpc")
     *             .outputFile("attachments.txt")
     *             .build());
     *         ctx.export("firstOtsAttachmentId", attachmentsDs.applyValue(getInstanceAttachmentsResult -> getInstanceAttachmentsResult.attachments()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   attachmentsDs:
     *     fn::invoke:
     *       Function: alicloud:ots:getInstanceAttachments
     *       Arguments:
     *         instanceName: sample-instance
     *         nameRegex: testvpc
     *         outputFile: attachments.txt
     * outputs:
     *   firstOtsAttachmentId: ${attachmentsDs.attachments[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstanceAttachments.
     * @return A collection of values returned by getInstanceAttachments.
     */
    @Deprecated(
        message = """
  alicloud.oss.getInstanceAttachments has been deprecated in favor of
      alicloud.ots.getInstanceAttachments
  """,
    )
    public suspend fun getInstanceAttachments(argument: GetInstanceAttachmentsPlainArgs): GetInstanceAttachmentsResult =
        getInstanceAttachmentsResultToKotlin(getInstanceAttachmentsPlain(argument.toJava()).await())

    /**
     * @see [getInstanceAttachments].
     * @param instanceName The name of OTS instance.
     * @param nameRegex A regex string to filter results by vpc name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getInstanceAttachments.
     */
    @Deprecated(
        message = """
  alicloud.oss.getInstanceAttachments has been deprecated in favor of
      alicloud.ots.getInstanceAttachments
  """,
    )
    public suspend fun getInstanceAttachments(
        instanceName: String,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetInstanceAttachmentsResult {
        val argument = GetInstanceAttachmentsPlainArgs(
            instanceName = instanceName,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getInstanceAttachmentsResultToKotlin(getInstanceAttachmentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceAttachments].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;oss&#46;kotlin&#46;inputs&#46;GetInstanceAttachmentsPlainArgs].
     * @return A collection of values returned by getInstanceAttachments.
     */
    @Deprecated(
        message = """
  alicloud.oss.getInstanceAttachments has been deprecated in favor of
      alicloud.ots.getInstanceAttachments
  """,
    )
    public suspend fun getInstanceAttachments(argument: suspend GetInstanceAttachmentsPlainArgsBuilder.() -> Unit): GetInstanceAttachmentsResult {
        val builder = GetInstanceAttachmentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceAttachmentsResultToKotlin(getInstanceAttachmentsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the ots instances of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.40.0.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const instancesDs = alicloud.ots.getInstances({
     *     outputFile: "instances.txt",
     * });
     * export const firstInstanceId = instancesDs.then(instancesDs => instancesDs.instances?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * instances_ds = alicloud.ots.get_instances(output_file="instances.txt")
     * pulumi.export("firstInstanceId", instances_ds.instances[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var instancesDs = AliCloud.Ots.GetInstances.Invoke(new()
     *     {
     *         OutputFile = "instances.txt",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstInstanceId"] = instancesDs&#46;Apply(getInstancesResult => getInstancesResult&#46;Instances[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ots"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		instancesDs, err := ots.GetInstances(ctx, &ots.GetInstancesArgs{
     * 			OutputFile: pulumi.StringRef("instances.txt"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstInstanceId", instancesDs.Instances[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ots.OtsFunctions;
     * import com.pulumi.alicloud.ots.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var instancesDs = OtsFunctions.getInstances(GetInstancesArgs.builder()
     *             .outputFile("instances.txt")
     *             .build());
     *         ctx.export("firstInstanceId", instancesDs.applyValue(getInstancesResult -> getInstancesResult.instances()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   instancesDs:
     *     fn::invoke:
     *       Function: alicloud:ots:getInstances
     *       Arguments:
     *         outputFile: instances.txt
     * outputs:
     *   firstInstanceId: ${instancesDs.instances[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    @Deprecated(
        message = """
  alicloud.oss.getInstances has been deprecated in favor of alicloud.ots.getInstances
  """,
    )
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param ids A list of instance IDs.
     * @param nameRegex A regex string to filter results by instance name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param tags A map of tags assigned to the instance. It must be in the format:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const instancesDs = alicloud.ots.getInstances({
     *     tags: {
     *         tagKey1: "tagValue1",
     *         tagKey2: "tagValue2",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * instances_ds = alicloud.ots.get_instances(tags={
     *     "tagKey1": "tagValue1",
     *     "tagKey2": "tagValue2",
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var instancesDs = AliCloud.Ots.GetInstances.Invoke(new()
     *     {
     *         Tags =
     *         {
     *             { "tagKey1", "tagValue1" },
     *             { "tagKey2", "tagValue2" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ots"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ots.GetInstances(ctx, &ots.GetInstancesArgs{
     * 			Tags: map[string]interface{}{
     * 				"tagKey1": "tagValue1",
     * 				"tagKey2": "tagValue2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ots.OtsFunctions;
     * import com.pulumi.alicloud.ots.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var instancesDs = OtsFunctions.getInstances(GetInstancesArgs.builder()
     *             .tags(Map.ofEntries(
     *                 Map.entry("tagKey1", "tagValue1"),
     *                 Map.entry("tagKey2", "tagValue2")
     *             ))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   instancesDs:
     *     fn::invoke:
     *       Function: alicloud:ots:getInstances
     *       Arguments:
     *         tags:
     *           tagKey1: tagValue1
     *           tagKey2: tagValue2
     * ```
     * <!--End PulumiCodeChooser -->
     * @return A collection of values returned by getInstances.
     */
    @Deprecated(
        message = """
  alicloud.oss.getInstances has been deprecated in favor of alicloud.ots.getInstances
  """,
    )
    public suspend fun getInstances(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        tags: Map<String, String>? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            tags = tags,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;oss&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    @Deprecated(
        message = """
  alicloud.oss.getInstances has been deprecated in favor of alicloud.ots.getInstances
  """,
    )
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can enable OSS service automatically. If the service has been enabled, it will return `Opened`.
     * For information about OSS and how to use it, see [What is OSS](https://www.alibabacloud.com/help/product/31815.htm).
     * > **NOTE:** Available in v1.97.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.oss.getService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.oss.get_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.Oss.GetService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := oss.GetService(ctx, &oss.GetServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.oss.OssFunctions;
     * import com.pulumi.alicloud.oss.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = OssFunctions.getService(GetServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:oss:getService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: "On" or "Off". Default to "Off".
     * > **NOTE:** Setting `enable = "On"` to open the OSS service that means you have read and agreed the [OSS Terms of Service](https://help.aliyun.com/document_detail/31821.html). The service can not closed once it is opened.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(enable: String? = null): GetServiceResult {
        val argument = GetServicePlainArgs(
            enable = enable,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;oss&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the ots tables of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.40.0+.
     * ## Example Usage
     * ``` terraform
     * data "alicloud_ots_tables" "tables_ds" {
     *   instance_name = "sample-instance"
     *   name_regex    = "sample-table"
     *   output_file   = "tables.txt"
     * }
     * output "first_table_id" {
     *   value = "${data.alicloud_ots_tables.tables_ds.tables.0.id}"
     * }
     * ```
     * @param argument A collection of arguments for invoking getTables.
     * @return A collection of values returned by getTables.
     */
    @Deprecated(
        message = """
  alicloud.oss.getTables has been deprecated in favor of alicloud.ots.getTables
  """,
    )
    public suspend fun getTables(argument: GetTablesPlainArgs): GetTablesResult =
        getTablesResultToKotlin(getTablesPlain(argument.toJava()).await())

    /**
     * @see [getTables].
     * @param ids A list of table IDs.
     * @param instanceName The name of OTS instance.
     * @param nameRegex A regex string to filter results by table name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getTables.
     */
    @Deprecated(
        message = """
  alicloud.oss.getTables has been deprecated in favor of alicloud.ots.getTables
  """,
    )
    public suspend fun getTables(
        ids: List<String>? = null,
        instanceName: String,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetTablesResult {
        val argument = GetTablesPlainArgs(
            ids = ids,
            instanceName = instanceName,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getTablesResultToKotlin(getTablesPlain(argument.toJava()).await())
    }

    /**
     * @see [getTables].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;oss&#46;kotlin&#46;inputs&#46;GetTablesPlainArgs].
     * @return A collection of values returned by getTables.
     */
    @Deprecated(
        message = """
  alicloud.oss.getTables has been deprecated in favor of alicloud.ots.getTables
  """,
    )
    public suspend fun getTables(argument: suspend GetTablesPlainArgsBuilder.() -> Unit): GetTablesResult {
        val builder = GetTablesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTablesResultToKotlin(getTablesPlain(builtArgument.toJava()).await())
    }
}
