@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.inputs

import com.pulumi.alicloud.oss.inputs.BucketAccessMonitorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property status The access monitor state of a bucket. If you want to manage objects based on the last access time of the objects, specifies the status to `Enabled`. Valid values: `Enabled` and `Disabled`.
 */
public data class BucketAccessMonitorArgs(
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.inputs.BucketAccessMonitorArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.inputs.BucketAccessMonitorArgs =
        com.pulumi.alicloud.oss.inputs.BucketAccessMonitorArgs.builder()
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketAccessMonitorArgs].
 */
@PulumiTagMarker
public class BucketAccessMonitorArgsBuilder internal constructor() {
    private var status: Output<String>? = null

    /**
     * @param value The access monitor state of a bucket. If you want to manage objects based on the last access time of the objects, specifies the status to `Enabled`. Valid values: `Enabled` and `Disabled`.
     */
    @JvmName("wfrrcdngumfmwurm")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The access monitor state of a bucket. If you want to manage objects based on the last access time of the objects, specifies the status to `Enabled`. Valid values: `Enabled` and `Disabled`.
     */
    @JvmName("khecayvombiiphll")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): BucketAccessMonitorArgs = BucketAccessMonitorArgs(
        status = status,
    )
}
