@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.oss.kotlin.inputs

import com.pulumi.alicloud.oss.inputs.BucketCorsCorsRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowedHeaders Specifies whether the headers specified by Access-Control-Request-Headers in the OPTIONS preflight request are allowed. You can use only one asterisk (*) as the wildcard for allowed header. .
 * @property allowedMethods The cross-origin request method that is allowed. Valid values: GET, PUT, DELETE, POST, and HEAD.
 * @property allowedOrigins The origins from which cross-origin requests are allowed. .
 * @property exposeHeaders The response headers for allowed access requests from applications, such as an XMLHttpRequest object in JavaScript. .
 * @property maxAgeSeconds The period of time within which the browser can cache the response to an OPTIONS preflight request for the specified resource. Unit: seconds.
 */
public data class BucketCorsCorsRuleArgs(
    public val allowedHeaders: Output<List<String>>? = null,
    public val allowedMethods: Output<List<String>>,
    public val allowedOrigins: Output<List<String>>? = null,
    public val exposeHeaders: Output<List<String>>? = null,
    public val maxAgeSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.oss.inputs.BucketCorsCorsRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.oss.inputs.BucketCorsCorsRuleArgs =
        com.pulumi.alicloud.oss.inputs.BucketCorsCorsRuleArgs.builder()
            .allowedHeaders(allowedHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedMethods(allowedMethods.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedOrigins(allowedOrigins?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .exposeHeaders(exposeHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .maxAgeSeconds(maxAgeSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketCorsCorsRuleArgs].
 */
@PulumiTagMarker
public class BucketCorsCorsRuleArgsBuilder internal constructor() {
    private var allowedHeaders: Output<List<String>>? = null

    private var allowedMethods: Output<List<String>>? = null

    private var allowedOrigins: Output<List<String>>? = null

    private var exposeHeaders: Output<List<String>>? = null

    private var maxAgeSeconds: Output<Int>? = null

    /**
     * @param value Specifies whether the headers specified by Access-Control-Request-Headers in the OPTIONS preflight request are allowed. You can use only one asterisk (*) as the wildcard for allowed header. .
     */
    @JvmName("jrmvvtjecpwryebl")
    public suspend fun allowedHeaders(`value`: Output<List<String>>) {
        this.allowedHeaders = value
    }

    @JvmName("orgckhkopnblkjsb")
    public suspend fun allowedHeaders(vararg values: Output<String>) {
        this.allowedHeaders = Output.all(values.asList())
    }

    /**
     * @param values Specifies whether the headers specified by Access-Control-Request-Headers in the OPTIONS preflight request are allowed. You can use only one asterisk (*) as the wildcard for allowed header. .
     */
    @JvmName("iwafgdupqetxdfeq")
    public suspend fun allowedHeaders(values: List<Output<String>>) {
        this.allowedHeaders = Output.all(values)
    }

    /**
     * @param value The cross-origin request method that is allowed. Valid values: GET, PUT, DELETE, POST, and HEAD.
     */
    @JvmName("dgrjowvugvcsdccc")
    public suspend fun allowedMethods(`value`: Output<List<String>>) {
        this.allowedMethods = value
    }

    @JvmName("dflubbjcfwuwtihk")
    public suspend fun allowedMethods(vararg values: Output<String>) {
        this.allowedMethods = Output.all(values.asList())
    }

    /**
     * @param values The cross-origin request method that is allowed. Valid values: GET, PUT, DELETE, POST, and HEAD.
     */
    @JvmName("aydqcggofboxckrb")
    public suspend fun allowedMethods(values: List<Output<String>>) {
        this.allowedMethods = Output.all(values)
    }

    /**
     * @param value The origins from which cross-origin requests are allowed. .
     */
    @JvmName("juqytyhlpgcsxoyi")
    public suspend fun allowedOrigins(`value`: Output<List<String>>) {
        this.allowedOrigins = value
    }

    @JvmName("dwnfdyulnegjtbou")
    public suspend fun allowedOrigins(vararg values: Output<String>) {
        this.allowedOrigins = Output.all(values.asList())
    }

    /**
     * @param values The origins from which cross-origin requests are allowed. .
     */
    @JvmName("fjwvddoysuuwtmcu")
    public suspend fun allowedOrigins(values: List<Output<String>>) {
        this.allowedOrigins = Output.all(values)
    }

    /**
     * @param value The response headers for allowed access requests from applications, such as an XMLHttpRequest object in JavaScript. .
     */
    @JvmName("pqdgbchfghqmaisp")
    public suspend fun exposeHeaders(`value`: Output<List<String>>) {
        this.exposeHeaders = value
    }

    @JvmName("mdajahamcbvdckiv")
    public suspend fun exposeHeaders(vararg values: Output<String>) {
        this.exposeHeaders = Output.all(values.asList())
    }

    /**
     * @param values The response headers for allowed access requests from applications, such as an XMLHttpRequest object in JavaScript. .
     */
    @JvmName("qrmgdruiwyhkvooa")
    public suspend fun exposeHeaders(values: List<Output<String>>) {
        this.exposeHeaders = Output.all(values)
    }

    /**
     * @param value The period of time within which the browser can cache the response to an OPTIONS preflight request for the specified resource. Unit: seconds.
     */
    @JvmName("rpkdvoclmxtyuvjy")
    public suspend fun maxAgeSeconds(`value`: Output<Int>) {
        this.maxAgeSeconds = value
    }

    /**
     * @param value Specifies whether the headers specified by Access-Control-Request-Headers in the OPTIONS preflight request are allowed. You can use only one asterisk (*) as the wildcard for allowed header. .
     */
    @JvmName("bscxhbngqqdyojmj")
    public suspend fun allowedHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedHeaders = mapped
    }

    /**
     * @param values Specifies whether the headers specified by Access-Control-Request-Headers in the OPTIONS preflight request are allowed. You can use only one asterisk (*) as the wildcard for allowed header. .
     */
    @JvmName("qbcpikaikteqvmbb")
    public suspend fun allowedHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedHeaders = mapped
    }

    /**
     * @param value The cross-origin request method that is allowed. Valid values: GET, PUT, DELETE, POST, and HEAD.
     */
    @JvmName("xtxqnscsmwygsueh")
    public suspend fun allowedMethods(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedMethods = mapped
    }

    /**
     * @param values The cross-origin request method that is allowed. Valid values: GET, PUT, DELETE, POST, and HEAD.
     */
    @JvmName("mwnlaafdplxugeck")
    public suspend fun allowedMethods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedMethods = mapped
    }

    /**
     * @param value The origins from which cross-origin requests are allowed. .
     */
    @JvmName("jtlirnlhqeiddrsp")
    public suspend fun allowedOrigins(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedOrigins = mapped
    }

    /**
     * @param values The origins from which cross-origin requests are allowed. .
     */
    @JvmName("rxldpcacgvkurcma")
    public suspend fun allowedOrigins(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedOrigins = mapped
    }

    /**
     * @param value The response headers for allowed access requests from applications, such as an XMLHttpRequest object in JavaScript. .
     */
    @JvmName("fjotosrcprwgreuu")
    public suspend fun exposeHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exposeHeaders = mapped
    }

    /**
     * @param values The response headers for allowed access requests from applications, such as an XMLHttpRequest object in JavaScript. .
     */
    @JvmName("fivkoxosasvwjfiy")
    public suspend fun exposeHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exposeHeaders = mapped
    }

    /**
     * @param value The period of time within which the browser can cache the response to an OPTIONS preflight request for the specified resource. Unit: seconds.
     */
    @JvmName("dnvircseqaoulkpq")
    public suspend fun maxAgeSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxAgeSeconds = mapped
    }

    internal fun build(): BucketCorsCorsRuleArgs = BucketCorsCorsRuleArgs(
        allowedHeaders = allowedHeaders,
        allowedMethods = allowedMethods ?: throw PulumiNullFieldException("allowedMethods"),
        allowedOrigins = allowedOrigins,
        exposeHeaders = exposeHeaders,
        maxAgeSeconds = maxAgeSeconds,
    )
}
